/*
 * Decompiled with CFR 0.152.
 */
package mconv;

import com.ibm.icu.text.Normalizer;
import jargs.gnu.CmdLineParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.marc4j.MarcReader;
import org.marc4j.MarcStreamReader;
import org.marc4j.MarcStreamWriter;
import org.marc4j.MarcWriter;
import org.marc4j.MarcXmlReader;
import org.marc4j.MarcXmlWriter;
import org.marc4j.converter.CharConverter;
import org.marc4j.converter.impl.AnselToUnicode;
import org.marc4j.converter.impl.UnicodeToAnsel;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;
import org.marc4j.marc.impl.LeaderImpl;

public class MarcConverter {
    public static final int USMARC = 1;
    public static final int MARC21 = 1;
    public static final int MARCXML = 2;
    private int in_syntax;
    private String in_encoding;
    private MarcReader reader;
    private int out_syntax;
    private String out_encoding;
    private char out_encoding_char;
    private MarcWriter writer;
    private CharConverter converter;
    private boolean normalization_NFC = false;

    public MarcConverter() {
        this.init();
    }

    public MarcConverter(String inFile, String outFile, String inSyntax, String outSyntax, String inEncoding, String outEncoding) {
        this.init();
        boolean isInput = true;
        this.set_syntax(inSyntax, isInput);
        this.set_syntax(outSyntax, !isInput);
        this.set_encoding(inEncoding, isInput);
        this.set_encoding(outEncoding, !isInput);
        this.set_converter();
        this.set_reader(inFile);
        this.set_writer(outFile);
    }

    private void init() {
        this.in_syntax = 0;
        this.in_encoding = null;
        this.reader = null;
        this.out_syntax = 0;
        this.out_encoding = null;
        this.out_encoding_char = (char)95;
        this.writer = null;
        this.converter = null;
    }

    private boolean set_syntax(String syntax, boolean isInput) {
        if (syntax == null) {
            return false;
        }
        int st = 0;
        if (syntax.compareToIgnoreCase("marcxml") == 0) {
            st = 2;
        } else if (syntax.compareToIgnoreCase("marc21") == 0 || syntax.compareToIgnoreCase("usmarc") == 0) {
            st = 1;
        } else {
            return false;
        }
        if (isInput) {
            this.in_syntax = st;
        } else {
            this.out_syntax = st;
        }
        return true;
    }

    private boolean set_encoding(String encoding, boolean isInput) {
        if (encoding == null) {
            return false;
        }
        String cs = null;
        int ec = 95;
        if (encoding.compareToIgnoreCase("UTF-8") == 0) {
            cs = "UTF-8";
            ec = 97;
        } else if (encoding.compareToIgnoreCase("ISO-8859-1") == 0) {
            cs = "ISO-8859-1";
            ec = 32;
        } else {
            return false;
        }
        if (isInput) {
            this.in_encoding = cs;
        } else {
            this.out_encoding = cs;
            this.out_encoding_char = (char)ec;
        }
        return true;
    }

    private boolean set_converter() {
        if (this.in_encoding == null || this.out_encoding == null || this.in_encoding.equalsIgnoreCase(this.out_encoding)) {
            return false;
        }
        if (this.out_encoding.equalsIgnoreCase("ISO-8859-1")) {
            this.converter = new UnicodeToAnsel();
        } else if (this.out_encoding.equalsIgnoreCase("UTF-8")) {
            this.converter = new AnselToUnicode();
        }
        this.normalization_NFC = this.out_encoding.equalsIgnoreCase("UTF-8");
        return true;
    }

    private boolean set_reader(String filename) {
        File file = new File(filename);
        if (!file.exists()) {
            return false;
        }
        FileInputStream is = null;
        try {
            if (this.in_syntax == 2) {
                file = this.stripNonValidXMLCharacters(file);
            }
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        switch (this.in_syntax) {
            case 1: {
                this.reader = new MarcStreamReader((InputStream)is, this.in_encoding);
                break;
            }
            default: {
                this.reader = new MarcXmlReader((InputStream)is);
            }
        }
        return true;
    }

    private boolean set_writer(String filename) {
        File file = new File(filename);
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        switch (this.out_syntax) {
            case 2: {
                this.writer = new MarcXmlWriter((OutputStream)os, this.out_encoding, true);
                break;
            }
            default: {
                this.writer = new MarcStreamWriter((OutputStream)os, this.out_encoding);
            }
        }
        return true;
    }

    private File stripNonValidXMLCharacters(File in) {
        File out = new File(in.getPath() + ".valid_xml");
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            br = new BufferedReader(new FileReader(in));
            bw = new BufferedWriter(new FileWriter(out));
            String line = null;
            while ((line = br.readLine()) != null) {
                bw.write(this.stripNonValidXMLCharacters(line, false) + "\n");
            }
            br.close();
            bw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out;
    }

    private String stripNonValidXMLCharacters(String in, boolean converted) {
        String str;
        StringBuffer out = new StringBuffer();
        if (in == null || "".equals(in)) {
            return "";
        }
        if (this.converter != null) {
            if (this.in_encoding.compareTo("UTF-8") == 0) {
                if (converted) {
                    str = Normalizer.normalize((String)in, (Normalizer.Mode)Normalizer.NFD);
                    str = this.converter.convert(str);
                } else {
                    str = in;
                }
            } else {
                str = this.converter.convert(in);
            }
            if (this.normalization_NFC) {
                str = Normalizer.normalize((String)str, (Normalizer.Mode)Normalizer.NFC);
            }
        } else {
            str = in;
        }
        for (int i = 0; i < str.length(); ++i) {
            char current = str.charAt(i);
            if (!this.isValidXMLCharacters(current)) continue;
            out.append(current);
        }
        return out.toString();
    }

    private boolean isValidXMLCharacters(char c) {
        return c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff';
    }

    public Leader getOpalsLeader(boolean isUnicode) {
        if (isUnicode) {
            return new LeaderImpl("00000nam a2200157 a 4500");
        }
        return new LeaderImpl("00000nam  2200157 a 4500");
    }

    private void removeBadChar(Record rec) {
        String tag;
        int i;
        String str;
        Leader leader = rec.getLeader();
        String data = leader.toString();
        if (data.compareTo(str = this.stripNonValidXMLCharacters(data, true)) == 0) {
            leader.setCharCodingScheme(this.out_encoding_char);
            rec.setLeader(leader);
        } else {
            rec.setLeader(this.getOpalsLeader(true));
        }
        List list = rec.getControlFields();
        for (i = 0; i < list.size(); ++i) {
            VariableField vf = (VariableField)list.get(i);
            tag = this.stripNonValidXMLCharacters(vf.getTag(), true);
            if (tag.length() != 3) {
                rec.removeVariableField(vf);
                continue;
            }
            ControlField cf = (ControlField)vf;
            data = this.stripNonValidXMLCharacters(cf.getData(), true);
            cf.setData(data);
        }
        list = rec.getDataFields();
        for (i = 0; i < list.size(); ++i) {
            DataField df = (DataField)list.get(i);
            tag = this.stripNonValidXMLCharacters(df.getTag(), true);
            if (tag.length() != 3) {
                rec.removeVariableField((VariableField)df);
                continue;
            }
            char ind1 = df.getIndicator1();
            char ind2 = df.getIndicator2();
            if (!this.isValidXMLCharacters(ind1)) {
                df.setIndicator1(' ');
            }
            if (!this.isValidXMLCharacters(ind2)) {
                df.setIndicator2(' ');
            }
            List sfs = df.getSubfields();
            for (int j = 0; j < sfs.size(); ++j) {
                Subfield sf = (Subfield)sfs.get(j);
                char code = sf.getCode();
                if (!this.isValidXMLCharacters(code)) {
                    sf.setCode('a');
                }
                data = this.stripNonValidXMLCharacters(sf.getData(), true);
                sf.setData(data);
            }
        }
    }

    public void convert() {
        int c = 0;
        while (this.reader.hasNext()) {
            ++c;
            Record rec = this.reader.next();
            this.removeBadChar(rec);
            this.writer.write(rec);
        }
        this.writer.close();
    }

    private static void printUsage() {
        System.err.println("Usage: mconv ");
    }

    public static void main(String[] args) {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option infile_opt = parser.addStringOption('i', "in-file");
        CmdLineParser.Option insyntax_opt = parser.addStringOption('s', "in-syntax");
        CmdLineParser.Option inencoding_opt = parser.addStringOption('e', "in-encoding");
        CmdLineParser.Option outfile_opt = parser.addStringOption('o', "out-file");
        CmdLineParser.Option outsyntax_opt = parser.addStringOption('x', "out-syntax");
        CmdLineParser.Option outencoding_opt = parser.addStringOption('g', "out-encoding");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            MarcConverter.printUsage();
            System.exit(2);
        }
        String infile = (String)parser.getOptionValue(infile_opt);
        String insyntax = (String)parser.getOptionValue(insyntax_opt);
        String inencoding = (String)parser.getOptionValue(inencoding_opt);
        String outfile = (String)parser.getOptionValue(outfile_opt);
        String outsyntax = (String)parser.getOptionValue(outsyntax_opt);
        String outencoding = (String)parser.getOptionValue(outencoding_opt);
        MarcConverter mc = new MarcConverter(infile, outfile, insyntax, outsyntax, inencoding, outencoding);
        mc.convert();
    }
}

