/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Hashtable;
import org.marc4j.MarcException;
import org.marc4j.MarcReader;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.MarcFactory;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.impl.Verifier;

public class MarcStreamReader
implements MarcReader {
    private InputStream input = null;
    private Record record;
    private MarcFactory factory;
    private String encoding = "ISO8859_1";
    private boolean override = false;
    private boolean hasNext = true;

    public MarcStreamReader(InputStream input) {
        this(input, null);
    }

    public MarcStreamReader(InputStream input, String encoding) {
        this.input = input;
        this.factory = MarcFactory.newInstance();
        if (encoding != null) {
            this.encoding = encoding;
            this.override = true;
        }
    }

    public boolean hasNext() {
        try {
            if (this.input.available() == 0) {
                return false;
            }
        }
        catch (IOException e) {
            throw new MarcException(e.getMessage(), e);
        }
        return true;
    }

    public Record next() {
        int bytesRead = 0;
        this.record = this.factory.newRecord();
        try {
            int i;
            Leader ldr;
            byte[] byteArray = new byte[24];
            if (bytesRead == -1) {
                throw new MarcException("no data to read");
            }
            for (bytesRead = this.input.read(byteArray); bytesRead != -1 && bytesRead != byteArray.length; bytesRead += this.input.read(byteArray, bytesRead, byteArray.length - bytesRead)) {
            }
            try {
                ldr = this.parseLeader(byteArray);
            }
            catch (IOException e) {
                throw new MarcException("error parsing leader with data: " + new String(byteArray), e);
            }
            switch (ldr.getCharCodingScheme()) {
                case ' ': {
                    if (this.override) break;
                    this.encoding = "ISO8859_1";
                    break;
                }
                case 'a': {
                    if (this.override) break;
                    this.encoding = "UTF8";
                }
            }
            this.record.setLeader(ldr);
            int directoryLength = ldr.getBaseAddressOfData() - 25;
            if (directoryLength % 12 != 0) {
                throw new MarcException("invalid directory");
            }
            int size = directoryLength / 12;
            String[] tags = new String[size];
            int[] lengths = new int[size];
            int[] starts = new int[size];
            Hashtable<Integer, Integer> starts_index = new Hashtable<Integer, Integer>();
            byte[] tag = new byte[3];
            byte[] length = new byte[4];
            byte[] start = new byte[5];
            for (i = 0; i < size; ++i) {
                String tmp;
                for (bytesRead = this.input.read(tag); bytesRead != -1 && bytesRead != tag.length; bytesRead += this.input.read(tag, bytesRead, tag.length - bytesRead)) {
                }
                tags[i] = tmp = new String(tag);
                for (bytesRead = this.input.read(length); bytesRead != -1 && bytesRead != length.length; bytesRead += this.input.read(length, bytesRead, length.length - bytesRead)) {
                }
                tmp = new String(length);
                lengths[i] = Integer.parseInt(tmp);
                for (bytesRead = this.input.read(start); bytesRead != -1 && bytesRead != start.length; bytesRead += this.input.read(start, bytesRead, start.length - bytesRead)) {
                }
                tmp = new String(start);
                starts[i] = Integer.parseInt(tmp);
                starts_index.put(starts[i], i);
            }
            Arrays.sort(starts);
            if (this.input.read() != 30) {
                throw new MarcException("expected field terminator at end of directory");
            }
            i = 0;
            boolean isCtrlField = false;
            for (int o = 0; o < size; ++o) {
                i = (Integer)starts_index.get(starts[o]);
                try {
                    isCtrlField = Verifier.isControlField(tags[i]);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    this.input.skip(lengths[i]);
                    continue;
                }
                if (isCtrlField) {
                    byteArray = new byte[lengths[i] - 1];
                    for (bytesRead = this.input.read(byteArray); bytesRead != -1 && bytesRead != byteArray.length; bytesRead += this.input.read(byteArray, bytesRead, byteArray.length - bytesRead)) {
                    }
                    if (this.input.read() != 30) {
                        throw new MarcException("expected field terminator at end of field");
                    }
                    ControlField field = this.factory.newControlField();
                    field.setTag(tags[i]);
                    field.setData(this.getDataAsString(byteArray));
                    this.record.addVariableField(field);
                    continue;
                }
                byteArray = new byte[lengths[i]];
                for (bytesRead = this.input.read(byteArray); bytesRead != -1 && bytesRead != byteArray.length; bytesRead += this.input.read(byteArray, bytesRead, byteArray.length - bytesRead)) {
                }
                try {
                    this.record.addVariableField(this.parseDataField(tags[i], byteArray));
                    continue;
                }
                catch (IOException e) {
                    throw new MarcException("error parsing data field for tag: " + tags[i] + " with data: " + new String(byteArray), e);
                }
            }
            if (this.input.read() != 29) {
                throw new MarcException("expected record terminator");
            }
        }
        catch (IOException e) {
            throw new MarcException("an error occured reading input", e);
        }
        return this.record;
    }

    private DataField parseDataField(String tag, byte[] field) throws IOException {
        int readByte;
        ByteArrayInputStream bais = new ByteArrayInputStream(field);
        char ind1 = (char)bais.read();
        char ind2 = (char)bais.read();
        DataField dataField = this.factory.newDataField();
        dataField.setTag(tag);
        dataField.setIndicator1(ind1);
        dataField.setIndicator2(ind2);
        while ((readByte = bais.read()) >= 0) {
            switch (readByte) {
                case 31: {
                    int code = bais.read();
                    if (code < 0) {
                        throw new IOException("unexpected end of data field");
                    }
                    if (code == 30) break;
                    int size = this.getSubfieldLength(bais);
                    byte[] data = new byte[size];
                    bais.read(data);
                    Subfield subfield = this.factory.newSubfield();
                    subfield.setCode((char)code);
                    subfield.setData(this.getDataAsString(data));
                    dataField.addSubfield(subfield);
                    break;
                }
            }
        }
        return dataField;
    }

    private int getSubfieldLength(ByteArrayInputStream bais) throws IOException {
        bais.mark(9999);
        int bytesRead = 0;
        while (true) {
            switch (bais.read()) {
                case 30: 
                case 31: {
                    bais.reset();
                    return bytesRead;
                }
                case -1: {
                    bais.reset();
                    throw new IOException("subfield not terminated");
                }
            }
            ++bytesRead;
        }
    }

    private Leader parseLeader(byte[] leaderData) throws IOException {
        InputStreamReader isr = new InputStreamReader(new ByteArrayInputStream(leaderData));
        Leader ldr = this.factory.newLeader();
        char[] tmp = new char[5];
        isr.read(tmp);
        try {
            ldr.setRecordLength(Integer.parseInt(new String(tmp)));
        }
        catch (NumberFormatException e) {
            throw new MarcException("unable to parse record length", e);
        }
        ldr.setRecordStatus((char)isr.read());
        ldr.setTypeOfRecord((char)isr.read());
        tmp = new char[2];
        isr.read(tmp);
        ldr.setImplDefined1(tmp);
        ldr.setCharCodingScheme((char)isr.read());
        try {
            ldr.setIndicatorCount(Integer.parseInt(String.valueOf((char)isr.read())));
        }
        catch (NumberFormatException e) {
            throw new MarcException("unable to parse indicator count", e);
        }
        try {
            ldr.setSubfieldCodeLength(Integer.parseInt(String.valueOf((char)isr.read())));
        }
        catch (NumberFormatException e) {
            throw new MarcException("unable to parse subfield code length", e);
        }
        tmp = new char[5];
        isr.read(tmp);
        try {
            ldr.setBaseAddressOfData(Integer.parseInt(new String(tmp)));
        }
        catch (NumberFormatException e) {
            throw new MarcException("unable to parse base address of data", e);
        }
        tmp = new char[3];
        isr.read(tmp);
        ldr.setImplDefined2(tmp);
        tmp = new char[4];
        isr.read(tmp);
        ldr.setEntryMap(tmp);
        isr.close();
        return ldr;
    }

    private String getDataAsString(byte[] bytes) {
        String dataElement = null;
        if (this.encoding != null) {
            try {
                dataElement = new String(bytes, this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new MarcException("unsupported encoding", e);
            }
        } else {
            dataElement = new String(bytes);
        }
        return dataElement;
    }
}

