/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.converter.impl;

import java.io.InputStream;
import java.util.Hashtable;
import org.marc4j.converter.CharConverter;
import org.marc4j.converter.impl.CodeTableTracker;
import org.marc4j.converter.impl.ReverseCodeTable;

public class UnicodeToAnsel
implements CharConverter {
    protected ReverseCodeTable rct;
    static final char ESC = '\u001b';
    static final char G0 = '(';
    static final char G0multibyte = '$';
    static final char G1 = ')';
    static final int ASCII = 66;

    public UnicodeToAnsel() {
        this(UnicodeToAnsel.class.getResourceAsStream("resources/codetables.xml"));
    }

    public UnicodeToAnsel(String pathname) {
        this.rct = new ReverseCodeTable(pathname);
    }

    public UnicodeToAnsel(InputStream in) {
        this.rct = new ReverseCodeTable(in);
    }

    public String convert(String dataElement) {
        char[] data = dataElement.toCharArray();
        StringBuffer sb = new StringBuffer();
        CodeTableTracker ctt = new CodeTableTracker();
        boolean technique1 = false;
        for (int i = 0; i < data.length; ++i) {
            Character c = new Character(data[i]);
            StringBuffer marc = new StringBuffer();
            Hashtable h = this.rct.codeTableHash(c);
            if (h == null) {
                marc.append('?');
            } else if (h.keySet().contains(ctt.getPrevious((byte)0))) {
                ctt.makePreviousCurrent();
                marc.append((char[])h.get(ctt.getPrevious((byte)0)));
            } else if (h.keySet().contains(ctt.getPrevious((byte)1))) {
                ctt.makePreviousCurrent();
                marc.append((char[])h.get(ctt.getPrevious((byte)1)));
            } else {
                Integer table = (Integer)h.keySet().iterator().next();
                char[] marc8 = (char[])h.get(table);
                if (marc8.length == 3) {
                    marc.append('\u001b');
                    marc.append('$');
                    ctt.setPrevious((byte)0, table);
                } else if (marc8[0] < '\u0080') {
                    marc.append('\u001b');
                    if (table == 98 || table == 112) {
                        technique1 = true;
                    } else {
                        marc.append('(');
                    }
                    ctt.setPrevious((byte)0, table);
                } else {
                    marc.append('\u001b');
                    marc.append(')');
                    ctt.setPrevious((byte)1, table);
                }
                marc.append((char)table.intValue());
                marc.append(marc8);
            }
            if (this.rct.isCombining(c) && sb.length() > 0) {
                sb.insert(sb.length() - 1, marc);
                continue;
            }
            sb.append(marc);
        }
        if (ctt.getPrevious((byte)0) != 66) {
            sb.append('\u001b');
            sb.append('(');
            sb.append('B');
        }
        return sb.toString();
    }
}

