/*
 * Decompiled with CFR 0.152.
 */
package opals.solrindex;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SolrDocPoster {
    protected URL solrUrl;
    public static final String POST_ENCODING = "UTF-8";

    public SolrDocPoster(String urlStr) {
        try {
            this.solrUrl = new URL(urlStr);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(SolrDocPoster.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void post(String doc) {
        StringWriter sw = new StringWriter();
        this.postData(new StringReader(doc), sw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postData(Reader data, Writer output) {
        HttpURLConnection urlc = null;
        try {
            urlc = (HttpURLConnection)this.solrUrl.openConnection();
            try {
                urlc.setRequestMethod("POST");
            }
            catch (ProtocolException e) {
                throw new PostException("Shouldn't happen: HttpURLConnection doesn't support POST??", e);
            }
            urlc.setDoOutput(true);
            urlc.setDoInput(true);
            urlc.setUseCaches(false);
            urlc.setAllowUserInteraction(false);
            urlc.setRequestProperty("Content-type", "text/xml; charset=UTF-8");
            OutputStream out = urlc.getOutputStream();
            try {
                OutputStreamWriter writer = new OutputStreamWriter(out, POST_ENCODING);
                SolrDocPoster.pipe(data, writer);
                ((Writer)writer).close();
            }
            catch (IOException e) {
                throw new PostException("IOException while posting data", e);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            InputStream in = urlc.getInputStream();
            try {
                InputStreamReader reader = new InputStreamReader(in);
                SolrDocPoster.pipe(reader, output);
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new PostException("IOException while reading response", e);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            try {
                SolrDocPoster.fatal("Solr returned an error: " + urlc.getResponseMessage());
            }
            catch (IOException f) {
                // empty catch block
            }
            SolrDocPoster.fatal("Connection error (is Solr running at " + this.solrUrl + " ?): " + e);
        }
        finally {
            if (urlc != null) {
                urlc.disconnect();
            }
        }
    }

    private static void pipe(Reader reader, Writer writer) throws IOException {
        char[] buf = new char[1024];
        int read = 0;
        while ((read = reader.read(buf)) >= 0) {
            writer.write(buf, 0, read);
        }
        writer.flush();
    }

    static void fatal(String msg) {
        System.err.println("PostSolrDoc: FATAL: " + msg);
    }

    private class PostException
    extends RuntimeException {
        PostException(String reason, Throwable cause) {
            super(reason + " (POST URL=" + SolrDocPoster.this.solrUrl + ")", cause);
        }
    }
}

