/*
 * Decompiled with CFR 0.152.
 */
package opals.solrindex;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opals.solrindex.FileWatcher;
import opals.solrindex.MarcXmlSolrParser;
import opals.solrindex.SolrDocPoster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpalsSolrIndex
extends FileWatcher {
    static MarcXmlSolrParser mParser;
    private SolrDocPoster solrDocPoster;
    private String sHost = "";
    private String sPort = "8983";
    private String sDb = "";
    private String sIndexConfig = "/etc/opals/solr/conf/indexConf.xml";
    private String solrDataDir = "/data/solr/";
    private String zDataDir = "";

    public OpalsSolrIndex(String ocfFile) {
        this.loadConfig(ocfFile);
        if (!new File(this.sIndexConfig).exists()) {
            System.err.println("Unable to read opals configuaration!");
            System.exit(0);
        }
        mParser = new MarcXmlSolrParser(this.sIndexConfig);
        String solrSrvUrl = String.format("http://%s:%s/solr/%s/update", this.sHost, this.sPort, this.sDb);
        this.solrDocPoster = new SolrDocPoster(solrSrvUrl);
    }

    @Override
    protected void onFileDelete(String fname) {
        System.out.println("delete: " + fname);
        this.deleteRecord(fname);
    }

    @Override
    protected void onFileChange(String fname) {
        System.out.println("changed: " + fname);
        this.deleteRecord(fname);
        this.addRecord(fname);
    }

    @Override
    protected void onFileNew(String fname) {
        System.out.println("new: " + fname);
        this.addRecord(fname);
    }

    private void addRecord(String fname) {
        String solrDoc = mParser.parse2SolrXml(fname);
        if (!solrDoc.isEmpty()) {
            this.solrDocPoster.post("<add>" + solrDoc + "</add>");
        }
    }

    private void deleteRecord(String fname) {
        Pattern p = Pattern.compile("(.*?)(\\d+).xml");
        Matcher m = p.matcher(fname);
        if (m.matches()) {
            String rid = m.group(2);
            String solrDoc = "<delete><query>rid:" + rid + "</query></delete>";
            System.out.println(solrDoc);
            this.solrDocPoster.post(solrDoc);
        }
    }

    public void updateIndex() {
        if (this.hasSolrDb()) {
            this.check(this.zDataDir);
            this.solrDocPoster.post("<commit/>");
        }
    }

    private boolean hasSolrDb() {
        return !this.sHost.isEmpty() && !this.zDataDir.isEmpty();
    }

    @Override
    protected Map<String, Long> loadStat(String dir) {
        String dirName = dir.substring(dir.lastIndexOf(47) + 1);
        HashMap dbStat = new HashMap();
        File d = new File(this.solrDataDir + "/" + this.sDb + "/" + dirName + ".ser");
        if (d.exists()) {
            try {
                FileInputStream fs = new FileInputStream(d);
                ObjectInputStream os = new ObjectInputStream(fs);
                dbStat = (HashMap)os.readObject();
                os.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return dbStat;
    }

    @Override
    protected void saveStat(String dir, Map<String, Long> dirStat) {
        File dbPath;
        String dirName = dir.substring(dir.lastIndexOf(47) + 1);
        String path = this.solrDataDir;
        File statDir = new File(path);
        if (!statDir.exists()) {
            System.err.printf("%S does not exist ", this.solrDataDir);
            System.exit(0);
        }
        if (!(dbPath = new File(statDir, this.sDb)).exists()) {
            dbPath.mkdir();
        }
        try {
            File stat = new File(dbPath, dirName + ".ser");
            FileOutputStream fs = new FileOutputStream(stat);
            ObjectOutputStream os = new ObjectOutputStream(fs);
            os.writeObject(dirStat);
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadConfig(String cfFile) {
        Map<String, String> ocf = this.getOpalsConfig(cfFile);
        File file = new File(cfFile);
        if (!file.exists() || !file.canRead()) {
            System.err.printf("Error: unable to read %s", cfFile);
        }
        if (ocf.containsKey("zDatabase")) {
            this.sDb = ocf.get("zDatabase");
        } else {
            System.err.printf("Error: database name is missing in %s", cfFile);
        }
        if (ocf.containsKey("sHost")) {
            this.sHost = ocf.get("sHost");
        }
        if (ocf.containsKey("sPort")) {
            this.sPort = ocf.get("sPort");
        }
        if (ocf.containsKey("sIndexConfig")) {
            this.sIndexConfig = ocf.get("sIndexConfig");
        }
        if (ocf.containsKey("zRoot") && ocf.containsKey("zPort")) {
            this.zDataDir = String.format("%s/%s/record/%s", ocf.get("zRoot"), ocf.get("zPort"), this.sDb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getOpalsConfig(String path) {
        FileReader f = null;
        HashMap<String, String> ocf = new HashMap<String, String>();
        try {
            f = new FileReader(path);
            BufferedReader br = new BufferedReader(f);
            String str = "";
            while ((str = br.readLine()) != null) {
                int p;
                if ((str = str.trim()).startsWith("#") || (p = str.indexOf(61)) <= 0) continue;
                String name = str.substring(0, p);
                String value = str.substring(p + 1);
                ocf.put(name, value);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(OpalsSolrIndex.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(OpalsSolrIndex.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                f.close();
            }
            catch (IOException ex) {
                Logger.getLogger(OpalsSolrIndex.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return ocf;
    }
}

