/*
 * Decompiled with CFR 0.152.
 */
package opals.solrindex;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opals.marc.ControlField;
import opals.marc.DataField;
import opals.marc.MarcRecord;
import opals.marc.MarcXmlReader;
import opals.marc.Subfield;
import opals.util.FieldIndexProp;
import opals.util.IndexConfig;
import opals.util.OpalsSolrIndexConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarcXmlSolrParser {
    static String docFormatrStr = "<doc>\n<field name=\"db\">main</field>\n<field name=\"id\">%s</field>\n%s\n</doc>\n";
    static String docFormatrStr_arl = "<doc>\n<field name=\"db\">ARL</field>\n<field name=\"id\">%s</field>\n%s\n%s\n</doc>\n";
    static String docFormatrStr_sbj = "<doc>\n<field name=\"db\">subject</field>\n<field name=\"id\">%s</field><field name=\"rid\">%s</field>\n%s\n</doc>\n";
    static String docFormatrStr_auth = "<doc>\n<field name=\"db\">author</field>\n<field name=\"id\">%s</field>\n<field name=\"rid\">%s</field>\n%s\n</doc>\n";
    private IndexConfig config;

    public MarcXmlSolrParser() {
    }

    public MarcXmlSolrParser(String icfFile) {
        OpalsSolrIndexConfig cnfParser = new OpalsSolrIndexConfig();
        this.config = cnfParser.readIndexCong(icfFile);
    }

    public String parse2SolrXml(String fileName) {
        StringBuilder solrXml = new StringBuilder();
        String bibRecXml = "";
        try {
            List<Field> arlFieldList;
            MarcXmlReader reader = new MarcXmlReader();
            MarcRecord record = reader.parse(fileName);
            List<ControlField> ctrFields = record.getControlFields();
            String rid = this.getRecId(ctrFields);
            List<Field> fieldList = this.getDataFields(record);
            List<Field> lexileFields = this.getLexileFields(record);
            if (lexileFields != null && lexileFields.size() > 0) {
                fieldList.addAll(lexileFields);
            }
            if ((arlFieldList = this.getARLField(record)) != null && arlFieldList.size() > 0) {
                fieldList.addAll(arlFieldList);
            }
            bibRecXml = this.createSolrBibXml(fieldList);
            solrXml.append(String.format(docFormatrStr, rid, bibRecXml));
            List<String> sbjList = this.getSubjectList(fieldList);
            int i = 0;
            for (String sbjXml : sbjList) {
                String sbjId = String.format("sbj_%s_%d", rid, i++);
                solrXml.append(String.format(docFormatrStr_sbj, sbjId, rid, sbjXml));
            }
            ArrayList authorList = (ArrayList)this.getAuthorList(fieldList);
            i = 0;
            if (authorList != null) {
                for (String authXml : authorList) {
                    String authId = String.format("aut_%s_%d", rid, i++);
                    solrXml.append(String.format(docFormatrStr_auth, authId, rid, authXml));
                }
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MarcXmlSolrParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MarcXmlSolrParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        return solrXml.toString();
    }

    private String getRecId(List<ControlField> cfList) {
        String rid = "";
        for (ControlField cf : cfList) {
            if (!cf.getTag().equals("001")) continue;
            rid = cf.getData();
            break;
        }
        return rid;
    }

    private String getLanguageCode(List<ControlField> ctrlField) {
        String lCode = "";
        for (ControlField cf : ctrlField) {
            if (!cf.getTag().equals("008")) continue;
            if (cf.getData().length() <= 37) break;
            lCode = cf.getData().substring(35, 38).trim();
            break;
        }
        if (lCode.length() != 3) {
            lCode = "eng";
        }
        return lCode;
    }

    private String getRecLiteraryForm(List<ControlField> ctrlField) {
        String litForm = "";
        int litCode = 32;
        for (ControlField cf : ctrlField) {
            if (!cf.getTag().equals("008")) continue;
            if (cf.getData().length() <= 33) break;
            litCode = cf.getData().charAt(33);
            break;
        }
        switch (litCode) {
            case 48: {
                litForm = "nonFiction";
                break;
            }
            case 49: {
                litForm = "fiction";
                break;
            }
            case 99: {
                litForm = "comicStrips";
                break;
            }
            case 100: {
                litForm = "dramas";
                break;
            }
            case 101: {
                litForm = "essays";
                break;
            }
            case 102: {
                litForm = "novels";
                break;
            }
            case 104: {
                litForm = "humor";
                break;
            }
            case 105: {
                litForm = "letters";
                break;
            }
            case 106: {
                litForm = "shortStories";
                break;
            }
            case 109: {
                litForm = "mixedDorms";
                break;
            }
            case 112: {
                litForm = "poetry";
                break;
            }
            case 115: {
                litForm = "speeches";
                break;
            }
            default: {
                litForm = "unknown";
            }
        }
        return litForm;
    }

    private List<String> getRecFormat(String leader, List<ControlField> ctrlFields) {
        ArrayList<String> recFormat = new ArrayList<String>();
        int l_06 = 32;
        int l_07 = 32;
        int cf007_00 = 32;
        int cf007_01 = 32;
        int cf008_26 = 32;
        if (leader != null && leader.length() > 7) {
            l_06 = leader.charAt(6);
            l_07 = leader.charAt(7);
        }
        if (ctrlFields != null) {
            for (ControlField cf : ctrlFields) {
                if (!cf.getTag().equals("007")) continue;
                if (cf.getData().length() > 0) {
                    cf007_00 = cf.getData().charAt(0);
                }
                if (cf.getData().length() <= 1) break;
                cf007_00 = cf.getData().charAt(1);
                break;
            }
            for (ControlField cf : ctrlFields) {
                if (!cf.getTag().equals("008")) continue;
                if (cf.getData().length() <= 26) break;
                cf008_26 = cf.getData().charAt(6);
                break;
            }
        }
        switch (l_06) {
            case 97: 
            case 116: {
                if (l_07 == 115 || l_07 == 98) {
                    recFormat.add("journal");
                    break;
                }
                if ("acdm".indexOf(l_07) < 0) break;
                recFormat.add("book");
                break;
            }
            case 114: {
                recFormat.add("artifact");
                break;
            }
            case 107: {
                recFormat.add("aphotoPoster");
                break;
            }
            case 106: {
                recFormat.add("musicCassette");
                break;
            }
            case 105: {
                recFormat.add("bookOnTape");
                break;
            }
            case 103: {
                recFormat.add("movie");
                break;
            }
            case 111: 
            case 112: {
                recFormat.add("libraryKit");
                break;
            }
            case 101: 
            case 102: {
                recFormat.add("map");
                break;
            }
            case 99: 
            case 100: {
                recFormat.add("sheetMusic");
                break;
            }
            case 109: {
                if (cf008_26 == 106) {
                    recFormat.add("internet");
                    break;
                }
                recFormat.add("electronicMedia");
            }
        }
        if (cf007_00 == 115 && cf007_01 == 100) {
            recFormat.add("CDMusic");
        } else if (cf007_00 == 99 && cf007_01 == 111) {
            recFormat.add("compactDisc");
        }
        if (recFormat.size() == 0) {
            recFormat.add("book");
        }
        return recFormat;
    }

    private List<Field> getDataFields(MarcRecord record) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        String leader = record.getLeader();
        List<ControlField> ctrFields = record.getControlFields();
        String rid = this.getRecId(ctrFields);
        String langCode = this.getLanguageCode(ctrFields);
        String litForm = this.getRecLiteraryForm(ctrFields);
        List<String> fmtList = this.getRecFormat(leader, ctrFields);
        fieldList.add(new Field("rid", rid));
        fieldList.add(new Field("language", langCode));
        fieldList.add(new Field("literaryForm", litForm));
        for (String fmt : fmtList) {
            fieldList.add(new Field("format", fmt));
        }
        HashSet<String> notRepeataleField = new HashSet<String>();
        List<DataField> dfList = record.getDataFields();
        for (DataField df : dfList) {
            String tag = df.getTag();
            List<FieldIndexProp> fipList = this.config.getIndexProp(tag);
            if (fipList == null) continue;
            for (FieldIndexProp fip : fipList) {
                if (notRepeataleField.contains(fip.getFieldName())) continue;
                String dataStr = "";
                for (Subfield sf : df.getSubFields()) {
                    if (!fip.indexSubfield(sf.getCode())) continue;
                    if (!dataStr.isEmpty()) {
                        dataStr = dataStr + fip.getSfConcatStr();
                    }
                    dataStr = dataStr + sf.getData();
                }
                if (!(dataStr = dataStr.trim()).isEmpty()) {
                    if ("title_sort".equals(fip.getFieldName()) && df.getInd2() > '0' && df.getInd2() <= '9') {
                        dataStr = dataStr.substring(df.getInd2() - 48);
                    } else if ("datePublication".equals(fip.getFieldName())) {
                        dataStr = dataStr.replaceAll("\\D", "");
                    }
                    fieldList.add(new Field(fip.getFieldName(), dataStr));
                }
                if (!fip.isFirstFieldOnly()) continue;
                notRepeataleField.add(fip.getFieldName());
            }
        }
        return fieldList;
    }

    private String createSolrBibXml(List<Field> fieldList) {
        StringBuilder solrXml = new StringBuilder();
        for (Field field : fieldList) {
            solrXml.append(String.format("<field name=\"%s\">%s</field>\n", field.getName(), field.getData()));
        }
        return solrXml.toString();
    }

    private String fixISBN(String isbn) {
        return isbn;
    }

    private List<Field> getARLField(MarcRecord record) {
        ArrayList<Field> arlFieldList = null;
        List<DataField> dfList = record.getDataFields("526");
        boolean arCount = false;
        boolean rcCount = false;
        String[][] arlFieldmap = new String[][]{{"b", "interestLevel"}, {"c", "readingLevel"}, {"d", "pointValue"}, {"z", "quizNumber"}};
        if (dfList != null && !dfList.isEmpty()) {
            arlFieldList = new ArrayList<Field>();
            String prefix = "";
            for (DataField df : dfList) {
                Subfield sf = df.get1stSubfield('a');
                if (sf == null) continue;
                if (sf.getData().matches("(?i)(.*)(accelerated[\\s]+reader|ar(.*))") && arCount < true) {
                    arlFieldList.add(new Field("studyPrgm", "Accelerated Reader"));
                    prefix = "AR_";
                    arCount = true;
                } else {
                    if (!sf.getData().matches("(?i)(.*)(reading[\\s]+count|rc(.*))") || rcCount >= true) continue;
                    arlFieldList.add(new Field("studyPrgm", "Reading counts"));
                    prefix = "RC_";
                    rcCount = true;
                }
                for (String[] sfm : arlFieldmap) {
                    sf = df.get1stSubfield(sfm[0].charAt(0));
                    if (sf == null) continue;
                    arlFieldList.add(new Field(prefix + sfm[1], sf.getData()));
                }
            }
        }
        return arlFieldList;
    }

    private List<String> getARLXmlRecList(MarcRecord record) {
        ArrayList<String> arlRecList = null;
        List<DataField> dfList = record.getDataFields("526");
        String[][] arlFieldmap = new String[][]{{"b", "interestLevel"}, {"c", "readingLevel"}, {"d", "pointValue"}, {"z", "quizNumber"}};
        if (dfList != null && !dfList.isEmpty()) {
            arlRecList = new ArrayList<String>();
            String arlXml = "";
            String prefix = "";
            for (DataField df : dfList) {
                arlXml = "";
                Subfield sf = df.get1stSubfield('a');
                if (sf.getData().matches("(?i)(.*)(accelerated[\\s]+reader|ar(.*))")) {
                    arlXml = String.format("<field name=\"%s\">%s</field>\n", "studyPrgm", "Accelerated Reader");
                    prefix = "AR_";
                } else {
                    if (!sf.getData().matches("(?i)(.*)(reading[\\s]+count|rc(.*))")) continue;
                    arlXml = String.format("<field name=\"%s\">%s</field>\n", "studyPrgm", "Reading counts");
                    prefix = "RC_";
                }
                for (String[] sfm : arlFieldmap) {
                    sf = df.get1stSubfield(sfm[0].charAt(0));
                    if (sf == null) continue;
                    arlXml = arlXml + String.format("<field name=\"%s%s\">%s</field>\n", prefix, sfm[1], sf.getData());
                }
                if (arlXml.isEmpty()) continue;
                arlRecList.add(arlXml);
            }
        }
        return arlRecList;
    }

    private List<String> getSubjectList(List<Field> fieldList) {
        ArrayList<String> sbjxmlList = new ArrayList<String>();
        for (Field field : fieldList) {
            if (!"subject".equals(field.getName())) continue;
            sbjxmlList.add(String.format("<field name=\"subject_grp\">%s</field>", field.getData()));
        }
        return sbjxmlList;
    }

    private List<String> getAuthorList(List<Field> fieldList) {
        ArrayList<String> sbjxmlList = new ArrayList<String>();
        for (Field field : fieldList) {
            if (!"author".equals(field.getName())) continue;
            sbjxmlList.add(String.format("<field name=\"author_grp\">%s</field>", field.getData()));
        }
        return sbjxmlList;
    }

    private List<Field> getLexileFields(MarcRecord record) {
        ArrayList<Field> lexileList = new ArrayList<Field>();
        List<DataField> dfList = record.getDataFields("521");
        for (DataField df : dfList) {
            char ind1 = df.getInd1();
            if (ind1 == '8') {
                Pattern p;
                Matcher m;
                Subfield sfa = df.get1stSubfield('a');
                Subfield sfb = df.get1stSubfield('b');
                if (sfa != null && sfb != null && sfb.getData().matches("(?i:.*lexile.*)") && (m = (p = Pattern.compile("(.*?)(\\d+).*")).matcher(sfa.getData().trim())).find()) {
                    if (!m.group(1).isEmpty()) {
                        lexileList.add(new Field("lexileCode", m.group(1)));
                    }
                    lexileList.add(new Field("lexileMeasure", m.group(2)));
                }
            }
            if (lexileList.size() < 1) continue;
            break;
        }
        return lexileList;
    }

    private class Field {
        private String name;
        private String data;

        private Field(String fieldName, String dataStr) {
            this.name = fieldName;
            this.data = dataStr;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }
    }
}

