/*
 * Decompiled with CFR 0.152.
 */
package opals.solrindex;

import java.io.File;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import opals.solrindex.OpalsSolrIndex;

public class Main
extends TimerTask {
    private Map<File, OpalsSolrIndex> osiList = new LinkedHashMap<File, OpalsSolrIndex>();

    public static void main(String[] arg) throws Exception {
        Main osi = new Main();
        Timer timer = new Timer();
        timer.schedule((TimerTask)osi, new Date(), 60000L);
    }

    public void loadDb() {
        File confDir = new File("/etc/opals/conf");
        for (File db : confDir.listFiles()) {
            if (this.osiList.containsKey(db)) continue;
            System.out.println("adding:" + db.getName());
            this.osiList.put(db, new OpalsSolrIndex(db.getAbsolutePath()));
        }
    }

    public void run() {
        this.loadDb();
        for (Map.Entry<File, OpalsSolrIndex> e : this.osiList.entrySet()) {
            System.out.println(e.getKey().getName());
            e.getValue().updateIndex();
        }
    }
}

