/*
 * Decompiled with CFR 0.152.
 */
package opals.solrindex;

import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import opals.solrindex.XmlFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileWatcher {
    private FileFilter dff;

    public FileWatcher() {
        this(new XmlFileFilter());
    }

    public FileWatcher(FileFilter filter) {
        this.dff = filter;
    }

    public void check(String path) {
        File d = new File(path);
        for (String f : d.list()) {
            this.checkDir(path + "/" + f);
        }
    }

    private void checkDir(String path) {
        boolean changeDectected = false;
        HashSet<String> checkedFiles = new HashSet<String>();
        System.out.println(path);
        File[] filesArray = new File(path).listFiles(this.dff);
        HashMap<String, Long> currentDir = (HashMap<String, Long>)this.loadStat(path);
        if (currentDir == null) {
            currentDir = new HashMap<String, Long>();
        }
        for (int i = 0; i < filesArray.length; ++i) {
            if (!filesArray[i].canRead()) continue;
            Long current = (Long)currentDir.get(filesArray[i].getName());
            checkedFiles.add(filesArray[i].getName());
            String fName = filesArray[i].getName();
            long fileModDate = filesArray[i].lastModified();
            if (filesArray[i].isDirectory()) {
                this.checkDir(filesArray[i].getPath());
                changeDectected = true;
                continue;
            }
            if (current == null) {
                currentDir.put(fName, new Long(fileModDate));
                this.onFileNew(path + "/" + fName);
                changeDectected = true;
                continue;
            }
            if (current == fileModDate) continue;
            currentDir.put(fName, new Long(fileModDate));
            this.onFileChange(path + "/" + fName);
            changeDectected = true;
        }
        Set ref = ((HashMap)currentDir.clone()).keySet();
        ref.removeAll(checkedFiles);
        for (String f : ref) {
            currentDir.remove(f);
            this.onFileDelete(path + "/" + f);
            changeDectected = true;
        }
        if (changeDectected) {
            this.saveStat(path, currentDir);
        }
    }

    protected abstract void onFileDelete(String var1);

    protected abstract void onFileChange(String var1);

    protected abstract void onFileNew(String var1);

    protected abstract Map<String, Long> loadStat(String var1);

    protected abstract void saveStat(String var1, Map<String, Long> var2);
}

