/*
 * Decompiled with CFR 0.152.
 */
package opals.marc;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opals.marc.ControlField;
import opals.marc.DataField;
import opals.marc.MarcRecord;
import opals.marc.Subfield;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarcXmlReader {
    static final Pattern ldPattern = Pattern.compile("<leader>(.*?)</leader>");
    static final Pattern cfPattern = Pattern.compile("<controlfield tag=\"(00[1-9])\">(.*?)</controlfield>");
    static final Pattern sfPattern = Pattern.compile("<subfield code=\"([\\w])\">(.*?)</subfield>");
    static final Pattern dfPattern = Pattern.compile("<datafield tag=\"([\\d][\\d][\\d])\" ind1=\"([\\w ])\" ind2=\"([\\w ])\">(.*?)</datafield>");

    public MarcRecord parse(String fname) throws IOException {
        BufferedReader reader = this.getReader(fname);
        if (reader == null) {
            return null;
        }
        StringBuilder xml = this.getXmlStr(reader);
        reader.close();
        MarcRecord mrcRec = this.parseXml(xml);
        return mrcRec;
    }

    private BufferedReader getReader(String fname) {
        BufferedReader reader = null;
        try {
            FileReader fr = new FileReader(fname);
            reader = new BufferedReader(fr);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MarcXmlReader.class.getName()).log(Level.SEVERE, null, ex);
        }
        return reader;
    }

    private StringBuilder getXmlStr(BufferedReader reader) {
        StringBuilder xml = new StringBuilder();
        String lineStr = "";
        try {
            while ((lineStr = reader.readLine()) != null) {
                xml.append(lineStr);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(MarcXmlReader.class.getName()).log(Level.SEVERE, null, ex);
        }
        return xml;
    }

    private MarcRecord parseXml(StringBuilder xml) {
        MarcRecord mrcRec = new MarcRecord();
        Matcher dfMatcher = dfPattern.matcher(xml);
        Matcher ldMatcher = ldPattern.matcher(xml);
        if (ldMatcher.find()) {
            mrcRec.setLeader(ldMatcher.group(1));
        }
        mrcRec.addControlFields(this.parseControlField(xml));
        mrcRec.addDataFields(this.ParseDataField(xml));
        return mrcRec;
    }

    private List<ControlField> parseControlField(StringBuilder xml) {
        ArrayList<ControlField> cfList = new ArrayList<ControlField>();
        Matcher cfMatcher = cfPattern.matcher(xml);
        while (cfMatcher.find()) {
            cfList.add(new ControlField(cfMatcher.group(1), cfMatcher.group(2)));
        }
        return cfList;
    }

    private List<DataField> ParseDataField(StringBuilder xml) {
        ArrayList<DataField> dfList = new ArrayList<DataField>();
        Matcher dfMatcher = dfPattern.matcher(xml);
        while (dfMatcher.find()) {
            String tag = dfMatcher.group(1);
            char ind1 = dfMatcher.group(2).charAt(0);
            char ind2 = dfMatcher.group(3).charAt(0);
            String fieldCont = dfMatcher.group(4);
            dfList.add(new DataField(tag, ind1, ind2, this.parserSubField(fieldCont)));
        }
        return dfList;
    }

    private List<Subfield> parserSubField(String sfXml) {
        ArrayList<Subfield> sfList = new ArrayList<Subfield>();
        Matcher sfMatcher = sfPattern.matcher(sfXml);
        while (sfMatcher.find()) {
            sfList.add(new Subfield(sfMatcher.group(1).charAt(0), sfMatcher.group(2)));
        }
        return sfList;
    }
}

