/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.Normalizer;
import org.marc4j.MarcStreamWriter;
import org.marc4j.MarcXmlReader;
import org.marc4j.converter.CharConverter;
import org.marc4j.converter.impl.UnicodeToAnsel;
import org.marc4j.marc.Record;

class OpalsMarcConverter {
    private final String OUTFILE = "out.mrc";
    private final String TMPFILE = "tmp.xml";
    private String inFile;
    private String outFile;
    private int recordProcessed;

    public OpalsMarcConverter() {
        this.setSource("", "out.mrc");
    }

    public OpalsMarcConverter(String string) {
        this.setSource(string, "out.mrc");
    }

    public OpalsMarcConverter(String string, String string2) {
        this.setSource(string, string2);
    }

    public void setSource(String string, String string2) {
        this.inFile = string;
        this.outFile = string2;
        this.reset();
    }

    public void reset() {
        this.recordProcessed = 0;
    }

    private void toMarc21(boolean bl) {
        try {
            this.nomalizeNFD();
            FileInputStream fileInputStream = new FileInputStream("tmp.xml");
            MarcXmlReader marcXmlReader = new MarcXmlReader((InputStream)fileInputStream);
            FileOutputStream fileOutputStream = new FileOutputStream(this.outFile, bl);
            MarcStreamWriter marcStreamWriter = new MarcStreamWriter((OutputStream)fileOutputStream, "ISO-8859-1");
            marcStreamWriter.setConverter((CharConverter)new UnicodeToAnsel());
            while (marcXmlReader.hasNext()) {
                Record record = marcXmlReader.next();
                ++this.recordProcessed;
                System.out.println("RID converted: " + record.getControlNumber());
                marcStreamWriter.write(record);
            }
            marcStreamWriter.close();
            File file = new File("tmp.xml");
            file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void nomalizeNFD() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.inFile);
            FileOutputStream fileOutputStream = new FileOutputStream("tmp.xml");
            String string = "";
            int n = 0;
            byte[] byArray = new byte[0x100000];
            int n2 = 0;
            do {
                n = ((InputStream)fileInputStream).read(byArray, 0, 0x100000);
                n2 += n;
                if (n <= 0) continue;
                System.out.println("Number of bytes to convert:      " + n);
                string = new String(byArray, 0, n);
                string = Normalizer.normalize(string, Normalizer.Form.NFD);
                fileOutputStream.write(string.getBytes());
            } while (n > 0);
            System.out.println("Number of bytes after converted: " + n2);
            fileOutputStream.close();
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2 || stringArray.length > 3) {
            System.out.println("Invalid usage. Aborted.");
        } else {
            OpalsMarcConverter opalsMarcConverter = new OpalsMarcConverter();
            opalsMarcConverter.setSource(stringArray[0], stringArray[1]);
            boolean bl = false;
            if (stringArray.length == 3 && stringArray[2].compareTo("append") == 0) {
                bl = true;
            }
            opalsMarcConverter.toMarc21(bl);
        }
    }
}

