/*
 * Decompiled with CFR 0.152.
 */
package opalsindexer;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opals.marc.ControlField;
import opals.marc.DataField;
import opals.marc.MarcRecord;
import opals.marc.MarcXmlReader;
import opals.marc.Subfield;
import opals.util.CallnumberUtil;
import opals.util.FieldIndexProp;
import opals.util.IndexConfig;
import opals.util.LccNum;
import opals.util.OpalsSolrIndexConfig;
import opals.util.RecordTypeUtil;
import org.apache.solr.common.SolrInputDocument;

public class MarcXmlSolrParser {
    private IndexConfig config;
    static final String[][] XML_ESCAPE_ARRAY = new String[][]{{"&quot;", "\""}, {"&amp;", "&"}, {"&lt;", "<"}, {"&gt;", ">"}, {"&apos;", "'"}};
    private static CallnumberUtil lccUtil = new CallnumberUtil();

    public MarcXmlSolrParser() throws NoSuchAlgorithmException {
    }

    public MarcXmlSolrParser(String string) {
        OpalsSolrIndexConfig opalsSolrIndexConfig = new OpalsSolrIndexConfig();
        this.config = opalsSolrIndexConfig.readIndexCong(string);
    }

    public List<SolrInputDocument> parse2SolrDocs(String string) throws IOException, UnsupportedEncodingException, NoSuchAlgorithmException {
        List<Field> list;
        List<Field> list2;
        List<Field> list3;
        List<Field> list4;
        Field field;
        ArrayList<SolrInputDocument> arrayList = new ArrayList<SolrInputDocument>();
        MarcXmlReader marcXmlReader = new MarcXmlReader();
        MarcRecord marcRecord = marcXmlReader.parse(string);
        List<ControlField> list5 = marcRecord.getControlFields();
        String string2 = this.getCtrlFieldData(list5, "001");
        List<Field> list6 = this.getDataFields(marcRecord);
        List<Field> list7 = this.getLexileFields(marcRecord);
        if (list7 != null && list7.size() > 0) {
            list6.addAll(list7);
        }
        if ((field = this.getFountasPinnellField(marcRecord)) != null) {
            list6.add(field);
        }
        if ((list4 = this.getARLField(marcRecord)) != null && list4.size() > 0) {
            list6.addAll(list4);
        }
        if ((list3 = this.getLccDewyFields(marcRecord)) != null && list3.size() > 0) {
            list6.addAll(list3);
        }
        if ((list2 = this.getPublicationField(marcRecord)) != null && list2.size() > 0) {
            list6.addAll(list2);
        }
        if ((list = this.getBisacSbjField(marcRecord)) != null && list.size() > 0) {
            list6.addAll(list);
        }
        SolrInputDocument solrInputDocument = new SolrInputDocument();
        solrInputDocument.addField("db", "main");
        solrInputDocument.addField("id", string2);
        for (Field object22 : list6) {
            solrInputDocument.addField(object22.getName(), this.unEscapeXml(object22.getData()));
        }
        arrayList.add(solrInputDocument);
        int n = 0;
        List<SolrInputDocument> list8 = this.getSbjAuthFields(marcRecord);
        for (Object object : list8) {
            ((SolrInputDocument)object).addField("rid", string2);
            ((SolrInputDocument)object).addField("db", "subject");
            ((SolrInputDocument)object).setField("id", string2 + (String)((SolrInputDocument)object).getFieldValue("id"));
            arrayList.add((SolrInputDocument)object);
        }
        List<String> list9 = this.getAuthorList(list6);
        n = 0;
        if (list9 != null) {
            Object object;
            object = list9.iterator();
            while (object.hasNext()) {
                String string3 = (String)object.next();
                String string4 = String.format("aut_%s_%d", string2, n++);
                SolrInputDocument solrInputDocument2 = new SolrInputDocument();
                solrInputDocument2.addField("id", string4);
                solrInputDocument2.addField("db", "author");
                solrInputDocument2.addField("rid", string2);
                solrInputDocument2.addField("author_grp", this.unEscapeXml(string3));
                arrayList.add(solrInputDocument2);
            }
        }
        return arrayList;
    }

    private String unEscapeXml(String string) {
        for (String[] stringArray : XML_ESCAPE_ARRAY) {
            string = string.replaceAll(stringArray[0], stringArray[1]);
        }
        return string;
    }

    public String parse2SolrXml(String string) throws IOException, UnsupportedEncodingException, NoSuchAlgorithmException {
        StringBuilder stringBuilder = new StringBuilder();
        List<SolrInputDocument> list = this.parse2SolrDocs(string);
        for (SolrInputDocument solrInputDocument : list) {
            stringBuilder.append("<doc>\n");
            for (String string2 : solrInputDocument.getFieldNames()) {
                for (Object object : solrInputDocument.getFieldValues(string2)) {
                    stringBuilder.append(String.format("    <field name=\"%s\">%s</field>\n", string2, (String)object));
                }
            }
            stringBuilder.append("</doc>\n");
        }
        return stringBuilder.toString();
    }

    private String getCtrlFieldData(List<ControlField> list, String string) {
        String string2 = "";
        for (ControlField controlField : list) {
            if (!controlField.getTag().equals(string)) continue;
            string2 = controlField.getData();
            break;
        }
        return string2;
    }

    private String getLanguageCode(List<ControlField> list) {
        String string = "";
        for (ControlField controlField : list) {
            if (!controlField.getTag().equals("008")) continue;
            if (controlField.getData().length() <= 37) break;
            string = controlField.getData().substring(35, 38).trim();
            break;
        }
        if (string.length() != 3) {
            string = "eng";
        }
        return string;
    }

    private String getRecLiteraryForm(List<ControlField> list) {
        String string = "";
        int n = 32;
        for (ControlField controlField : list) {
            if (!controlField.getTag().equals("008")) continue;
            if (controlField.getData().length() <= 33) break;
            n = controlField.getData().charAt(33);
            break;
        }
        switch (n) {
            case 48: {
                string = "nonFiction";
                break;
            }
            case 49: {
                string = "fiction";
                break;
            }
            case 99: {
                string = "comicStrips";
                break;
            }
            case 100: {
                string = "dramas";
                break;
            }
            case 101: {
                string = "essays";
                break;
            }
            case 102: {
                string = "novels";
                break;
            }
            case 104: {
                string = "humor";
                break;
            }
            case 105: {
                string = "letters";
                break;
            }
            case 106: {
                string = "shortStories";
                break;
            }
            case 109: {
                string = "mixedDorms";
                break;
            }
            case 112: {
                string = "poetry";
                break;
            }
            case 115: {
                string = "speeches";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return string;
    }

    private List<String> getRecFormat(String string, List<ControlField> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (list != null) {
            for (ControlField controlField : list) {
                if (!controlField.getTag().equals("006")) continue;
                string2 = controlField.getData();
                break;
            }
            for (ControlField controlField : list) {
                if (!controlField.getTag().equals("007")) continue;
                string3 = controlField.getData();
                break;
            }
            for (ControlField controlField : list) {
                if (!controlField.getTag().equals("008")) continue;
                string4 = controlField.getData();
                break;
            }
        }
        arrayList.add(RecordTypeUtil.getRecordType(string, string2, string3, string4));
        return arrayList;
    }

    private List<Field> getDataFields(MarcRecord marcRecord) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        String string = marcRecord.getLeader();
        List<ControlField> list = marcRecord.getControlFields();
        String string2 = this.getLanguageCode(list);
        String string3 = this.getRecLiteraryForm(list);
        List<String> list2 = this.getRecFormat(string, list);
        arrayList.add(new Field("rid", this.getCtrlFieldData(list, "001")));
        arrayList.add(new Field("bid", this.getCtrlFieldData(list, "002")));
        arrayList.add(new Field("cid", this.getCtrlFieldData(list, "004")));
        arrayList.add(new Field("language", string2));
        arrayList.add(new Field("literaryForm", string3));
        for (String object2 : list2) {
            arrayList.add(new Field("format", object2));
        }
        HashSet hashSet = new HashSet();
        List<DataField> list3 = marcRecord.getDataFields();
        for (DataField dataField : list3) {
            Object object;
            Object object2;
            String string4 = dataField.getTag();
            String string5 = "df_" + dataField.getTag();
            String string6 = "IND1_" + dataField.getInd1() + " IND2_" + dataField.getInd2();
            List<Subfield> list4 = dataField.getSubFields();
            Object object3 = list4.iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                object = "sf_" + string4 + ((Subfield)object2).getCode();
                arrayList.add(new Field((String)object, string6 + " " + ((Subfield)object2).getData()));
                arrayList.add(new Field(string5, string6 + " " + ((Subfield)object2).getData()));
            }
            if (string4.equals("880")) {
                string4 = this.get880AssociatedFieldTag(dataField);
            }
            if ((object3 = this.config.getIndexProp(string4)) == null) continue;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (FieldIndexProp)object2.next();
                if (hashSet.contains(((FieldIndexProp)object).getFieldName())) continue;
                String string7 = this.getDataFieldStr((FieldIndexProp)object, dataField);
                if (!string7.isEmpty()) {
                    if ("title_sort".equals(((FieldIndexProp)object).getFieldName())) {
                        if (dataField.getInd2() > '0' && dataField.getInd2() <= '9' && string7.length() > dataField.getInd2() - 48) {
                            string7 = string7.substring(dataField.getInd2() - 48);
                        }
                        string7 = string7.replaceAll("[\\[\\](){},.:;!?<>%]", " ").replaceAll("\\s+", " ");
                    } else if ("datePublication".equals(((FieldIndexProp)object).getFieldName())) {
                        arrayList.add(new Field("datePubSort", string7.replaceAll("\\D", "")));
                    } else if ("isbn_first".equals(((FieldIndexProp)object).getFieldName())) {
                        string7 = this.fixISBN(string7);
                    }
                    if (!"barcode".equals(((FieldIndexProp)object).getFieldName())) {
                        string7 = string7.replaceAll("[.,:;]+$", "");
                    }
                    arrayList.add(new Field(((FieldIndexProp)object).getFieldName(), string7));
                }
                if (!((FieldIndexProp)object).isFirstFieldOnly()) continue;
                hashSet.add(((FieldIndexProp)object).getFieldName());
            }
        }
        return arrayList;
    }

    private String getDataFieldStr(FieldIndexProp fieldIndexProp, DataField dataField) {
        String string = "";
        if (!fieldIndexProp.getSubfieldsIncl().isEmpty()) {
            for (char c : fieldIndexProp.getSubfieldsIncl()) {
                List<Subfield> list = dataField.getSubfields(c);
                if (list == null) continue;
                for (Subfield subfield : list) {
                    if (!string.isEmpty()) {
                        string = string + fieldIndexProp.getSfConcatStr();
                    }
                    string = string + subfield.getData();
                }
            }
        } else if (!fieldIndexProp.getSubfieldsExcl().isEmpty()) {
            for (Subfield subfield : dataField.getSubFields()) {
                if (!fieldIndexProp.indexSubfield(subfield.getCode())) continue;
                if (!string.isEmpty()) {
                    string = string + fieldIndexProp.getSfConcatStr();
                }
                string = string + subfield.getData();
            }
        }
        string = string.trim();
        return string;
    }

    private String get880AssociatedFieldTag(DataField dataField) {
        String string;
        Subfield subfield;
        String string2 = "";
        if (dataField.getTag().equals("880") && (subfield = dataField.get1stSubfield('6')) != null && subfield.getData().length() > 3 && (string = subfield.getData().substring(0, 3)).matches("^[0-9]{3}$")) {
            string2 = string;
        }
        return string2;
    }

    private String fixISBN(String string) {
        Pattern pattern = Pattern.compile("([\\D^x^X]*)([\\dxX][\\dxX-]{8,}[\\dxX])([\\D^x^X]*)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            string = matcher.group(2);
        }
        return string;
    }

    private static boolean isvalidPointvalue(String string) {
        try {
            Float.parseFloat(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private List<Field> getBisacSbjField(MarcRecord marcRecord) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        List<DataField> list = marcRecord.getDataFields("650");
        if (list != null) {
            for (DataField dataField : list) {
                char c = dataField.getInd2();
                char c2 = dataField.getInd1();
                Subfield subfield = dataField.get1stSubfield('2');
                Subfield subfield2 = dataField.get1stSubfield('a');
                if (subfield == null || subfield2 == null || c2 != ' ' || c != '7' || !subfield.getData().equals("bisacsh") || subfield2.getData().isEmpty()) continue;
                arrayList.add(new Field("bisac", subfield2.getData()));
            }
        }
        return arrayList;
    }

    private List<Field> getPublicationField(MarcRecord marcRecord) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        List<DataField> list = marcRecord.getDataFields("264");
        DataField object = null;
        if (list != null) {
            for (DataField object2 : list) {
                char subfield2 = object2.getInd2();
                if (subfield2 != '1') continue;
                object = object2;
                break;
            }
        }
        if (object == null && (list = marcRecord.getDataFields("260")) != null && list.size() > 0) {
            object = list.get(0);
        }
        if (object != null) {
            Subfield subfield = object.get1stSubfield('a');
            Subfield subfield2 = object.get1stSubfield('b');
            Subfield subfield3 = object.get1stSubfield('c');
            if (subfield != null) {
                arrayList.add(new Field("placePublication", subfield.getData()));
            }
            if (subfield2 != null) {
                arrayList.add(new Field("namePublisher", subfield2.getData()));
            }
            if (subfield3 != null) {
                arrayList.add(new Field("datePublication", subfield3.getData()));
                arrayList.add(new Field("datePubSort", subfield3.getData().replaceAll("\\D", "")));
            }
        }
        return arrayList;
    }

    private List<Field> getARLField(MarcRecord marcRecord) {
        ArrayList<Field> arrayList = null;
        List<DataField> list = marcRecord.getDataFields("526");
        boolean bl = false;
        boolean bl2 = false;
        String[][] stringArrayArray = new String[][]{{"b", "interestLevel"}, {"c", "readingLevel"}, {"d", "pointValue"}, {"z", "quizNumber"}};
        if (list != null && !list.isEmpty()) {
            arrayList = new ArrayList<Field>();
            String string = "";
            for (DataField dataField : list) {
                Subfield subfield = dataField.get1stSubfield('a');
                if (subfield == null) continue;
                if (subfield.getData().matches("(?i)(.*)(accelerated[\\s]+reader|ar(.*))") && bl < true) {
                    arrayList.add(new Field("studyPrgm", "Accelerated Reader"));
                    string = "AR_";
                    bl = true;
                } else {
                    if (!subfield.getData().matches("(?i)(.*)(reading[\\s]+count|rc(.*))") || bl2 >= true) continue;
                    arrayList.add(new Field("studyPrgm", "Reading counts"));
                    string = "RC_";
                    bl2 = true;
                }
                for (String[] stringArray : stringArrayArray) {
                    subfield = dataField.get1stSubfield(stringArray[0].charAt(0));
                    if (subfield == null || (stringArray[0].charAt(0) == 'c' || stringArray[0].charAt(0) == 'd') && !MarcXmlSolrParser.isvalidPointvalue(subfield.getData())) continue;
                    arrayList.add(new Field(string + stringArray[1], subfield.getData()));
                }
            }
        }
        return arrayList;
    }

    private List<String> getSubjectList(List<Field> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Field field : list) {
            if (!"subject".equals(field.getName())) continue;
            arrayList.add(field.getData());
        }
        return arrayList;
    }

    private List<String> getAuthorList(List<Field> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Field field : list) {
            if (!"author".equals(field.getName())) continue;
            arrayList.add(field.getData());
        }
        return arrayList;
    }

    private List<Field> getLexileFields(MarcRecord marcRecord) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        List<DataField> list = marcRecord.getDataFields("521");
        for (DataField dataField : list) {
            char c = dataField.getInd1();
            if (c == '8') {
                Pattern pattern;
                Matcher matcher;
                Subfield subfield = dataField.get1stSubfield('a');
                Subfield subfield2 = dataField.get1stSubfield('b');
                if (subfield != null && subfield2 != null && subfield2.getData().matches("(?i:.*lexile.*)") && (matcher = (pattern = Pattern.compile("([\\D]*)(\\d*)")).matcher(subfield.getData().trim())).find()) {
                    if (!matcher.group(1).isEmpty()) {
                        arrayList.add(new Field("lexileCode", matcher.group(1)));
                    }
                    if (!matcher.group(2).isEmpty()) {
                        arrayList.add(new Field("lexileMeasure", matcher.group(2)));
                    }
                }
            }
            if (arrayList.size() < 1) continue;
            break;
        }
        return arrayList;
    }

    private Field getFountasPinnellField(MarcRecord marcRecord) {
        Field field = null;
        List<DataField> list = marcRecord.getDataFields("521");
        for (DataField dataField : list) {
            char c = dataField.getInd1();
            if (c == '8') {
                Subfield subfield = dataField.get1stSubfield('a');
                Subfield subfield2 = dataField.get1stSubfield('b');
                if (subfield2 != null && subfield2.getData().matches("(?i:.*((Fountas|f)(\\s*)(and|&|&amp;)*(\\s*)(p|Pinnell))).*") && subfield != null) {
                    field = new Field("fountasPinnell", subfield.getData().toUpperCase().trim());
                }
            }
            if (field == null) continue;
            break;
        }
        return field;
    }

    private List<SolrInputDocument> getSbjAuthFields(MarcRecord marcRecord) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        ArrayList<SolrInputDocument> arrayList = new ArrayList<SolrInputDocument>();
        List<DataField> list = marcRecord.getDataFields();
        HashMap hashMap = new HashMap(){
            {
                this.put(Character.valueOf('0'), "Library of Conpgress Subject Headings");
                this.put(Character.valueOf('1'), "LC subject headings for children's literature");
                this.put(Character.valueOf('2'), "Medical Subject Headings");
                this.put(Character.valueOf('3'), "Medical Subject Headings");
                this.put(Character.valueOf('4'), "Source not specified");
                this.put(Character.valueOf('5'), "Canadian Subject Headings");
                this.put(Character.valueOf('6'), "R\u00e9pertoire de vedettes-mati\u00e8re");
            }
        };
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        String string = "^6(00|10|11|30|48|50|51|53|54|55|56|57|58|62|9[\\d])$";
        for (DataField dataField : list) {
            if (!Pattern.matches(string, dataField.getTag())) continue;
            SolrInputDocument solrInputDocument = new SolrInputDocument();
            solrInputDocument.addField("tag", dataField.getTag());
            solrInputDocument.addField("ind1", Character.valueOf(dataField.getInd1()));
            solrInputDocument.addField("ind2", Character.valueOf(dataField.getInd2()));
            String string2 = "";
            String string3 = "";
            String string4 = (String)hashMap.get(Character.valueOf(dataField.getInd2()));
            for (Subfield subfield : dataField.getSubFields()) {
                char c = subfield.getCode();
                if (c == '-' || c == '2' && '7' != dataField.getInd2()) continue;
                if (c == '2') {
                    string4 = this.unEscapeXml(subfield.getData());
                    continue;
                }
                string2 = string2 + String.format("$%c%s", Character.valueOf(c), this.unEscapeXml(subfield.getData().replaceAll("[\\.:;]+", "")));
                if (!string3.isEmpty()) {
                    string3 = string3 + " -- ";
                }
                string3 = string3 + this.unEscapeXml(subfield.getData().replaceAll("[\\.:;]+", ""));
            }
            solrInputDocument.addField("sbj_source", string4);
            solrInputDocument.addField("sbj_subfields", string2);
            solrInputDocument.addField("subject_grp", this.unEscapeXml(string3));
            String string5 = dataField.getTag() + dataField.getInd1() + dataField.getInd2() + string2;
            solrInputDocument.addField("id", new BigInteger(1, messageDigest.digest(string5.getBytes("UTF-8"))).toString(16));
            arrayList.add(solrInputDocument);
        }
        return arrayList;
    }

    private List<Field> getLccDewyFields(MarcRecord marcRecord) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        List<DataField> list = marcRecord.getDataFields("852");
        boolean bl = false;
        for (DataField dataField : list) {
            String string;
            Subfield subfield = dataField.get1stSubfield('h');
            if (subfield == null) continue;
            LccNum lccNum = lccUtil.parseLcc(subfield.getData());
            if (lccNum != null) {
                if (!bl) {
                    arrayList.add(new Field("lccSort", lccNum.getSortVal()));
                    bl = true;
                }
                arrayList.add(new Field("lcc", subfield.getData()));
                string = lccUtil.getLccGrp(subfield.getData());
                arrayList.add(new Field("lccGrp", string));
            }
            if ((string = lccUtil.getDewey(subfield.getData())) == null || string.isEmpty()) continue;
            arrayList.add(new Field("dewey", string));
            arrayList.add(new Field("deweyClass", lccUtil.getDeweyClass(string)));
        }
        return arrayList;
    }

    private class Field {
        private String name;
        private String data;

        private Field(String string, String string2) {
            this.name = string;
            this.data = string2;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String string) {
            this.data = string;
        }
    }
}

