/*
 * Decompiled with CFR 0.152.
 */
package opalsindexer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import opalsindexer.MarcXmlSolrParser;
import opalsindexer.SolrDocPoster;
import org.apache.solr.common.SolrInputDocument;

public class Indexer {
    static MarcXmlSolrParser mParser;
    private SolrDocPoster solrDocPoster;
    private String sHost = "";
    private String sPort = "8983";
    private String sDb = "";
    private String sIndexConfig = "/etc/solr/conf/indexConf.xml";
    private String solrDataDir = "/data/solr/";
    private String zDataDir = "";
    private String db_name = "";
    private String db_host = "";
    private String db_port = "";
    private String db_user = "";
    private String db_password = "";

    public Indexer(String string, String string2, String string3) throws FileNotFoundException, IOException {
        this.loadConfig(string);
        this.sIndexConfig = string2;
        if (!new File(this.sIndexConfig).exists()) {
            System.err.println("Unable to read opals configuaration!");
            System.exit(0);
        }
        if (!this.sHost.isEmpty() && !this.sDb.isEmpty()) {
            this.solrDocPoster = new SolrDocPoster("http://" + this.sHost + ":" + this.sPort + "/solr/" + this.sDb);
            mParser = new MarcXmlSolrParser(this.sIndexConfig);
        }
        if (string3 != null && new File(string3).exists()) {
            this.solrDataDir = string3;
        }
    }

    public Indexer(String string, String string2) throws FileNotFoundException, IOException {
        this(string, string, null);
    }

    public void update() throws SQLException, ClassNotFoundException, IOException, UnsupportedEncodingException, NoSuchAlgorithmException {
        if (this.solrDocPoster == null || mParser == null) {
            return;
        }
        Map<String, String> map = this.getIndexStats();
        String string = map.get("lastUpdate");
        String string2 = map.get("lastRatingDate");
        String string3 = map.get("lastChkItemStatusId");
        String string4 = map.get("lastSetNewItemDate");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Connection connection = this.getDbConnection();
        Map<String, String> map2 = this.getNewIndexStats(connection);
        Statement statement = connection.createStatement();
        String string5 = " select distinct t.rid as rid, if(s.rid is null,-1,s.rid)as valRid   from (select distinct rid from opl_marcRecord m left outer join opl_item i using(rid)        where (date_add(i.modDate,interval 1 second)>'" + string + "' or date_add(m.modDate,interval 1 second)>'" + string + "')) as t " + "       left outer join opl_item s on s.rid=t.rid && s.barcode not regexp '^___|^PURGED_'" + " UNION select i.rid, i.rid as valRid from opl_item i inner join opl_itemstatus s using (barcode) " + "       where s.id>" + string3 + " && s.status=6 " + " UNION select rid,rid as valRid from  opl_cmntRating where accepted=true && modDate >'" + string2 + "' " + " UNION select rid,rid as valRid from  opl_featureItem where feature='newItem' && modDate >'" + string4 + "' ";
        ResultSet resultSet = statement.executeQuery(string5);
        boolean bl = true;
        int n = 0;
        while (resultSet.next() && bl) {
            int n2 = resultSet.getInt("rid");
            int n3 = resultSet.getInt("valRid");
            String string6 = this.getRecordFilePath(n2);
            if (!string6.isEmpty() && n3 > 0 && !this.isWithdrawnRec(connection, n2)) {
                System.out.printf("[%s]\t%s: update record: %d\n", simpleDateFormat.format(new Date()), this.db_name, n2);
                List<SolrInputDocument> list = mParser.parse2SolrDocs(string6);
                Map<String, String> map3 = this.getDocOptianalFields(connection, n2);
                if (map3 != null && map3.size() > 0) {
                    for (SolrInputDocument solrInputDocument : list) {
                        if (!((String)solrInputDocument.getFieldValue("db")).equalsIgnoreCase("main")) continue;
                        for (Map.Entry<String, String> entry : map3.entrySet()) {
                            solrInputDocument.addField(entry.getKey(), entry.getValue());
                        }
                    }
                }
                if (bl = this.solrDocPoster.deleteDocByRid("" + n2)) {
                    bl = this.solrDocPoster.update(list);
                }
            } else {
                System.out.printf("[%s]\t%s: delete record: %d\n", simpleDateFormat.format(new Date()), this.db_name, n2);
                bl = this.solrDocPoster.deleteDocByRid("" + n2);
            }
            ++n;
        }
        if (n > 0 && bl && this.solrDocPoster.postCommit()) {
            this.saveIndexStats(map2);
        }
        resultSet.close();
        statement.close();
        connection.close();
    }

    private Connection getDbConnection() throws SQLException {
        Connection connection = null;
        Properties properties = new Properties();
        properties.put("user", this.db_user);
        properties.put("password", this.db_password);
        connection = DriverManager.getConnection("jdbc:mysql://" + this.db_host + ":" + this.db_port + "/" + this.db_name, properties);
        this.initTimezone(connection);
        return connection;
    }

    private void initTimezone(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select val from  opl_preference where  var='timezone'");
        if (resultSet.next()) {
            String string = resultSet.getString("val");
            statement.executeQuery("set time_zone='" + string + "'");
        }
    }

    private void saveLastUpdateDate(String string) throws IOException {
        File file = new File(this.solrDataDir + "/" + this.sDb + "/lastUpdate.txt");
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(string);
        fileWriter.flush();
        fileWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLastUpdateDate() {
        FileReader fileReader = null;
        String string = "1970-01-01 00:00:00";
        try {
            File file = new File(this.solrDataDir + "/" + this.sDb + "/lastUpdate.txt");
            fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            string = bufferedReader.readLine();
            fileReader.close();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Logger.getLogger(Indexer.class.getName()).log(Level.SEVERE, null, iOException);
        }
        finally {
            return string;
        }
    }

    private Map<String, String> getNewIndexStats(Connection connection) throws SQLException {
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Statement statement = connection.createStatement();
        String string = "select if(max(m.modDate)> max(i.modDate),max(m.modDate),max(i.modDate)) modDate  from opl_item i inner join opl_marcRecord m using(rid)";
        ResultSet resultSet = statement.executeQuery("select now() as curDate ");
        Date date = new Date();
        if (resultSet.next()) {
            date = resultSet.getTimestamp("curDate");
        }
        if ((resultSet = statement.executeQuery(string)).next()) {
            object = resultSet.getTimestamp("modDate");
            if (object == null) {
                object = date;
            }
            hashMap.put("lastUpdate", simpleDateFormat.format((Date)object));
        }
        if ((resultSet = statement.executeQuery("select max(id) as id  from opl_itemstatus")).next()) {
            object = resultSet.getString("id");
            if (object == null) {
                object = "0";
            }
            hashMap.put("lastChkItemStatusId", (String)object);
        }
        if ((resultSet = statement.executeQuery("select max(modDate) lastRatingDate from opl_cmntRating where accepted=true")).next()) {
            object = resultSet.getTimestamp("lastRatingDate");
            if (resultSet.getTimestamp("lastRatingDate") == null) {
                object = date;
            }
            hashMap.put("lastRatingDate", simpleDateFormat.format((Date)object));
        }
        if ((resultSet = statement.executeQuery("select max(modDate) lastSetNewItemDate from opl_featureItem where feature='newItem'")).next()) {
            object = resultSet.getTimestamp("lastSetNewItemDate");
            if (resultSet.getTimestamp("lastSetNewItemDate") == null) {
                object = date;
            }
            hashMap.put("lastSetNewItemDate", simpleDateFormat.format((Date)object));
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Map<String, String> getIndexStats() {
        Map<Object, Object> map;
        block19: {
            map = new HashMap<String, String>();
            try {
                map = this.getOpalsConfig(this.solrDataDir + "/" + this.sDb + "/indexStats.txt");
                if (map.containsKey("lastUpdate")) break block19;
                map.put("lastUpdate", "1970-01-01 00:00:00");
            }
            catch (FileNotFoundException fileNotFoundException) {
                block20: {
                    Logger.getLogger(Indexer.class.getName()).log(Level.SEVERE, null, fileNotFoundException);
                    if (map.containsKey("lastUpdate")) break block20;
                    map.put("lastUpdate", "1970-01-01 00:00:00");
                }
                if (!map.containsKey("lastCheckItemStatusId")) {
                    map.put("lastCheckItemStatusId", "0");
                }
                if (!map.containsKey("lastRatingDate")) {
                    map.put("lastRatingDate", "1970-01-01 00:00:00");
                }
                if (!map.containsKey("lastSetNewItemDate")) {
                    map.put("lastSetNewItemDate", "1970-01-01 00:00:00");
                }
                return map;
            }
            catch (IOException iOException) {
                block21: {
                    Logger.getLogger(Indexer.class.getName()).log(Level.SEVERE, null, iOException);
                    if (map.containsKey("lastUpdate")) break block21;
                    map.put("lastUpdate", "1970-01-01 00:00:00");
                    {
                        catch (Throwable throwable) {
                            if (!map.containsKey("lastUpdate")) {
                                map.put("lastUpdate", "1970-01-01 00:00:00");
                            }
                            if (!map.containsKey("lastCheckItemStatusId")) {
                                map.put("lastCheckItemStatusId", "0");
                            }
                            if (!map.containsKey("lastRatingDate")) {
                                map.put("lastRatingDate", "1970-01-01 00:00:00");
                            }
                            if (!map.containsKey("lastSetNewItemDate")) {
                                map.put("lastSetNewItemDate", "1970-01-01 00:00:00");
                            }
                            return map;
                        }
                    }
                }
                if (!map.containsKey("lastCheckItemStatusId")) {
                    map.put("lastCheckItemStatusId", "0");
                }
                if (!map.containsKey("lastRatingDate")) {
                    map.put("lastRatingDate", "1970-01-01 00:00:00");
                }
                if (!map.containsKey("lastSetNewItemDate")) {
                    map.put("lastSetNewItemDate", "1970-01-01 00:00:00");
                }
                return map;
            }
        }
        if (!map.containsKey("lastCheckItemStatusId")) {
            map.put("lastCheckItemStatusId", "0");
        }
        if (!map.containsKey("lastRatingDate")) {
            map.put("lastRatingDate", "1970-01-01 00:00:00");
        }
        if (!map.containsKey("lastSetNewItemDate")) {
            map.put("lastSetNewItemDate", "1970-01-01 00:00:00");
        }
        return map;
    }

    private void saveIndexStats(Map<String, String> map) throws IOException {
        File file = new File(this.solrDataDir + "/" + this.sDb + "/indexStats.txt");
        FileWriter fileWriter = new FileWriter(file);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            fileWriter.write(entry.getKey() + "=" + entry.getValue() + "\n");
        }
        fileWriter.flush();
        fileWriter.close();
    }

    private String getRecordFilePath(int n) {
        String string;
        File file;
        int n2 = n / 1000;
        if (n % 1000 > 0) {
            ++n2;
        }
        return (file = new File(string = this.zDataDir + "/" + n2 + "/" + n + ".xml")).exists() ? string : "";
    }

    private boolean isWithdrawnRec(Connection connection, int n) throws SQLException {
        boolean bl = true;
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select count(*) as count from opl_item i left outer join  (select barcode,status from opl_itemstatus inner join (select max(id) id  from opl_itemstatus s  inner join opl_item using(barcode) where rid=" + n + " group by s.barcode ) t using(id)) t2 using(barcode)" + " where (t2.status is null || t2.status<>13)&& i.barcode not regexp '___' && i.rid=" + n);
        if (resultSet.next() && resultSet.getInt("count") > 0) {
            bl = false;
        }
        return bl;
    }

    private Map<String, String> getDocOptianalFields(Connection connection, int n) throws SQLException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select count(rid) totalReview, round(AVG(rate),1) avgRating from opl_cmntRating where accepted=true && rid=" + n + " && deleted=0");
        if (resultSet.next()) {
            float f = resultSet.getFloat("avgRating");
            int n2 = resultSet.getInt("totalReview");
            if (f > 0.0f) {
                hashMap.put("totalReview", "" + n2);
                hashMap.put("avgRating", "" + f);
                String string = "";
                double d = (double)f - Math.floor(f);
                string = d > 0.25 && d < 0.75 ? String.format("%d.5", Math.round((float)Math.floor(f))) : String.format("%d", Math.round(f));
                hashMap.put("numOfStarsRating", string);
            }
        }
        if ((resultSet = statement.executeQuery("select DATE_FORMAT(max(cmntDate),'%Y-%m-%dT%H:%i:%sZ') lastReviewed from opl_cmntRating where accepted=true && rid=" + n + " && deleted=0")).next()) {
            String string = resultSet.getString("lastReviewed");
            hashMap.put("lastReviewed", string);
        }
        if ((resultSet = statement.executeQuery("select DATE_FORMAT(min(dateImport),'%Y-%m-%dT%H:%i:%sZ') dateImport  from opl_item where rid=" + n)).next()) {
            hashMap.put("dateImport", resultSet.getString("dateImport"));
        }
        if ((resultSet = statement.executeQuery("select DATE_FORMAT(min(expiryDate),'%Y-%m-%dT%H:%i:%sZ') expiryDate  from opl_featureItem where feature='newItem' && rid=" + n)).next()) {
            hashMap.put("dateNewItemExpire", resultSet.getString("expiryDate"));
        }
        return hashMap;
    }

    private void loadConfig(String string) throws FileNotFoundException, IOException {
        Map<String, String> map = this.getOpalsConfig(string);
        File file = new File(string);
        if (!file.exists() || !file.canRead()) {
            System.err.printf("Error: unable to read %s", string);
        }
        if (map.containsKey("zDatabase")) {
            this.sDb = map.get("zDatabase");
        } else {
            System.err.printf("Error: database name is missing in %s", string);
        }
        if (map.containsKey("sHost")) {
            this.sHost = map.get("sHost");
        }
        if (map.containsKey("sPort")) {
            this.sPort = map.get("sPort");
        }
        if (map.containsKey("zRoot") && map.containsKey("zPort")) {
            this.zDataDir = String.format("%s/%s/record/%s", map.get("zRoot"), map.get("zPort"), this.sDb);
        }
        if (map.containsKey("db_host")) {
            this.db_host = map.get("db_host");
        }
        if (map.containsKey("db_name")) {
            this.db_name = map.get("db_name");
        }
        if (map.containsKey("db_password")) {
            this.db_password = map.get("db_password");
        }
        if (map.containsKey("db_port")) {
            this.db_port = map.get("db_port");
        }
        if (map.containsKey("db_user")) {
            this.db_user = map.get("db_user");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getOpalsConfig(String string) throws FileNotFoundException, IOException {
        FileReader fileReader = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = "";
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                if ((string2 = string2.trim()).startsWith("#") || (n = string2.indexOf(61)) <= 0) continue;
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                hashMap.put(string3, string4);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(Indexer.class.getName()).log(Level.SEVERE, null, fileNotFoundException);
        }
        catch (IOException iOException) {
            Logger.getLogger(Indexer.class.getName()).log(Level.SEVERE, null, iOException);
        }
        finally {
            try {
                fileReader.close();
            }
            catch (IOException iOException) {
                Logger.getLogger(Indexer.class.getName()).log(Level.SEVERE, null, iOException);
            }
            return hashMap;
        }
    }
}

