/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.marc.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.IllegalAddException;
import org.marc4j.marc.Leader;
import org.marc4j.marc.Record;
import org.marc4j.marc.VariableField;
import org.marc4j.marc.impl.Verifier;

public class RecordImpl
implements Record {
    private Long id;
    private Leader leader;
    private List controlFields = new ArrayList();
    private List dataFields = new ArrayList();
    private String type;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setLeader(Leader leader) {
        this.leader = leader;
    }

    public Leader getLeader() {
        return this.leader;
    }

    public void addVariableField(VariableField field) {
        if (!(field instanceof VariableField)) {
            throw new IllegalAddException("Expected VariableField instance");
        }
        String tag = field.getTag();
        try {
            if (Verifier.isControlNumberField(tag)) {
                if (Verifier.hasControlNumberField(this.controlFields)) {
                    this.controlFields.set(0, field);
                } else {
                    this.controlFields.add(0, field);
                }
                Collections.sort(this.controlFields);
            } else if (Verifier.isControlField(tag)) {
                this.controlFields.add(field);
                Collections.sort(this.controlFields);
            } else {
                this.dataFields.add(field);
                Collections.sort(this.dataFields);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public void removeVariableField(VariableField field) {
        String tag = field.getTag();
        if (Verifier.isControlField(tag)) {
            this.controlFields.remove(field);
        } else {
            this.dataFields.remove(field);
        }
    }

    public ControlField getControlNumberField() {
        if (Verifier.hasControlNumberField(this.controlFields)) {
            return (ControlField)this.controlFields.get(0);
        }
        return null;
    }

    public List getControlFields() {
        return this.controlFields;
    }

    public List getDataFields() {
        return this.dataFields;
    }

    public VariableField getVariableField(String tag) {
        Iterator i = Verifier.isControlField(tag) ? this.controlFields.iterator() : this.dataFields.iterator();
        while (i.hasNext()) {
            VariableField field = (VariableField)i.next();
            if (!field.getTag().equals(tag)) continue;
            return field;
        }
        return null;
    }

    public List getVariableFields(String tag) {
        ArrayList<VariableField> fields = new ArrayList<VariableField>();
        Iterator i = Verifier.isControlField(tag) ? this.controlFields.iterator() : this.dataFields.iterator();
        while (i.hasNext()) {
            VariableField field = (VariableField)i.next();
            if (!field.getTag().equals(tag)) continue;
            fields.add(field);
        }
        return fields;
    }

    public List getVariableFields() {
        ArrayList fields = new ArrayList();
        Iterator i = this.controlFields.iterator();
        while (i.hasNext()) {
            fields.add(i.next());
        }
        i = this.dataFields.iterator();
        while (i.hasNext()) {
            fields.add(i.next());
        }
        return fields;
    }

    public String getControlNumber() {
        return new String(this.getControlNumberField().getData());
    }

    public List getVariableFields(String[] tags) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < tags.length; ++i) {
            String tag = tags[i];
            List fields = this.getVariableFields(tag);
            if (fields.size() <= 0) continue;
            list.addAll(fields);
        }
        return list;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("LEADER ");
        sb.append(this.getLeader().toString());
        sb.append('\n');
        for (VariableField field : this.getVariableFields()) {
            sb.append(field.toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    public List find(String pattern) {
        ArrayList<VariableField> result = new ArrayList<VariableField>();
        for (VariableField field : this.controlFields) {
            if (!field.find(pattern)) continue;
            result.add(field);
        }
        for (VariableField field : this.dataFields) {
            if (!field.find(pattern)) continue;
            result.add(field);
        }
        return result;
    }

    public List find(String tag, String pattern) {
        ArrayList<VariableField> result = new ArrayList<VariableField>();
        for (VariableField field : this.getVariableFields(tag)) {
            if (!field.find(pattern)) continue;
            result.add(field);
        }
        return result;
    }

    public List find(String[] tag, String pattern) {
        ArrayList<VariableField> result = new ArrayList<VariableField>();
        for (VariableField field : this.getVariableFields(tag)) {
            if (!field.find(pattern)) continue;
            result.add(field);
        }
        return result;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }
}

