/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.util.HashMap;
import org.marc4j.RecordStack;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.MarcFactory;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class MarcXmlHandler
implements ContentHandler {
    private RecordStack queue;
    private InputSource input;
    private StringBuffer sb;
    private Subfield subfield;
    private ControlField controlField;
    private DataField dataField;
    private Record record;
    private String tag;
    private static final int COLLECTION_ID = 1;
    private static final int LEADER_ID = 2;
    private static final int RECORD_ID = 3;
    private static final int CONTROLFIELD_ID = 4;
    private static final int DATAFIELD_ID = 5;
    private static final int SUBFIELD_ID = 6;
    private static final String TAG_ATTR = "tag";
    private static final String CODE_ATTR = "code";
    private static final String IND_1_ATTR = "ind1";
    private static final String IND_2_ATTR = "ind2";
    private static final HashMap elementMap = new HashMap();
    private MarcFactory factory = null;

    public MarcXmlHandler(RecordStack queue) {
        this.queue = queue;
        this.factory = MarcFactory.newInstance();
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String uri, String name, String qName, Attributes atts) throws SAXException {
        String realname = name.length() == 0 ? qName : name;
        Integer elementType = (Integer)elementMap.get(realname);
        if (elementType == null) {
            return;
        }
        switch (elementType) {
            case 1: {
                break;
            }
            case 3: {
                this.record = this.factory.newRecord();
                break;
            }
            case 2: {
                this.sb = new StringBuffer();
                break;
            }
            case 4: {
                this.sb = new StringBuffer();
                this.tag = atts.getValue(TAG_ATTR);
                this.controlField = this.factory.newControlField(this.tag);
                break;
            }
            case 5: {
                this.tag = atts.getValue(TAG_ATTR);
                String ind1 = atts.getValue(IND_1_ATTR);
                String ind2 = atts.getValue(IND_2_ATTR);
                this.dataField = this.factory.newDataField(this.tag, ind1.charAt(0), ind2.charAt(0));
                break;
            }
            case 6: {
                this.sb = new StringBuffer();
                String code = atts.getValue(CODE_ATTR);
                this.subfield = this.factory.newSubfield(code.charAt(0));
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.sb != null) {
            this.sb.append(ch, start, length);
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        String realname = name.length() == 0 ? qName : name;
        Integer elementType = (Integer)elementMap.get(realname);
        if (elementType == null) {
            return;
        }
        switch (elementType) {
            case 1: {
                break;
            }
            case 3: {
                this.queue.push(this.record);
                break;
            }
            case 2: {
                Leader leader = this.factory.newLeader(this.sb.toString());
                this.record.setLeader(leader);
                break;
            }
            case 4: {
                this.controlField.setData(this.sb.toString());
                this.record.addVariableField(this.controlField);
                break;
            }
            case 5: {
                this.record.addVariableField(this.dataField);
                break;
            }
            case 6: {
                this.subfield.setData(this.sb.toString());
                this.dataField.addSubfield(this.subfield);
            }
        }
    }

    public void endDocument() throws SAXException {
        this.queue.end();
    }

    public void ignorableWhitespace(char[] data, int offset, int length) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    static {
        elementMap.put("collection", new Integer(1));
        elementMap.put("leader", new Integer(2));
        elementMap.put("record", new Integer(3));
        elementMap.put("controlfield", new Integer(4));
        elementMap.put("datafield", new Integer(5));
        elementMap.put("subfield", new Integer(6));
    }
}

