/*
 * Decompiled with CFR 0.152.
 */
package opalsindexer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import opalsindexer.Indexer;

public class Main {
    private Map<File, Indexer> osiList;
    private static String opalsConfPath = "";
    private static String solrIndexConf = "";
    private static String solrDataDir = "";
    private static int interval = 60000;

    public static String getSolrDataDir() {
        return solrDataDir;
    }

    public static void setSolrDataDir(String string) {
        solrDataDir = string;
    }

    public static void main(String[] stringArray) throws FileNotFoundException, IOException, UnsupportedEncodingException, NoSuchAlgorithmException {
        Main main = new Main();
        main.osiList = new LinkedHashMap<File, Indexer>();
        if (!main.readSysProperties()) {
            main.printInstruction();
            System.exit(0);
        }
        System.out.println("Starting...");
        while (true) {
            System.out.println(new Date());
            main.loadDb();
            main.run();
            try {
                Thread.sleep(interval);
                continue;
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, interruptedException);
                continue;
            }
            break;
        }
    }

    public void run() throws UnsupportedEncodingException, NoSuchAlgorithmException {
        for (Map.Entry<File, Indexer> entry : this.osiList.entrySet()) {
            try {
                System.out.println("checking database:" + entry.getKey().getName());
                entry.getValue().update();
            }
            catch (SQLException sQLException) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, sQLException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, classNotFoundException);
            }
            catch (IOException iOException) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
    }

    public boolean readSysProperties() {
        boolean bl = true;
        String string = System.getProperty("delay");
        if (string == null) {
            interval = 30000;
        } else {
            try {
                interval = Integer.parseInt(string) * 1000;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        String string2 = System.getProperty("solr.home");
        if (solrIndexConf == null) {
            bl = false;
        } else {
            solrIndexConf = string2 + "/conf/indexConf.xml";
            File file = new File(solrIndexConf);
            if (!file.exists()) {
                bl = false;
            }
        }
        opalsConfPath = System.getProperty("opals.conf");
        if (opalsConfPath == null) {
            bl = false;
        }
        solrDataDir = System.getProperty("solr.dataDir");
        return bl;
    }

    public void printInstruction() {
        System.out.println("usage: java -jar -Ddelay={delay interval} -Dopals.conf={path to opals conf dir} -Dsolr.home={path to solr home dir} OpalsIndexer.jar");
        System.out.println("example: java -jar -Ddelay=60 -Dopals.conf=/etc/opals/conf -Dsolr.home=/etc/solr OpalsIndexer.jar ");
    }

    public void loadDb() throws FileNotFoundException, IOException {
        File file = new File(opalsConfPath);
        for (File file2 : file.listFiles()) {
            if (this.osiList.containsKey(file2)) continue;
            System.out.println("adding database:" + file2.getName());
            this.osiList.put(file2, new Indexer(file2.getAbsolutePath(), solrIndexConf, solrDataDir));
        }
    }

    public static String getOpalsConfPath() {
        return opalsConfPath;
    }

    public static void setOpalsConfPath(String string) {
        opalsConfPath = string;
    }

    public static void setSolrIndexConf(String string) {
        solrIndexConf = string;
    }

    public static String getSolrIndexConf() {
        return solrIndexConf;
    }

    public static int getInterval() {
        return interval;
    }

    public static void setInterval(int n) {
        interval = n;
    }
}

