/*
 * Decompiled with CFR 0.152.
 */
package opals.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ISBNValidator {
    private static String CheckDigits = "0123456789X0";

    static String fixISBN(String string) {
        Pattern pattern = Pattern.compile("([\\D^x^X]*)([\\dxX][\\dxX-]{8,}[\\dxX])([\\D^x^X]*)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            string = matcher.group(2);
        }
        return string;
    }

    public static int CharToInt(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
        }
        return -1;
    }

    public static String ISBN1310(String string) {
        boolean bl = false;
        String string2 = string.substring(3, 12);
        int n = 0;
        for (int i = 0; i < 9; ++i) {
            if (bl) continue;
            int n2 = ISBNValidator.CharToInt(string2.charAt(i));
            if (n2 == -1) {
                bl = true;
                continue;
            }
            n += (10 - i) * n2;
        }
        if (bl) {
            return "";
        }
        n = 11 - n % 11;
        return string2 + CheckDigits.substring(n, n + 1);
    }

    public static String ISBN1013(String string) {
        boolean bl = false;
        String string2 = "978" + string.substring(0, 9);
        int n = 0;
        for (int i = 0; i < 12; ++i) {
            if (bl) continue;
            int n2 = ISBNValidator.CharToInt(string2.charAt(i));
            if (n2 == -1) {
                bl = true;
                continue;
            }
            if (i % 2 == 0) {
                n += n2;
                continue;
            }
            n += 3 * n2;
        }
        if (bl) {
            return "";
        }
        if ((n %= 10) != 0) {
            n = 10 - n;
        }
        return string2 + CheckDigits.substring(n, n + 1);
    }
}

