/*
 * Decompiled with CFR 0.152.
 */
package opals.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opals.util.LccNum;

public class CallnumberUtil {
    static Map<String, List<LCC>> LCCTbl = new HashMap<String, List<LCC>>();
    static NavigableSet<Double> deweyTbl = new TreeSet<Double>();
    static DecimalFormat deweyFormater = new DecimalFormat("000.000");
    static boolean isInit = false;

    public CallnumberUtil() {
        this.loadLccLookupTbl();
        this.loadDeweyLookupTbl();
    }

    public String getLccGrp(String string, double d) {
        String string2 = "";
        List<LCC> list = LCCTbl.get(string);
        if (list != null) {
            for (LCC lCC : list) {
                if (d >= lCC.getRangeB() && d <= lCC.getRangeE()) {
                    string2 = lCC.getLccCode();
                    continue;
                }
                if (!(d < lCC.getRangeE())) continue;
                break;
            }
        }
        return string2;
    }

    public String getLccGrp(String string) {
        LccNum lccNum = this.parseLcc(string);
        return this.getLccGrp(lccNum.getSbjCode(), lccNum.getNumber());
    }

    public LccNum parseLcc(String string) {
        LccNum lccNum = new LccNum();
        Pattern pattern = Pattern.compile("^([a-zA-Z]* ){0,1}([a-zA-Z]{1,3})(( *[0-9]{1,5}(\\.[\\d]+){0,1})*(.*))");
        Pattern pattern2 = Pattern.compile("^([0-9]+\\.?[0-9]+)*+([\\D].*)*");
        Pattern pattern3 = Pattern.compile("^\\.{0,1}([a-zA-Z][\\d]+)(.*)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find() && matcher.group(2) != null) {
            lccNum = new LccNum();
            if (matcher.group(1) != null) {
                lccNum.setPrefix(matcher.group(1).trim());
            }
            lccNum.setSbjCode(matcher.group(2).toUpperCase());
            String string2 = matcher.group(3) != null ? matcher.group(3).trim() : "";
            matcher = pattern2.matcher(string2);
            if (matcher.find()) {
                if (matcher.group(1) != null && matcher.group(1).length() >= 1) {
                    lccNum.setNumber(Float.parseFloat(matcher.group(1)));
                }
                if (matcher.group(2) != null) {
                    string2 = matcher.group(2);
                    string2 = matcher.group(2).trim();
                    matcher = pattern3.matcher(string2);
                    String string3 = "";
                    while (matcher.find()) {
                        if (matcher.group(1) != null && matcher.group(1).length() > 1) {
                            string3 = string3 + " " + matcher.group(1);
                        }
                        string2 = matcher.group(2) != null ? matcher.group(2).trim() : "";
                        matcher = pattern3.matcher(string2);
                    }
                    lccNum.setCutter(string3.trim());
                } else {
                    string2 = "";
                }
                lccNum.setRemainder(string2);
            }
        }
        return lccNum;
    }

    public String getDewey(String string) {
        String string2 = "";
        Pattern pattern = Pattern.compile("(\\D*)([1-9][0-9]*)(\\.[0-9]*)?(.*)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find() && matcher.group(2) != null && matcher.group(2).length() < 4 && Integer.parseInt(matcher.group(2)) < 1000) {
            int n = Integer.parseInt(matcher.group(2));
            string2 = String.format("%03d", n);
            if (matcher.group(3) != null) {
                string2 = string2 + matcher.group(3);
            }
        } else {
            pattern = Pattern.compile("(?i)(^F$|^F |FIC$|^FIC |^E$|^E |^EASY$|^EASY)");
            matcher = pattern.matcher(string);
            if (matcher.find() && matcher.group(1) != null) {
                string2 = matcher.group(1).trim().toUpperCase();
            }
        }
        return string2.trim();
    }

    public String getDeweyClass(String string) {
        String string2 = "";
        if ((string = string.trim()).matches("([1-9][0-9]*)(\\.[0-9]*)?")) {
            string2 = deweyFormater.format(deweyTbl.floor(Double.parseDouble(string)));
        } else if (string.matches("FIC|F|EASY|E")) {
            string2 = string;
        }
        return string2;
    }

    private void loadLccLookupTbl() {
        try {
            String string;
            InputStream inputStream = CallnumberUtil.class.getResourceAsStream("lcc.csv");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split(",");
                if (stringArray.length != 4) continue;
                if (!LCCTbl.containsKey(stringArray[0])) {
                    LCCTbl.put(stringArray[0], new ArrayList());
                }
                LCCTbl.get(stringArray[0]).add(new LCC(stringArray[1], Double.parseDouble(stringArray[2]), Double.parseDouble(stringArray[3])));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void loadDeweyLookupTbl() {
        try {
            String string;
            InputStream inputStream = CallnumberUtil.class.getResourceAsStream("dewey.csv");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.trim().isEmpty()) continue;
                deweyTbl.add(Double.parseDouble(string));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    class LCC {
        private String code;
        private double rangeB;
        private double rangeE;

        public LCC(String string, double d, double d2) {
            this.code = string;
            this.rangeB = d;
            this.rangeE = d2;
        }

        public String getLccCode() {
            return this.code;
        }

        public void setLccCode(String string) {
            this.code = string;
        }

        public double getRangeB() {
            return this.rangeB;
        }

        public void setRangeB(double d) {
            this.rangeB = d;
        }

        public double getRangeE() {
            return this.rangeE;
        }

        public void setRangeE(double d) {
            this.rangeE = d;
        }
    }
}

