/*
 * Decompiled with CFR 0.152.
 */
package opals.marc;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opals.marc.ControlField;
import opals.marc.DataField;
import opals.marc.MarcRecord;
import opals.marc.Subfield;

public class MarcXmlReader {
    static final Pattern ldPattern = Pattern.compile("<leader>(.*?)</leader>");
    static final Pattern cfPattern = Pattern.compile("<controlfield tag=\"(00[1-9])\">(.*?)</controlfield>");
    static final Pattern sfPattern = Pattern.compile("<subfield code=\"([\\w])\">(.*?)</subfield>");
    static final Pattern dfPattern = Pattern.compile("<datafield tag=\"([\\d][\\d][\\d])\" ind1=\"([\\w ])\" ind2=\"([\\w ])\">(.*?)</datafield>");

    public MarcRecord parse(String string) throws IOException {
        BufferedReader bufferedReader = this.getReader(string);
        if (bufferedReader == null) {
            return null;
        }
        StringBuilder stringBuilder = this.getXmlStr(bufferedReader);
        bufferedReader.close();
        MarcRecord marcRecord = this.parseXml(stringBuilder);
        return marcRecord;
    }

    private BufferedReader getReader(String string) {
        BufferedReader bufferedReader = null;
        try {
            FileReader fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(MarcXmlReader.class.getName()).log(Level.SEVERE, null, fileNotFoundException);
        }
        return bufferedReader;
    }

    private StringBuilder getXmlStr(BufferedReader bufferedReader) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        try {
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(MarcXmlReader.class.getName()).log(Level.SEVERE, null, iOException);
        }
        return stringBuilder;
    }

    private MarcRecord parseXml(StringBuilder stringBuilder) {
        MarcRecord marcRecord = new MarcRecord();
        Matcher matcher = dfPattern.matcher(stringBuilder);
        Matcher matcher2 = ldPattern.matcher(stringBuilder);
        if (matcher2.find()) {
            marcRecord.setLeader(matcher2.group(1));
        }
        marcRecord.addControlFields(this.parseControlField(stringBuilder));
        marcRecord.addDataFields(this.ParseDataField(stringBuilder));
        return marcRecord;
    }

    private List<ControlField> parseControlField(StringBuilder stringBuilder) {
        ArrayList<ControlField> arrayList = new ArrayList<ControlField>();
        Matcher matcher = cfPattern.matcher(stringBuilder);
        while (matcher.find()) {
            arrayList.add(new ControlField(matcher.group(1), matcher.group(2)));
        }
        return arrayList;
    }

    private List<DataField> ParseDataField(StringBuilder stringBuilder) {
        ArrayList<DataField> arrayList = new ArrayList<DataField>();
        Matcher matcher = dfPattern.matcher(stringBuilder);
        while (matcher.find()) {
            String string = matcher.group(1);
            char c = matcher.group(2).charAt(0);
            char c2 = matcher.group(3).charAt(0);
            String string2 = matcher.group(4);
            arrayList.add(new DataField(string, c, c2, this.parserSubField(string2)));
        }
        return arrayList;
    }

    private List<Subfield> parserSubField(String string) {
        ArrayList<Subfield> arrayList = new ArrayList<Subfield>();
        Matcher matcher = sfPattern.matcher(string);
        while (matcher.find()) {
            arrayList.add(new Subfield(matcher.group(1).charAt(0), matcher.group(2)));
        }
        return arrayList;
    }
}

