app.controller("oplMainCtrl",['$scope','$http',function($scope,$http){
    $scope.recList=[];
    $scope.number=1;
    $scope.rsPageSize=40;
    $scope.hits=-1;
    $scope.lastRsPage=0;
    $scope.rs=[];
    $scope.viewRsOpt="1";
    $scope.mediaIcons={};
    var iconUrl = chrome.extension.getURL("images/loadingAnimation.gif");
    $("#waiting-animation-img").attr("src",iconUrl);
    chrome.runtime.sendMessage({type: 'getMediaIcons'}, function(mediaIcons) {
      $scope.mediaIcons=mediaIcons;
    });

    $scope.srchUrl="https://bookcover.opalsinfo.net/bin/ws/oplSearch?pSize=" + $scope.rsPageSize + "&term=";
    chrome.runtime.sendMessage({type: 'getLibInfo'}, function(libInfo) {
      if(libInfo && libInfo.libUrl!=''){
          $scope.libInfo=libInfo;
          $scope.libInfo.libName=$scope.libInfo.libName.replace(/<br>/g," -- ");
          $scope.viewRsOpt=($scope.libInfo.viewRsOpt=="0")?"0":"1";
          $scope.viewRsOpt=="0"?$scope.hideSrchRs():$scope.showSrchRs();
          var url = new URL(window.location.href);
          $scope.query=url.searchParams.get("q");
          $scope.doQuery($scope.genCont);
        }});
        //------------------------------------------------------------------------------
    $scope.doQuery=function(cbfn){
          if($scope.rs.length<$scope.hits ||($scope.hits==-1) ){
             $scope.lastRsPage++;
             var url="";
             if($scope.libInfo.libUrl.indexOf("https://")==0){
                url=$scope.libInfo.libUrl+"/bin/ajax/search/searchJson?pSize=40"
                        +"&pNum=" + $scope.lastRsPage
                        +"&sf0=1016&kw0=" +$scope.query ;
             }
             else{// use https proxy
               url=$scope.srchUrl + $scope.query + "&libUrl=" + $scope.libInfo.libUrl
                        +"&pNum=" + $scope.lastRsPage  ;
             }
             $http.get(url)
              .success(function(data) {
                    $scope.hits=data.numberOfHits;
                    $scope.rs =$scope.rs.concat(data.recordList);
                    if(cbfn){
                      cbfn();
                    }
                    $scope.hits>0?$("#opl-search").show():$("#opl-search").hide();
               });
          }
    }
    //------------------------------------------------------------------------------
    $scope.genCont=function(){
        $("#waiting-animation-img").hide();
        var p=$scope.number;
        var w=$(window).width()-100;
        $scope.shelfSize=Math.floor(w/122);
        var numOfPage=Math.ceil($scope.hits/$scope.shelfSize);
        (p==1)?$(".prev").hide():$(".prev").show();
        (p==numOfPage)?$(".next").hide():$(".next").show();
        $scope.recList =[];
        var s=$scope.shelfSize*(p-1);
        var d=s+$scope.shelfSize;
        if($scope.rs.length -d <$scope.shelfSize && $scope.rs.length<$scope.hits){
          $(".next").hide();
          $("#waiting-animation-img").show();
          $scope.doQuery($scope.genCont);
        }
        else{
          if(d>$scope.rs.length)
            d=$scope.rs.length;
          $scope.recList=$scope.rs.slice(s,d);

      }
    }

    //------------------------------------------------------------------------------
    $scope.next=function(){
      var numOfPage=Math.ceil($scope.hits/$scope.shelfSize);
      if($scope.number<numOfPage){
        $scope.number +=1
        $scope.genCont();
        $("#itemList").css("left","98%");
        $("#itemList").animate({"left":"-=98%"},"slow");
      }

    }
    //------------------------------------------------------------------------------
    $scope.prev=function(){
      if($scope.number>1){
        $scope.number -=1;
        $scope.genCont();
        $("#itemList").css("left","-98%");
        $("#itemList").animate({"left":"+=98%"},"slow");
      }

    }
    //------------------------------------------------------------------------------
    $scope.viewRecDetail=function(rid){
       var url = $scope.libInfo.libUrl+"/bin/pf/recDetailPage?sortAttr=9002&sortOrder=1&rid="+ rid;
       window.open(url,'_blank');
    }
    //------------------------------------------------------------------------------
    $scope.decodeHTML=function(str){
       if(str && str !="")
          return str.replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&amp;/g,"&");
       };

    //------------------------------------------------------------------------------
    $scope.getTooltip=function(rec){
      if(!rec) return "";
      var fmtIcon="book.png";
      if(rec.format){
        fmtIcon=$scope.mediaIcons[rec.format[0].item];
      }
      var location =(rec.itemList && rec.itemList[0] && rec.itemList[0].location)? rec.itemList[0].location:"";
      return "<div style='text-align:left'><img src='" +fmtIcon +"' style='vertical-align:bottom;padding-right:5px'>"
           +"<b>"+ $scope.decodeHTML(rec.title) +"</b>"
           + "<div style='margin-left:20px;color:#532E0F'><i>" +$scope.decodeHTML(rec.author)  + "</i></div>"
           + "<div style='margin-left:20px;color:#9900cc' ng-show=\"location !=''\">" + location  + "</div>"
           + "<div style='margin-left:20px;color:#FF1717'><b>" +$scope.decodeHTML(rec.callNum1St) +"</b></div>"
           + "<br><div style='margin-top:10px;margin-left:20px;font-size:8pt'>AVAILABLE:"
           + rec.numAvailable +"&nbsp;&nbsp;&nbsp; </div></div>";
    }
    //------------------------------------------------------------------------------
    $scope.toogleOplSrchRs=function(){
      $scope.viewRsOpt=($scope.viewRsOpt=="0")?"1":"0";
      chrome.runtime.sendMessage({type: 'setViewRsOpt',viewRsOpt:$scope.viewRsOpt});
      $scope.viewRsOpt=="0"?$scope.hideSrchRs():$scope.showSrchRs();
    }
    //------------------------------------------------------------------------------
    $scope.showSrchRs=function(){
        $("#toggle-show-rs").show();
        $("#toggle-hide-rs").hide();
        $("#oplSearchRsMain").show();
    }
    //------------------------------------------------------------------------------
    $scope.hideSrchRs=function(){
        $("#toggle-show-rs").hide();
        $("#toggle-hide-rs").show();
        $("#oplSearchRsMain").hide();
    }
    //------------------------------------------------------------------------------
  }]);
  //-----------------------------------------------------------------------------------
  //
  app.directive('oplTooltip',['$parse', function ($parse){
       return {
             restrict:'A',
             scope:{oplTooltip:'@'},
             link:function(scope,element,Attrs){
                $(element).tooltip({
                  position: {
                          my: "center bottom",
                          at: "center top-10",
                          collision: "flip",
                          using: function( position, feedback ) {
                              $( this ).addClass( feedback.vertical )
                                  .css( position );
                          }
                      },
                  content:scope.oplTooltip
                });
           }
         }
  }]);
  //======================================================================
