var libInfo={};
chrome.storage.sync.get(["libName","libUrl","viewRsOpt"], function(items) {libInfo= items;});
var mediaTypes=[
    "artifact",
    "blu_ray",
    "book",
    "bookManuscript",
    "bookOnTape",
    "bookOnTape_bk",
    "CDMusic",
    "compactDisc",
    "DVD",
    "ebook",
    "electronicMedia",
    "internet",
    "journal",
    "libraryKit",
    "manuscriptMusic",
    "map",
    "mapManuscript",
    "mixedMaterial",
    "movie",
    "musicCassette",
    "pdf",
    "photoPoster",
    "serial",
    "sheetMusic",
    "undef",
    "videocassette"
]
var mediaIcons={};
mediaTypes.forEach(function(t){
  mediaIcons[t]=chrome.extension.getURL("images/medium/"+t+".png");
});

//------------------------------------------------------------------------------
chrome.runtime.onMessage.addListener(function(message, sender, handler){
  if(message){
      switch(message.type){
        case 'getLibInfo':
          handler(libInfo);
          break;
        case 'updateLibInfo':
          libInfo=message.libInfo;
          break;
        case 'getViewRsOpt':
          chrome.storage.sync.get(["viewRsOpt"], function(v){handler(v)});
          break;
        case 'setViewRsOpt':
          var viewRsOpt=message.viewRsOpt;
          chrome.storage.sync.set({"viewRsOpt":viewRsOpt});
          libInfo.viewRsOpt=viewRsOpt;
          break;
        case "getMediaIcons"  :
          handler(mediaIcons);
          break;
      }
  }

 });
