package opalsofflinecirc;

import java.io.*;
import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import java.util.*;
import java.text.*;
import java.net.*;
import javax.net.ssl.HttpsURLConnection;
import java.awt.*;
import java.awt.event.*;

public final class OpalsCirc extends JPanel
        implements ActionListener {

    JFrame frame;
    LoginDialog loginDialog;
    JTabbedPane tabbedPane;

    final static String LOANPANEL = "    Loan    ";
    final static String SETTINGPANEL = "    Setting   ";
    final static String UPLOADTRANS = "    Upload Transactions  ";
    final static String REPORTSPANEL = "    Reports  ";

    final int SEND_TRANS_SUCCESS = 1;
    final int SEND_TRANS_ERROR = 0;
    final int LOGIN_FAIL = 0;
    final int LOGIN_SUCCESS = 1;
    final int ERROR_URL = 2;
    final int ERROR_IO = 3;
    final int LOGIN_CANCEL = 4;

    protected static final String user_BC_cmd = "userBarCodeCmd";
    protected static final String user_ok_cmd = "userOKButton";
    protected static final String loan_BC_cmd = "loanBarCodeCmd";
    protected static final String loan_ok_cmd = "loanOKButton";
    protected static final String viewReport_cmd = "viewReportButton";

    protected static final String switch_user_cmd = "switchUserCmd";
    protected static final String upload_cmd = "uploadCmd";
    protected static final String userLabelTxt = "User Barcode ";
    protected static final String itemLabelTxt = "Item Barcode ";
    protected static final String transDateLabelTxt = "Transation Date ";
    protected static final String uploadLabelTxt = " Transactions Table ";

    protected static final String saveSetting_cmd = "saveSettingCmd";

    private JProgressBar progressBar;

    protected JLabel msgLabel;

    protected JLabel userLabel;
    protected JLabel loanItemBCLabel;
    protected JLabel urlLabel;
    protected JLabel uploadDateLabel;
    protected JButton user_ok;
    protected JButton loan_ok;
    protected JButton uploadButton;
    protected JTextField user_BC;
    protected JTextField item_loan_BC;
    protected JTextField urlBox;
    protected JTextField uploadDateBox;
    protected String userBC, itemBC;
    protected JTable loanTable, transactionTable;
    protected Vector loanRows;
    protected Vector loanColumns;
    protected Vector transRows;
    protected Vector transColumns;
    protected String uploadURL;

    protected String m_uid = "";
    protected String m_pwd = "";
    protected String m_sessionId = "";
    protected Boolean authenticated = false;

    protected JTextArea reportTxt;

    public OpalsCirc(JFrame frame) {
        super(new BorderLayout());
        this.frame = frame;
        loginDialog = new LoginDialog(frame);
        loginDialog.pack();

        //Create the components.
        JPanel loanPanel = CreateLoanTab();
        JPanel uploadPanel = create_UploadTab();
        JPanel settingPanel = create_SettingTab();
        JPanel reportPanel = create_ReportTab();
        JPanel helpPanel = create_HelpTab();

        //Lay them out.
        Border padding = BorderFactory.createEmptyBorder(20, 20, 5, 20);
        loanPanel.setBorder(padding);
        uploadPanel.setBorder(padding);
        reportPanel.setBorder(padding);

        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("   Loan  ", null,
                loanPanel,
                "");
        tabbedPane.addTab("Upload Transactions", null,
                uploadPanel,
                "");
        tabbedPane.addTab("Report", null,
                reportPanel,
                "");
        tabbedPane.addTab("Setting", null,
                settingPanel,
                "");
        tabbedPane.addTab("Help", null,
                helpPanel,
                "");

        add(tabbedPane, BorderLayout.CENTER);

        loadSetting();
        loadTransaction();

    }

////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
    /**
     * Creates the panel shown by the first tab.
     */
    private JPanel CreateLoanTab() {
        JPanel loanCard = new JPanel() {
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width += 700;
                size.height += 400;
                return size;
            }
        };
        loanCard.setLayout(null);
        user_ok = new JButton("OK");
        user_ok.setActionCommand(user_ok_cmd);
        user_ok.addActionListener(this);

        loan_ok = new JButton("OK");
        loan_ok.setActionCommand(loan_ok_cmd);
        loan_ok.addActionListener(this);

        user_BC = new JTextField(10);
        user_BC.setActionCommand(user_BC_cmd);
        user_BC.addActionListener(this);

        item_loan_BC = new JTextField(10);
        item_loan_BC.setActionCommand(loan_BC_cmd);
        item_loan_BC.addActionListener(this);

        userLabel = new JLabel(userLabelTxt);
        userLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));

        loanItemBCLabel = new JLabel(itemLabelTxt);
        loanItemBCLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));

        loanTable = create_LoanTable();
        JScrollPane scrollPaneL = new JScrollPane(loanTable);

        loanCard.add(user_BC);
        loanCard.add(user_ok);
        loanCard.add(item_loan_BC);
        loanCard.add(loan_ok);

        loanCard.add(userLabel);
        loanCard.add(loanItemBCLabel);
        loanCard.add(scrollPaneL);

        Insets insets = loanCard.getInsets();
        Dimension size = user_BC.getPreferredSize();
        user_BC.setBounds(145 + insets.left, 5 + insets.top, 120, size.height);
        item_loan_BC.setBounds(145 + insets.left, 30 + insets.top, 120, size.height);
        user_ok.setBounds(270 + insets.left, 5 + insets.top, 60, size.height);
        userLabel.setBounds(60 + insets.left, 3 + insets.top, 150, size.height);
        loanItemBCLabel.setBounds(64 + insets.left, 28 + insets.top, size.width, size.height);
        user_BC.requestFocus(true);

        loan_ok.setBounds(270 + insets.left, 30 + insets.top, 60, size.height);
        scrollPaneL.setBounds(40 + insets.left, 85 + insets.top, 350, 200);
        loanItemBCLabel.setEnabled(false);
        item_loan_BC.setEnabled(false);
        loan_ok.setEnabled(false);

        return loanCard;

    }
///////////////////////////////////////////////////////////////////////

    protected JPanel create_UploadTab() {

        JPanel returnCard = new JPanel() {
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width += 500;
                size.height += 300;
                return size;
            }
        };

        returnCard.setLayout(null);

        transactionTable = create_TransTable();
        JScrollPane scrollPaneL = new JScrollPane(transactionTable);
        uploadButton = new JButton("UpLoad");
        uploadButton.setEnabled(false);
        uploadButton.setActionCommand(upload_cmd);
        uploadButton.addActionListener(this);

        progressBar = new JProgressBar();
        progressBar.setStringPainted(true);

        JLabel transLabel = new JLabel(uploadLabelTxt);

        returnCard.add(transLabel);
        returnCard.add(scrollPaneL);
        returnCard.add(uploadButton);
        returnCard.add(progressBar);

        Insets insets = returnCard.getInsets();
        transLabel.setBounds(12 + insets.left, 20 + insets.top, 250, 20);
        scrollPaneL.setBounds(10 + insets.left, 40 + insets.top, 550, 270);
        uploadButton.setBounds(438 + insets.left, 16 + insets.top, 120, 20);
        progressBar.setBounds(12 + insets.left, 320 + insets.top, 550, 25);
        return returnCard;
    }
///////////////////////////////////////////////////////////////////////

    protected JTable create_TransTable() {

        transRows = new Vector();
        transColumns = new Vector();

        transColumns.addElement("Trans #");
        transColumns.addElement("Item Barcode");
        transColumns.addElement("User Barcode");
        transColumns.addElement("Transaction Date");
        DefaultTableModel tabModel = new DefaultTableModel();
        tabModel.setDataVector(transRows, transColumns);
        JTable table = new JTable(tabModel);
        table.setRowSelectionAllowed(false);

        return table;

    }
///////////////////////////////////////////////////////////////////////

    protected JPanel create_HelpTab() {
        JPanel helpCard = new JPanel(new GridLayout());
        //helpCard.setLayout(null);
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        java.net.URL helpURL = OpalsCirc.class.getResource(
                "help/help.htm");
        if (helpURL != null) {
            try {
                editorPane.setPage(helpURL);
            } catch (IOException e) {
                System.err.println("Attempted to read a bad URL: " + helpURL);
            }
        } else {
            System.err.println("Couldn't find file: help.htm");
        }

        JScrollPane scrollPaneHelp = new JScrollPane(editorPane);
        //scrollPaneHelp.setVerticalScrollBarPolicy(
        //                JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        scrollPaneHelp.setPreferredSize(new Dimension(650, 300));
        //scrollPaneHelp.setMinimumSize(new Dimension(10, 10));
        helpCard.add(scrollPaneHelp);

        Insets insets = helpCard.getInsets();

        //scrollPaneHelp.setBounds(10 + insets.left, 10 + insets.top, 650, 400);
        return helpCard;

    }
///////////////////////////////////////////////////////////////////////

    protected JPanel create_SettingTab() {

        JPanel settingCard = new JPanel() {
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width += 500;
                size.height += 300;
                return size;
            }
        };

        settingCard.setLayout(null);

        urlLabel = new JLabel("Server Address");

        urlBox = new JTextField(90);

        JButton saveButton = new JButton("Save");

        saveButton.setActionCommand("saveSettingCmd");
        saveButton.addActionListener(this);

        settingCard.add(urlLabel);
        settingCard.add(urlBox);
        settingCard.add(saveButton);

        Insets insets = settingCard.getInsets();
        Dimension size = user_BC.getPreferredSize();

        urlLabel.setBounds(20 + insets.left, 50 + insets.top, 120, 20);
        urlBox.setBounds(115 + insets.left, 50 + insets.top, 340, 20);
        saveButton.setBounds(455 + insets.left, 50 + insets.top, 70, 20);

        return settingCard;

    }
///////////////////////////////////////////////////////////////////////

    protected JPanel create_ReportTab() {

        JPanel reportCard = new JPanel() {
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width += 500;
                size.height += 300;
                return size;
            }
        };

        reportCard.setLayout(null);

        uploadDateLabel = new JLabel("Transactions Date");

        uploadDateBox = new JTextField(10);
        uploadDateBox.setActionCommand("viewReportButton");
        uploadDateBox.addActionListener(this);

        JLabel dateFormat = new JLabel("(mm/dd/yyyy)");
        JButton viewReportButton = new JButton("View");

        viewReportButton.setActionCommand("viewReportButton");
        viewReportButton.addActionListener(this);

        Font font = new Font("Monospaced", Font.PLAIN, 12);
        reportTxt = new JTextArea(80, 20);
        reportTxt.setFont(font);
        reportTxt.setEditable(false);

        JScrollPane scrollPaneReport = new JScrollPane(reportTxt);

        reportCard.add(uploadDateLabel);
        reportCard.add(dateFormat);
        reportCard.add(uploadDateBox);
        reportCard.add(viewReportButton);
        reportCard.add(scrollPaneReport);

        Insets insets = reportCard.getInsets();
        Dimension size = user_BC.getPreferredSize();

        uploadDateLabel.setBounds(160 + insets.left, 20 + insets.top, 120, 20);
        uploadDateBox.setBounds(265 + insets.left, 20 + insets.top, 100, 20);
        dateFormat.setBounds(275 + insets.left, 35 + insets.top, 100, 20);
        viewReportButton.setBounds(375 + insets.left, 20 + insets.top, 70, 20);
        scrollPaneReport.setBounds(20 + insets.left, 70 + insets.top, 650, 300);

        return reportCard;

    }

    ////////////////////////////////////////////////////////////////////////
    protected String getUrl() {
        String retUrl = uploadURL;
        retUrl = retUrl.trim();

        if (!retUrl.startsWith("http://") && !retUrl.startsWith("https://")) {
            retUrl = "http://" + retUrl;
        }
        if (retUrl.lastIndexOf("/") != retUrl.length() - 1) {
            retUrl = retUrl + "/";
        }
        retUrl = retUrl + "bin/circ/uploadtrans";
        return retUrl;

    }
////////////////////////////////////////////////////////////////////////

    protected void createReport(Date transDate) {
        DateFormat formatter;
        formatter = new SimpleDateFormat("yyyy-MM-dd");
        String transDateStr = formatter.format(transDate);
        String reportStr = "";
        String urlstr = getUrl();
        String param = "op=report"
                + "&transDate=" + transDateStr;
        try {
            URL obj = new URL(urlstr);
            HttpURLConnection con = urlstr.startsWith("https://") ? (HttpsURLConnection) obj.openConnection()
                    : (HttpURLConnection) obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", "OPALS OFFLINE CIRC");
            con.setDoOutput(true);
            OutputStream os = con.getOutputStream();
            os.write(param.getBytes());
            os.flush();
            os.close();

            int responseCode = ((HttpURLConnection) con).getResponseCode();
            System.out.println("POST Response Code :: " + responseCode);

            if (responseCode == HttpURLConnection.HTTP_OK) { //success
                BufferedReader in = new BufferedReader(new InputStreamReader(
                        con.getInputStream()));
                String inputLine;                
                while ((inputLine = in.readLine()) != null) {
                    reportStr += inputLine + "\n";
                }
                reportTxt.setText(reportStr);
                in.close();

            } else {
                System.out.println("Cc=onnection ERROR");
            }
        } catch (MalformedURLException me) {
            JOptionPane.showMessageDialog(tabbedPane, "Incorrect server addresss or server is unreachable.");
            System.err.println(urlstr);
            System.err.println("MalformedURLException: " + me);

        } catch (IOException ioe) {
            JOptionPane.showMessageDialog(tabbedPane, "Incorrect server addresss or server is unreachable.");
            System.err.println("IOException: " + ioe.getMessage());

        }

    }

///////////////////////////////////////////////////////////////////////
    public void actionPerformed(ActionEvent e) {

        if (user_BC_cmd.equals(e.getActionCommand())
                || user_ok_cmd.equals(e.getActionCommand())) {

            if ((user_BC.getText()).length() == 0) {
                JOptionPane.showMessageDialog(tabbedPane, "Please enter student Barcode.");
                user_BC.requestFocus();
            } else {
                String source = user_BC.getText();

                user_BC.setEnabled(false);
                userLabel.setEnabled(false);
                user_ok.setSize(120, 20);
                user_ok.setText("Switch User");
                user_ok.setActionCommand(switch_user_cmd);
                user_ok.requestFocus(false);

                loanItemBCLabel.setEnabled(true);
                item_loan_BC.setEnabled(true);
                loan_ok.setEnabled(true);
                item_loan_BC.setText("");
                item_loan_BC.requestFocus(true);
            }

        } else if (loan_BC_cmd.equals(e.getActionCommand())
                || loan_ok_cmd.equals(e.getActionCommand())) {
            if ((user_BC.getText()).length() == 0) {
                JOptionPane.showMessageDialog(tabbedPane, "Please enter student Barcode.");
                user_BC.requestFocus();
            } else if ((item_loan_BC.getText()).length() == 0) {
                JOptionPane.showMessageDialog(tabbedPane, "Please enter item's Barcode.");
                item_loan_BC.requestFocus();
            } else {
                Date transDate = new Date();
                addLoan(user_BC.getText(), item_loan_BC.getText(), transDate);
                item_loan_BC.setText("");
            }

        } else if (viewReport_cmd.equals(e.getActionCommand())) {

            String dateStr = uploadDateBox.getText();
            if (isValidDate(dateStr)) {
                Date transDate = new Date(dateStr);
                int tryCount = 0;
                int login = login();
                while (login != LOGIN_SUCCESS && login != LOGIN_CANCEL
                        && login != ERROR_IO && login != ERROR_URL && tryCount < 5) {
                    tryCount++;
                    login = login();
                }
                if (login == LOGIN_SUCCESS) {
                    createReport(transDate);
                } else if (tryCount == 5) {
                    JOptionPane.showMessageDialog(tabbedPane, "The username or password supplied is incorrect");
                }
            } else {
                JOptionPane.showMessageDialog(tabbedPane, "Invalid date.");
            }
        } else if (switch_user_cmd.equals(e.getActionCommand())) {

            loanItemBCLabel.setEnabled(false);
            item_loan_BC.setEnabled(false);
            loan_ok.setEnabled(false);
            user_BC.setEnabled(true);
            userLabel.setEnabled(true);
            user_ok.setSize(60, 20);
            user_ok.setText("OK");
            user_ok.setActionCommand(user_ok_cmd);
            user_BC.setText("");
            user_BC.requestFocus();

        } else if (upload_cmd.equals(e.getActionCommand())) {
            int tryCount = 0;
            int login = login();
            while (login != LOGIN_SUCCESS && login != LOGIN_CANCEL
                    && login != ERROR_IO && login != ERROR_URL && tryCount < 5) {
                tryCount++;
                login = login();
            }
            if (login == LOGIN_SUCCESS) {
                uploadTransaction();
            } else if (tryCount == 5) {
                JOptionPane.showMessageDialog(tabbedPane, "The username or password supplied is incorrect");
            }

        } else if (saveSetting_cmd.equals(e.getActionCommand())) {
            m_sessionId = "";
            saveSetting();
        }

    }

    protected int login() {
        int retval = 0;
        loginDialog.setLocationRelativeTo(frame);
        String urlstr = getUrl();
        if (m_sessionId.equals("")) {
            loginDialog.setVisible(true);
            m_uid = loginDialog.getUID();
            m_pwd = loginDialog.getPWD();
        }
        if (loginDialog.isCancel()) {
            return LOGIN_CANCEL;
        }
        Boolean SSL = urlstr.startsWith("https://");
        String param = "op=auth&uid=" + m_uid + "&pwd=" + m_pwd;
        try {
            URL url;
            HttpURLConnection con;
            url = new URL(urlstr);
            con = SSL ? (HttpsURLConnection) url.openConnection() : (HttpURLConnection) url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", "OPALS OFFLINE CIRC");
            con.setDoOutput(true);
            OutputStream os = con.getOutputStream();
            os.write(param.getBytes());
            os.flush();
            os.close();
            int responseCode = ((HttpURLConnection) con).getResponseCode();
            if (responseCode == HttpURLConnection.HTTP_OK) { //success
                BufferedReader in = new BufferedReader(new InputStreamReader(
                        con.getInputStream()));
                String inputLine;
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                m_sessionId = response.toString();
                retval = m_sessionId.isEmpty() ? LOGIN_FAIL : LOGIN_SUCCESS;
            } else {
                retval = LOGIN_FAIL;
                System.out.println("connection error");
            }

        } catch (MalformedURLException me) {
            JOptionPane.showMessageDialog(tabbedPane, "Incorrect server addresss or server is unreachable.");
            System.err.println(urlstr);
            System.err.println("MalformedURLException: " + me);
            m_sessionId = "";
            return ERROR_URL;
        } catch (IOException ioe) {
            JOptionPane.showMessageDialog(tabbedPane, "Incorrect server addresss or server is unreachable.");
            System.err.println("IOException: " + ioe.getMessage());
            return ERROR_IO;
        }

        return retval;

    }

///////////////////////////////////////////////////////////////////////
    protected JTable create_LoanTable() {
        loanRows = new Vector();
        loanColumns = new Vector();

        loanColumns.addElement(" Loan # ");
        loanColumns.addElement("User Barcode");
        loanColumns.addElement("Item Barcode");
        DefaultTableModel tabModel = new DefaultTableModel();
        tabModel.setDataVector(loanRows, loanColumns);
        JTable table = new JTable(tabModel);
        table.setRowSelectionAllowed(false);
        table.setPreferredScrollableViewportSize(new Dimension(350, 200));
        return table;

    }

    protected int sendPost_http(String url, String param) {
        int retval = 1;
        Boolean SSL = url.startsWith("https://");
        try {
            URL obj = new URL(url);
            HttpURLConnection con = SSL ? (HttpsURLConnection) obj.openConnection()
                    : (HttpURLConnection) obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", "OPALS OFFLINE CIRC");
            con.setDoOutput(true);
            OutputStream os = con.getOutputStream();
            os.write(param.getBytes());
            os.flush();
            os.close();

            int responseCode = ((HttpURLConnection) con).getResponseCode();
            System.out.println("POST Response Code :: " + responseCode);

            if (responseCode == HttpURLConnection.HTTP_OK) { //success
                BufferedReader in = new BufferedReader(new InputStreamReader(
                        con.getInputStream()));
                String inputLine;
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                m_sessionId = response.toString();
            } else {
                System.out.println("POST request not worked");
            }
        } catch (MalformedURLException me) {
            JOptionPane.showMessageDialog(tabbedPane, "Incorrect server addresss or server is unreachable.");
            System.err.println(url);
            System.err.println("MalformedURLException: " + me);
            m_sessionId = "";
            return ERROR_URL;
        } catch (IOException ioe) {
            JOptionPane.showMessageDialog(tabbedPane, "Incorrect server addresss or server is unreachable.");
            System.err.println("IOException: " + ioe.getMessage());
            return ERROR_IO;
        }
        return retval;
    }

///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
    protected void addLoan(String userBC, String itemBC, Date transDate) {

        Vector r = new Vector();
        r.addElement(loanRows.size() + 1);
        r.addElement(userBC);
        r.addElement(itemBC);
        DateFormat df = DateFormat.getDateInstance(DateFormat.SHORT);
        loanRows.addElement(r);
        loanTable.addNotify();
        String transDateStr = df.format(transDate);
        addTrans2Tbl(itemBC, userBC, transDateStr);
        uploadButton.setEnabled(true);
        saveTransaction(itemBC, userBC, transDate);

    }

///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
    protected boolean isLoaned(String itemBC) {
        Iterator it = loanRows.iterator();
        for (int index = 0; index < loanRows.size(); index++) {
            Vector v = (Vector) loanRows.elementAt(index);
            if (v.contains(itemBC)) {
                return true;
            }
        }
        return false;

    }

///////////////////////////////////////////////////////////////////////
    protected void saveTransaction(String itemBC, String userBC, Date tDate) {
        try {
            PrintStream p;
            FileOutputStream fos = new FileOutputStream("transactions.csv", true);
            p = new PrintStream(fos);
            DateFormat df = DateFormat.getDateInstance(DateFormat.SHORT);

            String transDateStr = df.format(tDate);

            String TransRecStr = "\"" + itemBC + "\",\"" + userBC + "\","
                    + df.format(tDate);
            p.println(TransRecStr);
            p.close();

        } catch (Exception fileE) {
            JOptionPane.showMessageDialog(tabbedPane, "Could not save transaction !");
        }
    }

///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
    protected void loadTransaction() {
        try {
            File file = new File("transactions.csv");
            Scanner scanner = new Scanner(file);
            scanner.useDelimiter(System.getProperty("line.separator"));
            while (scanner.hasNext()) {
                parseRec(scanner.next());
            }
            scanner.close();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }

    }
///////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////
    protected void parseRec(String recStr) {
        //parser p= new parser();
        String[] rec;
        try {
            rec = recStr.split(",");
            if (rec.length == 3) {
                addTrans2Tbl(rec[0], rec[1], rec[2]);
            }
        } catch (Exception e) {
        }

    }
///////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////
    protected void addTrans2Tbl(String itemBC, String userBC, String transDate) {

        Vector r = new Vector();
        r.addElement(transRows.size() + 1);
        r.addElement(itemBC);
        r.addElement(userBC);
        r.addElement(transDate);
        transRows.addElement(r);
        transactionTable.addNotify();
        uploadButton.setEnabled(true);

    }
///////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////
    protected int sendTransaction(String itemBc, String userBc, String transDate) {
        int retval = SEND_TRANS_SUCCESS;
        try {
            URL url;
            HttpURLConnection con;
            String urlstr = getUrl();
            url = new URL(urlstr);
            con = urlstr.startsWith("https://") ? (HttpsURLConnection) url.openConnection()
                    : (HttpURLConnection) url.openConnection();
            String param = "op=loan&itemBc="
                    + itemBc + "&userBc=" + userBc
                    + "&transDate=" + transDate
                    + "&sid=" + m_sessionId;
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", "OPALS OFFLINE CIRC");
            con.setDoOutput(true);
            OutputStream os = con.getOutputStream();
            os.write(param.getBytes());
            os.flush();
            os.close();
            int responseCode = ((HttpURLConnection) con).getResponseCode();
            if (responseCode == HttpURLConnection.HTTP_OK) { //success
                BufferedReader in = new BufferedReader(new InputStreamReader(
                        con.getInputStream()));
                String inputLine;
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                String rs = response.toString();
                retval = !rs.isEmpty() ? SEND_TRANS_SUCCESS : SEND_TRANS_ERROR;
            } else {
                retval = SEND_TRANS_ERROR;
                System.out.println("connection error");
            }
        } catch (MalformedURLException me) {
            JOptionPane.showMessageDialog(tabbedPane, "There is error in the server address setting or the server is unreachable.");

            System.err.println("MalformedURLException: " + me);
            return ERROR_URL;
        } catch (IOException ioe) {
            System.err.println("IOException: " + ioe.getMessage());
            return ERROR_IO;
        }
        return retval;

    }

///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
    protected void uploadTransaction() {
        Date tmpDate;
        DateFormat formatter;

        if (uploadURL.equals("")) {
            uploadURL = urlBox.getText();
        }
        if (uploadURL.equals("")) {
            JOptionPane.showMessageDialog(tabbedPane, "Please set the upload server addresss in the setting tab.");
            return;
        }

        formatter = new SimpleDateFormat("yyyy-MM-dd");
        int i = 0;

        progressBar.setMaximum(transRows.size());
        progressBar.setMinimum(0);
        progressBar.setValue(0);
        progressBar.setStringPainted(true);
        int countDone = 0;
        setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        while (i < transRows.size()) {
            Vector trans = (Vector) transRows.get(i);
            String transDateStr = "";
            tmpDate = new Date((String) trans.elementAt(3));
            transDateStr = formatter.format(tmpDate);
            int rs = sendTransaction((String) trans.elementAt(1),
                    (String) trans.elementAt(2),
                    transDateStr
            );
            if (rs == SEND_TRANS_SUCCESS) {
                transRows.remove(i);
                progressBar.setValue(++countDone);
            } else {
                break;
            }

        }
        transactionTable.addNotify();
        if (transRows.size() == 0) {
            uploadButton.setEnabled(false);
        }

        clearTransfile();
        i = 0;
        for (i = 0; i < transRows.size(); i++) {
            Vector trans = (Vector) transRows.get(i);
            tmpDate = new Date((String) trans.elementAt(2));
            saveTransaction((String) trans.elementAt(0),
                    (String) trans.elementAt(1),
                    tmpDate);
        }

        setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));

    }

    protected void clearTransaction() {
        transRows.clear();
        loanRows.clear();
        clearTransfile();
    }

    protected void clearTransfile() {
        FileOutputStream out;
        PrintStream p;

        try {
            out = new FileOutputStream("transactions.csv");
            p = new PrintStream(out);
            p.println("");
            p.close();
        } catch (Exception e) {
            System.err.println("Error writing to file");
        }

    }

    protected void loadSetting() {
        uploadURL = "";
        try {
            File file = new File("opals.ini");
            Scanner scanner = new Scanner(file);
            scanner.useDelimiter(System.getProperty("line.separator"));
            while (scanner.hasNext()) {

                String tmpStr = scanner.next();
                int i = tmpStr.indexOf("=");
                if (i > 0) {
                    String field = tmpStr.substring(0, i);
                    if (field.equals("uploadURL")) {
                        uploadURL = tmpStr.substring(i + 1, tmpStr.length() - 1);
                    }
                }
            }
            scanner.close();

        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }

        urlBox.setText(uploadURL);

    }

    protected void saveSetting() {
        try {
            PrintStream p;
            FileOutputStream fos = new FileOutputStream("opals.ini", false);
            p = new PrintStream(fos);
            String str = urlBox.getText();
            uploadURL = str;
            str = str.trim();
            urlBox.setText(str);
            str = "uploadURL=" + str + "\n";
            p.println(str);

            p.close();

        } catch (Exception fileE) {
            JOptionPane.showMessageDialog(tabbedPane, "Could not save setting !");
        }
    }

    public Boolean isValidDate(String d) {
        DateFormat df = DateFormat.getDateInstance(DateFormat.SHORT);
        try {
            Date myDate = df.parse(d);
            return true;
        } catch (ParseException pe) {
            return false;
        }

    }

///////////////////////////////////////////////////////////////////////
    /**
     * Create the GUI and show it. For thread safety, this method should be
     * invoked from the event-dispatching thread.
     */
    private static void createAndShowGUI() {
        //Make sure we have nice window decorations.
        JFrame.setDefaultLookAndFeelDecorated(true);

        //Create and set up the window.
        JFrame frame = new JFrame("OPALS Offline Circulation");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        //Create and set up the content pane.
        OpalsCirc newContentPane = new OpalsCirc(frame);
        newContentPane.setOpaque(true); //content panes must be opaque
        frame.setContentPane(newContentPane);
        newContentPane.setSize(new Dimension(680, 300));

        //Display the window.
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                createAndShowGUI();
            }
        });
    }

}
