package opalsofflinecirc;
import javax.swing.JOptionPane;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.JPasswordField;
import java.beans.*; //property change stuff
import java.awt.*;
import java.util.*;
import java.awt.event.*;


class LoginDialog extends JDialog
                   implements ActionListener,
                              PropertyChangeListener {
    private  String uid,pwd;
    private JTextField userName;
    private JPasswordField password;

    private String magicWord;
    private JOptionPane optionPane;

    private String btnString1 = "Enter";
    private String btnString2 = "Cancel";
	private boolean isCancel   = false;

    public String getUID() {
		return uid;
    }
    public String getPWD() {
		return pwd;
    }
    public boolean isCancel() {
		boolean retval=isCancel;
		isCancel=false;
		return retval;
    }   
    public LoginDialog(Frame aFrame) {
        super(aFrame, true);

		uid="";
		pwd="";
		isCancel=false;

        setTitle("Login");

        userName = new JTextField(10);
		password = new JPasswordField(); 

        String msgString = "Please enter your username and password?";
        Object[] array = {msgString, userName,password};

        Object[] options = {btnString1, btnString2};

        optionPane = new JOptionPane(array,
                                    JOptionPane.QUESTION_MESSAGE,
                                    JOptionPane.YES_NO_OPTION,
                                    null,
                                    options,
                                    options[0]);

        setContentPane(optionPane);

        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
                public void windowClosing(WindowEvent we) {
                    optionPane.setValue(new Integer(
                                        JOptionPane.CLOSED_OPTION));
            }
        });

        addComponentListener(new ComponentAdapter() {
            public void componentShown(ComponentEvent ce) {
                userName.requestFocusInWindow();
            }
        });

        userName.addActionListener(this);
        password.addActionListener(this);

        optionPane.addPropertyChangeListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        optionPane.setValue(btnString1);
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();

        if (isVisible()
         && (e.getSource() == optionPane)
         && (JOptionPane.VALUE_PROPERTY.equals(prop) ||
             JOptionPane.INPUT_VALUE_PROPERTY.equals(prop))) {
            Object value = optionPane.getValue();

            if (value == JOptionPane.UNINITIALIZED_VALUE) {
                return;
            }

            optionPane.setValue(
                    JOptionPane.UNINITIALIZED_VALUE);

            if (btnString1.equals(value)) {
					uid=userName.getText();
					pwd=password.getText();
                    clearAndHide();

            } 
	    else { //user closed dialog or clicked cancel
                 uid = "";
				 pwd = "";
				 isCancel=true;
                 clearAndHide();
            }
        }
    }

    public void clearAndHide() {
        userName.setText(null);
        password.setText(null);
        setVisible(false);
    }
}