/*
 * Decompiled with CFR 0.152.
 */
package opalsofflinecirc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Scanner;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import opalsofflinecirc.LoginDialog;

public final class OpalsCirc
extends JPanel
implements ActionListener {
    JFrame frame;
    LoginDialog loginDialog;
    JTabbedPane tabbedPane;
    static final String LOANPANEL = "    Loan    ";
    static final String SETTINGPANEL = "    Setting   ";
    static final String UPLOADTRANS = "    Upload Transactions  ";
    static final String REPORTSPANEL = "    Reports  ";
    final int SEND_TRANS_SUCCESS = 1;
    final int SEND_TRANS_ERROR = 0;
    final int LOGIN_FAIL = 0;
    final int LOGIN_SUCCESS = 1;
    final int ERROR_URL = 2;
    final int ERROR_IO = 3;
    final int LOGIN_CANCEL = 4;
    protected static final String user_BC_cmd = "userBarCodeCmd";
    protected static final String user_ok_cmd = "userOKButton";
    protected static final String loan_BC_cmd = "loanBarCodeCmd";
    protected static final String loan_ok_cmd = "loanOKButton";
    protected static final String viewReport_cmd = "viewReportButton";
    protected static final String switch_user_cmd = "switchUserCmd";
    protected static final String upload_cmd = "uploadCmd";
    protected static final String userLabelTxt = "User Barcode ";
    protected static final String itemLabelTxt = "Item Barcode ";
    protected static final String transDateLabelTxt = "Transation Date ";
    protected static final String uploadLabelTxt = " Transactions Table ";
    protected static final String saveSetting_cmd = "saveSettingCmd";
    private JProgressBar progressBar;
    protected JLabel msgLabel;
    protected JLabel userLabel;
    protected JLabel loanItemBCLabel;
    protected JLabel urlLabel;
    protected JLabel uploadDateLabel;
    protected JButton user_ok;
    protected JButton loan_ok;
    protected JButton uploadButton;
    protected JTextField user_BC;
    protected JTextField item_loan_BC;
    protected JTextField urlBox;
    protected JTextField uploadDateBox;
    protected String userBC;
    protected String itemBC;
    protected JTable loanTable;
    protected JTable transactionTable;
    protected Vector loanRows;
    protected Vector loanColumns;
    protected Vector transRows;
    protected Vector transColumns;
    protected String uploadURL;
    protected String m_uid = "";
    protected String m_pwd = "";
    protected String m_sessionId = "";
    protected Boolean authenticated = false;
    protected JTextArea reportTxt;

    public OpalsCirc(JFrame frame) {
        super(new BorderLayout());
        this.frame = frame;
        this.loginDialog = new LoginDialog(frame);
        this.loginDialog.pack();
        JPanel loanPanel = this.CreateLoanTab();
        JPanel uploadPanel = this.create_UploadTab();
        JPanel settingPanel = this.create_SettingTab();
        JPanel reportPanel = this.create_ReportTab();
        JPanel helpPanel = this.create_HelpTab();
        Border padding = BorderFactory.createEmptyBorder(20, 20, 5, 20);
        loanPanel.setBorder(padding);
        uploadPanel.setBorder(padding);
        reportPanel.setBorder(padding);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("   Loan  ", null, loanPanel, "");
        tabbedPane.addTab("Upload Transactions", null, uploadPanel, "");
        tabbedPane.addTab("Report", null, reportPanel, "");
        tabbedPane.addTab("Setting", null, settingPanel, "");
        tabbedPane.addTab("Help", null, helpPanel, "");
        this.add((Component)tabbedPane, "Center");
        this.loadSetting();
        this.loadTransaction();
    }

    private JPanel CreateLoanTab() {
        JPanel loanCard = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width += 700;
                size.height += 400;
                return size;
            }
        };
        loanCard.setLayout(null);
        this.user_ok = new JButton("OK");
        this.user_ok.setActionCommand(user_ok_cmd);
        this.user_ok.addActionListener(this);
        this.loan_ok = new JButton("OK");
        this.loan_ok.setActionCommand(loan_ok_cmd);
        this.loan_ok.addActionListener(this);
        this.user_BC = new JTextField(10);
        this.user_BC.setActionCommand(user_BC_cmd);
        this.user_BC.addActionListener(this);
        this.item_loan_BC = new JTextField(10);
        this.item_loan_BC.setActionCommand(loan_BC_cmd);
        this.item_loan_BC.addActionListener(this);
        this.userLabel = new JLabel(userLabelTxt);
        this.userLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.loanItemBCLabel = new JLabel(itemLabelTxt);
        this.loanItemBCLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.loanTable = this.create_LoanTable();
        JScrollPane scrollPaneL = new JScrollPane(this.loanTable);
        loanCard.add(this.user_BC);
        loanCard.add(this.user_ok);
        loanCard.add(this.item_loan_BC);
        loanCard.add(this.loan_ok);
        loanCard.add(this.userLabel);
        loanCard.add(this.loanItemBCLabel);
        loanCard.add(scrollPaneL);
        Insets insets = loanCard.getInsets();
        Dimension size = this.user_BC.getPreferredSize();
        this.user_BC.setBounds(145 + insets.left, 5 + insets.top, 120, size.height);
        this.item_loan_BC.setBounds(145 + insets.left, 30 + insets.top, 120, size.height);
        this.user_ok.setBounds(270 + insets.left, 5 + insets.top, 60, size.height);
        this.userLabel.setBounds(60 + insets.left, 3 + insets.top, 150, size.height);
        this.loanItemBCLabel.setBounds(64 + insets.left, 28 + insets.top, size.width, size.height);
        this.user_BC.requestFocus(true);
        this.loan_ok.setBounds(270 + insets.left, 30 + insets.top, 60, size.height);
        scrollPaneL.setBounds(40 + insets.left, 85 + insets.top, 350, 200);
        this.loanItemBCLabel.setEnabled(false);
        this.item_loan_BC.setEnabled(false);
        this.loan_ok.setEnabled(false);
        return loanCard;
    }

    protected JPanel create_UploadTab() {
        JPanel returnCard = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width += 500;
                size.height += 300;
                return size;
            }
        };
        returnCard.setLayout(null);
        this.transactionTable = this.create_TransTable();
        JScrollPane scrollPaneL = new JScrollPane(this.transactionTable);
        this.uploadButton = new JButton("UpLoad");
        this.uploadButton.setEnabled(false);
        this.uploadButton.setActionCommand(upload_cmd);
        this.uploadButton.addActionListener(this);
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        JLabel transLabel = new JLabel(uploadLabelTxt);
        returnCard.add(transLabel);
        returnCard.add(scrollPaneL);
        returnCard.add(this.uploadButton);
        returnCard.add(this.progressBar);
        Insets insets = returnCard.getInsets();
        transLabel.setBounds(12 + insets.left, 20 + insets.top, 250, 20);
        scrollPaneL.setBounds(10 + insets.left, 40 + insets.top, 550, 270);
        this.uploadButton.setBounds(438 + insets.left, 16 + insets.top, 120, 20);
        this.progressBar.setBounds(12 + insets.left, 320 + insets.top, 550, 25);
        return returnCard;
    }

    protected JTable create_TransTable() {
        this.transRows = new Vector();
        this.transColumns = new Vector();
        this.transColumns.addElement("Trans #");
        this.transColumns.addElement("Item Barcode");
        this.transColumns.addElement("User Barcode");
        this.transColumns.addElement("Transaction Date");
        DefaultTableModel tabModel = new DefaultTableModel();
        tabModel.setDataVector(this.transRows, this.transColumns);
        JTable table = new JTable(tabModel);
        table.setRowSelectionAllowed(false);
        return table;
    }

    protected JPanel create_HelpTab() {
        JPanel helpCard = new JPanel(new GridLayout());
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        URL helpURL = OpalsCirc.class.getResource("help/help.htm");
        if (helpURL != null) {
            try {
                editorPane.setPage(helpURL);
            }
            catch (IOException e) {
                System.err.println("Attempted to read a bad URL: " + helpURL);
            }
        } else {
            System.err.println("Couldn't find file: help.htm");
        }
        JScrollPane scrollPaneHelp = new JScrollPane(editorPane);
        scrollPaneHelp.setPreferredSize(new Dimension(650, 300));
        helpCard.add(scrollPaneHelp);
        Insets insets = helpCard.getInsets();
        return helpCard;
    }

    protected JPanel create_SettingTab() {
        JPanel settingCard = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width += 500;
                size.height += 300;
                return size;
            }
        };
        settingCard.setLayout(null);
        this.urlLabel = new JLabel("Server Address");
        this.urlBox = new JTextField(90);
        JButton saveButton = new JButton("Save");
        saveButton.setActionCommand(saveSetting_cmd);
        saveButton.addActionListener(this);
        settingCard.add(this.urlLabel);
        settingCard.add(this.urlBox);
        settingCard.add(saveButton);
        Insets insets = settingCard.getInsets();
        Dimension size = this.user_BC.getPreferredSize();
        this.urlLabel.setBounds(20 + insets.left, 50 + insets.top, 120, 20);
        this.urlBox.setBounds(115 + insets.left, 50 + insets.top, 340, 20);
        saveButton.setBounds(455 + insets.left, 50 + insets.top, 70, 20);
        return settingCard;
    }

    protected JPanel create_ReportTab() {
        JPanel reportCard = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width += 500;
                size.height += 300;
                return size;
            }
        };
        reportCard.setLayout(null);
        this.uploadDateLabel = new JLabel("Transactions Date");
        this.uploadDateBox = new JTextField(10);
        this.uploadDateBox.setActionCommand(viewReport_cmd);
        this.uploadDateBox.addActionListener(this);
        JLabel dateFormat = new JLabel("(mm/dd/yyyy)");
        JButton viewReportButton = new JButton("View");
        viewReportButton.setActionCommand(viewReport_cmd);
        viewReportButton.addActionListener(this);
        Font font = new Font("Monospaced", 0, 12);
        this.reportTxt = new JTextArea(80, 20);
        this.reportTxt.setFont(font);
        this.reportTxt.setEditable(false);
        JScrollPane scrollPaneReport = new JScrollPane(this.reportTxt);
        reportCard.add(this.uploadDateLabel);
        reportCard.add(dateFormat);
        reportCard.add(this.uploadDateBox);
        reportCard.add(viewReportButton);
        reportCard.add(scrollPaneReport);
        Insets insets = reportCard.getInsets();
        Dimension size = this.user_BC.getPreferredSize();
        this.uploadDateLabel.setBounds(160 + insets.left, 20 + insets.top, 120, 20);
        this.uploadDateBox.setBounds(265 + insets.left, 20 + insets.top, 100, 20);
        dateFormat.setBounds(275 + insets.left, 35 + insets.top, 100, 20);
        viewReportButton.setBounds(375 + insets.left, 20 + insets.top, 70, 20);
        scrollPaneReport.setBounds(20 + insets.left, 70 + insets.top, 650, 300);
        return reportCard;
    }

    protected String getUrl() {
        String retUrl = this.uploadURL;
        if (!(retUrl = retUrl.trim()).startsWith("http://") && !retUrl.startsWith("https://")) {
            retUrl = "http://" + retUrl;
        }
        if (retUrl.lastIndexOf("/") != retUrl.length() - 1) {
            retUrl = retUrl + "/";
        }
        retUrl = retUrl + "bin/circ/uploadtrans";
        return retUrl;
    }

    protected void createReport(Date transDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String transDateStr = formatter.format(transDate);
        String reportStr = "";
        String urlstr = this.getUrl();
        String param = "op=report&transDate=" + transDateStr;
        try {
            URL obj = new URL(urlstr);
            HttpURLConnection con = urlstr.startsWith("https://") ? (HttpsURLConnection)obj.openConnection() : (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", "OPALS OFFLINE CIRC");
            con.setDoOutput(true);
            OutputStream os = con.getOutputStream();
            os.write(param.getBytes());
            os.flush();
            os.close();
            int responseCode = con.getResponseCode();
            System.out.println("POST Response Code :: " + responseCode);
            if (responseCode == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                while ((inputLine = in.readLine()) != null) {
                    reportStr = reportStr + inputLine + "\n";
                }
                this.reportTxt.setText(reportStr);
                in.close();
            } else {
                System.out.println("Cc=onnection ERROR");
            }
        }
        catch (MalformedURLException me) {
            JOptionPane.showMessageDialog(this.tabbedPane, "Incorrect server addresss or server is unreachable.");
            System.err.println(urlstr);
            System.err.println("MalformedURLException: " + me);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this.tabbedPane, "Incorrect server addresss or server is unreachable.");
            System.err.println("IOException: " + ioe.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (user_BC_cmd.equals(e.getActionCommand()) || user_ok_cmd.equals(e.getActionCommand())) {
            if (this.user_BC.getText().length() == 0) {
                JOptionPane.showMessageDialog(this.tabbedPane, "Please enter student Barcode.");
                this.user_BC.requestFocus();
            } else {
                String source = this.user_BC.getText();
                this.user_BC.setEnabled(false);
                this.userLabel.setEnabled(false);
                this.user_ok.setSize(120, 20);
                this.user_ok.setText("Switch User");
                this.user_ok.setActionCommand(switch_user_cmd);
                this.user_ok.requestFocus(false);
                this.loanItemBCLabel.setEnabled(true);
                this.item_loan_BC.setEnabled(true);
                this.loan_ok.setEnabled(true);
                this.item_loan_BC.setText("");
                this.item_loan_BC.requestFocus(true);
            }
        } else if (loan_BC_cmd.equals(e.getActionCommand()) || loan_ok_cmd.equals(e.getActionCommand())) {
            if (this.user_BC.getText().length() == 0) {
                JOptionPane.showMessageDialog(this.tabbedPane, "Please enter student Barcode.");
                this.user_BC.requestFocus();
            } else if (this.item_loan_BC.getText().length() == 0) {
                JOptionPane.showMessageDialog(this.tabbedPane, "Please enter item's Barcode.");
                this.item_loan_BC.requestFocus();
            } else {
                Date transDate = new Date();
                this.addLoan(this.user_BC.getText(), this.item_loan_BC.getText(), transDate);
                this.item_loan_BC.setText("");
            }
        } else if (viewReport_cmd.equals(e.getActionCommand())) {
            String dateStr = this.uploadDateBox.getText();
            if (this.isValidDate(dateStr).booleanValue()) {
                int tryCount;
                Date transDate = new Date(dateStr);
                int login = this.login();
                for (tryCount = 0; login != 1 && login != 4 && login != 3 && login != 2 && tryCount < 5; ++tryCount) {
                    login = this.login();
                }
                if (login == 1) {
                    this.createReport(transDate);
                } else if (tryCount == 5) {
                    JOptionPane.showMessageDialog(this.tabbedPane, "The username or password supplied is incorrect");
                }
            } else {
                JOptionPane.showMessageDialog(this.tabbedPane, "Invalid date.");
            }
        } else if (switch_user_cmd.equals(e.getActionCommand())) {
            this.loanItemBCLabel.setEnabled(false);
            this.item_loan_BC.setEnabled(false);
            this.loan_ok.setEnabled(false);
            this.user_BC.setEnabled(true);
            this.userLabel.setEnabled(true);
            this.user_ok.setSize(60, 20);
            this.user_ok.setText("OK");
            this.user_ok.setActionCommand(user_ok_cmd);
            this.user_BC.setText("");
            this.user_BC.requestFocus();
        } else if (upload_cmd.equals(e.getActionCommand())) {
            int tryCount;
            int login = this.login();
            for (tryCount = 0; login != 1 && login != 4 && login != 3 && login != 2 && tryCount < 5; ++tryCount) {
                login = this.login();
            }
            if (login == 1) {
                this.uploadTransaction();
            } else if (tryCount == 5) {
                JOptionPane.showMessageDialog(this.tabbedPane, "The username or password supplied is incorrect");
            }
        } else if (saveSetting_cmd.equals(e.getActionCommand())) {
            this.m_sessionId = "";
            this.saveSetting();
        }
    }

    protected int login() {
        int retval = 0;
        this.loginDialog.setLocationRelativeTo(this.frame);
        String urlstr = this.getUrl();
        if (this.m_sessionId.equals("")) {
            this.loginDialog.setVisible(true);
            this.m_uid = this.loginDialog.getUID();
            this.m_pwd = this.loginDialog.getPWD();
        }
        if (this.loginDialog.isCancel()) {
            return 4;
        }
        Boolean SSL = urlstr.startsWith("https://");
        String param = "op=auth&uid=" + this.m_uid + "&pwd=" + this.m_pwd;
        try {
            URL url = new URL(urlstr);
            HttpURLConnection con = SSL != false ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", "OPALS OFFLINE CIRC");
            con.setDoOutput(true);
            OutputStream os = con.getOutputStream();
            os.write(param.getBytes());
            os.flush();
            os.close();
            int responseCode = con.getResponseCode();
            if (responseCode == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                this.m_sessionId = response.toString();
                retval = this.m_sessionId.isEmpty() ? 0 : 1;
            } else {
                retval = 0;
                System.out.println("connection error");
            }
        }
        catch (MalformedURLException me) {
            JOptionPane.showMessageDialog(this.tabbedPane, "Incorrect server addresss or server is unreachable.");
            System.err.println(urlstr);
            System.err.println("MalformedURLException: " + me);
            this.m_sessionId = "";
            return 2;
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this.tabbedPane, "Incorrect server addresss or server is unreachable.");
            System.err.println("IOException: " + ioe.getMessage());
            return 3;
        }
        return retval;
    }

    protected JTable create_LoanTable() {
        this.loanRows = new Vector();
        this.loanColumns = new Vector();
        this.loanColumns.addElement(" Loan # ");
        this.loanColumns.addElement("User Barcode");
        this.loanColumns.addElement("Item Barcode");
        DefaultTableModel tabModel = new DefaultTableModel();
        tabModel.setDataVector(this.loanRows, this.loanColumns);
        JTable table = new JTable(tabModel);
        table.setRowSelectionAllowed(false);
        table.setPreferredScrollableViewportSize(new Dimension(350, 200));
        return table;
    }

    protected int sendPost_http(String url, String param) {
        int retval = 1;
        Boolean SSL = url.startsWith("https://");
        try {
            URL obj = new URL(url);
            HttpURLConnection con = SSL != false ? (HttpsURLConnection)obj.openConnection() : (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", "OPALS OFFLINE CIRC");
            con.setDoOutput(true);
            OutputStream os = con.getOutputStream();
            os.write(param.getBytes());
            os.flush();
            os.close();
            int responseCode = con.getResponseCode();
            System.out.println("POST Response Code :: " + responseCode);
            if (responseCode == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                this.m_sessionId = response.toString();
            } else {
                System.out.println("POST request not worked");
            }
        }
        catch (MalformedURLException me) {
            JOptionPane.showMessageDialog(this.tabbedPane, "Incorrect server addresss or server is unreachable.");
            System.err.println(url);
            System.err.println("MalformedURLException: " + me);
            this.m_sessionId = "";
            return 2;
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this.tabbedPane, "Incorrect server addresss or server is unreachable.");
            System.err.println("IOException: " + ioe.getMessage());
            return 3;
        }
        return retval;
    }

    protected void addLoan(String userBC, String itemBC, Date transDate) {
        Vector<Object> r = new Vector<Object>();
        r.addElement(this.loanRows.size() + 1);
        r.addElement(userBC);
        r.addElement(itemBC);
        DateFormat df = DateFormat.getDateInstance(3);
        this.loanRows.addElement(r);
        this.loanTable.addNotify();
        String transDateStr = df.format(transDate);
        this.addTrans2Tbl(itemBC, userBC, transDateStr);
        this.uploadButton.setEnabled(true);
        this.saveTransaction(itemBC, userBC, transDate);
    }

    protected boolean isLoaned(String itemBC) {
        Iterator it = this.loanRows.iterator();
        for (int index = 0; index < this.loanRows.size(); ++index) {
            Vector v = (Vector)this.loanRows.elementAt(index);
            if (!v.contains(itemBC)) continue;
            return true;
        }
        return false;
    }

    protected void saveTransaction(String itemBC, String userBC, Date tDate) {
        try {
            FileOutputStream fos = new FileOutputStream("transactions.csv", true);
            PrintStream p = new PrintStream(fos);
            DateFormat df = DateFormat.getDateInstance(3);
            String transDateStr = df.format(tDate);
            String TransRecStr = "\"" + itemBC + "\",\"" + userBC + "\"," + df.format(tDate);
            p.println(TransRecStr);
            p.close();
        }
        catch (Exception fileE) {
            JOptionPane.showMessageDialog(this.tabbedPane, "Could not save transaction !");
        }
    }

    protected void loadTransaction() {
        try {
            File file = new File("transactions.csv");
            Scanner scanner = new Scanner(file);
            scanner.useDelimiter(System.getProperty("line.separator"));
            while (scanner.hasNext()) {
                this.parseRec(scanner.next());
            }
            scanner.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    protected void parseRec(String recStr) {
        try {
            String[] rec = recStr.split(",");
            if (rec.length == 3) {
                this.addTrans2Tbl(rec[0], rec[1], rec[2]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void addTrans2Tbl(String itemBC, String userBC, String transDate) {
        Vector<Object> r = new Vector<Object>();
        r.addElement(this.transRows.size() + 1);
        r.addElement(itemBC);
        r.addElement(userBC);
        r.addElement(transDate);
        this.transRows.addElement(r);
        this.transactionTable.addNotify();
        this.uploadButton.setEnabled(true);
    }

    protected int sendTransaction(String itemBc, String userBc, String transDate) {
        int retval = 1;
        try {
            String urlstr = this.getUrl();
            URL url = new URL(urlstr);
            HttpURLConnection con = urlstr.startsWith("https://") ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
            String param = "op=loan&itemBc=" + itemBc + "&userBc=" + userBc + "&transDate=" + transDate + "&sid=" + this.m_sessionId;
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", "OPALS OFFLINE CIRC");
            con.setDoOutput(true);
            OutputStream os = con.getOutputStream();
            os.write(param.getBytes());
            os.flush();
            os.close();
            int responseCode = con.getResponseCode();
            if (responseCode == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                String rs = response.toString();
                retval = !rs.isEmpty() ? 1 : 0;
            } else {
                retval = 0;
                System.out.println("connection error");
            }
        }
        catch (MalformedURLException me) {
            JOptionPane.showMessageDialog(this.tabbedPane, "There is error in the server address setting or the server is unreachable.");
            System.err.println("MalformedURLException: " + me);
            return 2;
        }
        catch (IOException ioe) {
            System.err.println("IOException: " + ioe.getMessage());
            return 3;
        }
        return retval;
    }

    protected void uploadTransaction() {
        Date tmpDate;
        Vector trans;
        if (this.uploadURL.equals("")) {
            this.uploadURL = this.urlBox.getText();
        }
        if (this.uploadURL.equals("")) {
            JOptionPane.showMessageDialog(this.tabbedPane, "Please set the upload server addresss in the setting tab.");
            return;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        int i = 0;
        this.progressBar.setMaximum(this.transRows.size());
        this.progressBar.setMinimum(0);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        int countDone = 0;
        this.setCursor(Cursor.getPredefinedCursor(3));
        while (i < this.transRows.size()) {
            trans = (Vector)this.transRows.get(i);
            String transDateStr = "";
            tmpDate = new Date((String)trans.elementAt(3));
            transDateStr = formatter.format(tmpDate);
            int rs = this.sendTransaction((String)trans.elementAt(1), (String)trans.elementAt(2), transDateStr);
            if (rs != 1) break;
            this.transRows.remove(i);
            this.progressBar.setValue(++countDone);
        }
        this.transactionTable.addNotify();
        if (this.transRows.size() == 0) {
            this.uploadButton.setEnabled(false);
        }
        this.clearTransfile();
        i = 0;
        for (i = 0; i < this.transRows.size(); ++i) {
            trans = (Vector)this.transRows.get(i);
            tmpDate = new Date((String)trans.elementAt(2));
            this.saveTransaction((String)trans.elementAt(0), (String)trans.elementAt(1), tmpDate);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void clearTransaction() {
        this.transRows.clear();
        this.loanRows.clear();
        this.clearTransfile();
    }

    protected void clearTransfile() {
        try {
            FileOutputStream out = new FileOutputStream("transactions.csv");
            PrintStream p = new PrintStream(out);
            p.println("");
            p.close();
        }
        catch (Exception e) {
            System.err.println("Error writing to file");
        }
    }

    protected void loadSetting() {
        this.uploadURL = "";
        try {
            File file = new File("opals.ini");
            Scanner scanner = new Scanner(file);
            scanner.useDelimiter(System.getProperty("line.separator"));
            while (scanner.hasNext()) {
                String field;
                String tmpStr = scanner.next();
                int i = tmpStr.indexOf("=");
                if (i <= 0 || !(field = tmpStr.substring(0, i)).equals("uploadURL")) continue;
                this.uploadURL = tmpStr.substring(i + 1, tmpStr.length() - 1);
            }
            scanner.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.urlBox.setText(this.uploadURL);
    }

    protected void saveSetting() {
        try {
            String str;
            FileOutputStream fos = new FileOutputStream("opals.ini", false);
            PrintStream p = new PrintStream(fos);
            this.uploadURL = str = this.urlBox.getText();
            str = str.trim();
            this.urlBox.setText(str);
            str = "uploadURL=" + str + "\n";
            p.println(str);
            p.close();
        }
        catch (Exception fileE) {
            JOptionPane.showMessageDialog(this.tabbedPane, "Could not save setting !");
        }
    }

    public Boolean isValidDate(String d) {
        DateFormat df = DateFormat.getDateInstance(3);
        try {
            Date myDate = df.parse(d);
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("OPALS Offline Circulation");
        frame.setDefaultCloseOperation(3);
        OpalsCirc newContentPane = new OpalsCirc(frame);
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        newContentPane.setSize(new Dimension(680, 300));
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OpalsCirc.createAndShowGUI();
            }
        });
    }
}

