(function (angular) {


    let oplSvc = angular.module("oplSvc", []);
    let validUrl = require('valid-url');
    let headers={'User-Agent': 'Opals Offline Circualtion app'};
    oplSvc.service('utilSvc', function ($http) {

        const request = require('request');
        const homedir = require('os').homedir();
        let fs = require('fs');
        if (!fs.existsSync(homedir + "/.opals-offline-circ")) {
            fs.mkdirSync(homedir + "/.opals-offline-circ");
        }
        let cfgFilename = homedir + '/.opals-offline-circ/opals.ini';
        let $utilSvc=this;
        //--------------------------------------------------

        $utilSvc.getLibInfo = function (cbFn) {
            let cfg = $utilSvc.loadConfig();
            if (cfg && cfg.libUrl && validUrl.isUri(cfg.libUrl)) {
                let url = cfg.libUrl + "/bin/svc/circSvc?op=auth";
                $utilSvc.testConn(url,function (rs) {
                    if (rs) {
                        url = cfg.libUrl + "/bin/svc/circSvc";
                        $utilSvc.httpPost(url, { op: 'getLibInfo' }, function (rs) {
                            cbFn(rs)
                        });
                    }
                    else {
                        cbfn();
                    }
                })
            }

        }

        //--------------------------------------------------

        $utilSvc.httpPost = function (url, data, cbfn) {
            request.post({url:url,headers:headers,json: data },
                (error, res, data) => {
                    if (error) {
                        console.error(error)
                        return
                    }
                    cbfn(data);
                })
        }
        //--------------------------------------------------

        $utilSvc.testConn = function (url, cbfn) {
            request.head({url:url, headers:headers,followRedirect :false},
                (error, res, data) => {
                    cbfn(res.statusCode == 200);
                });
        }
        //--------------------------------------------------

        $utilSvc.loadConfig = function () {
            let cfg = {};
            if (fs.existsSync(cfgFilename)) {
                let data = fs.readFileSync(cfgFilename, 'utf8');
                cfg = JSON.parse(data);
            }
            else {
                console.log("Config File Doesn\'t Exist. Creating new file.");
                fs.writeFile(cfgFilename, JSON.stringify(config), (err) => {
                    if (err)
                        console.log(err)
                })
            }
            return cfg;
        }
        //-----------------------------------------------------------------
        $utilSvc.saveConfig = function (cfg) {
            fs.writeFile(cfgFilename, JSON.stringify(cfg), (err) => {
                if (err)
                    console.log(err)
            });
        }
        //-----------------------------------------------------------------
        $utilSvc.getCurDate = function () {
            return moment().format("YYYY-MM-DD");
        }
        //-----------------------------------------------------------------
        $utilSvc.getCurDatetime = function () {
            return moment().format("YYYY-MM-DD hh:mm:ss");
        }
        //-----------------------------------------------------------------
        // GUID generating function
        $utilSvc.genGUID = function () {
            return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
                var r = Math.random() * 16 | 0, v = c === 'x' ? r : (r & 0x3 | 0x8);
                return v.toString(16);
            });

        }
    })//END service oplSession
        ;



})(window.angular);


