

(function(angular) {
	var oplDirective = angular.module("oplDirective", ['oplServiceFn']);

	//----------------------------------------------------------------------------------------------------------------
	oplDirective.directive('oplProgressBar', function() {
		return {
			restrict: 'EA',
			templateUrl: "ng-template/progressbar.html",
			scope: { percentCompleted: '=' }
		}
	});

	//----------------------------------------------------------------------------------------------------------------


	oplDirective.directive('ngEnter', function() {
		return function(scope, elem, attrs) {
			elem.bind("keydown keypress", function(event) {
				// 13 represents enter button
				if (event.which === 13) {
					scope.$apply(function() {
						scope.$eval(attrs.ngEnter);
					});

					event.preventDefault(scope, iElement, iAttrs);
				}
			});
		};
	});


	//----------------------------------------------------------------------------------------------------------------
	oplDirective.directive('circReport', function() {
		return {
			restrict: 'EA',
			templateUrl: "ng-template/circ-report.html",
			scope: { initFn: '=', validateUser: '=' },
			controller: ['$scope', function($scope) {

				$scope.initFn = function() {
					$scope.ERROR = "";
					$scope.libUrl = circService.getLibUrl();
					if (!circService.testUrlConn($scope.libUrl + "/bin/svc/circSvc?op=auth")) {
						$scope.ERROR = "No connection to " + $scope.libUrl + ". Please check the URL and your network connection";
						return;
					}
				}
				$scope.getReport = function() {
					$scope.validateUser($scope.downloadReport);
				}
				$scope.downloadReport = function() {
					var url = circService.getLibUrl();
					if (!url || url == "" || !circService.isValidURL(url)) {
						$scope.ERROR = "invalid URL";
					}
					else if (!circService.testUrlConn(url + "/bin/svc/circSvc?op=auth")) {
						$scope.ERROR = "No internet connection to " + url;
					}

					$scope.reportJson = JSON.parse(circService.getReport($scope.transDate));

				}

			}],
			link: function(scope, iElement, iAttrs) {
				$("#datepicker-rptTab").datepicker({
					autoclose: true,
					todayHighlight: true,
					format: 'yyyy-mm-dd'
				}).datepicker('update', new Date());
			}
		}
	});


	//-----------------------------------------------------------------------------
	oplDirective.directive('circLoan', ['oplUtilFn', function(oplUtilFn) {
		return {
			restrict: 'EA',
			templateUrl: "ng-template/circ-loan.html",
			scope: { updateFn: '=', initFn: '=' },
			controller: ['$scope', function($scope) {
				$scope.userBc = "";
				$scope.itemBc = "";
				$scope.initFn = function() {
					$scope.updateLoanList();

					setTimeout(function() { $("#circ-loan-userBc").focus(); }, 300);
				}
				$scope.addLoan = function() {
					if ($scope.itemBc != "" && $scope.userBc != "") {
						var transDate = oplUtilFn.getCurDatetime();
						circService.addLoan($scope.userBc, $scope.itemBc, transDate);
						$scope.updateLoanList();
						$scope.itemBc = "";
					}
				}
				//-----------------------------------------------------------------------------
				$scope.updateLoanList = function() {
					circService.loadLoanList(function(data) {
						$scope.loanList = Array.from(data);
						$scope.$apply();
					});

				}
				$scope.updateFn = function() {
					$scope.updateLoanList();
					$scope.$apply();
				}

				//-----------------------------------------------------------------------------
				$scope.userBcOnChange = function() {
					$scope.itemBc = "";
					$("#circ-loan-itemBc").focus();
				}
				//-----------------------------------------------------------------------------
				$scope.switchUser = function() {
					$scope.userBc = "";
					$scope.itemBc = "";
					$("#circ-loan-userBc").focus();
				}
				$scope.confirmDelLoan = function(loan) {
					$scope.ERROR = loan.getItemBc();
					$scope.trans2Del = loan;
					$("#circ-loan-confirm-dlg").modal();

				}
				$scope.delLoan = function(loan) {
					circService.delLoan(loan.getUserBc(), loan.getItemBc(), loan.getTransDate());
					$scope.updateLoanList();
					$("#circ-loan-confirm-dlg").modal("hide");
				}
				$scope.updateLoanList();

			}]
		}
	}]);
	//-----------------------------------------------------------------------------
	oplDirective.directive('circReturn', ['oplUtilFn', function(oplUtilFn) {
		return {
			restrict: 'EA',
			templateUrl: "ng-template/circ-return.html",
			scope: { updateFn: '=', initFn: '=' },
			controller: ['$scope', function($scope) {
				$scope.itemBc = "";
				$scope.initFn = function() {
					$scope.updateReturnList();
					setTimeout(function() { $("#circ-return-itemBc").focus(); }, 300);
				}
				$scope.addReturn = function() {
					if ($scope.itemBc != "") {
						var transDate = oplUtilFn.getCurDatetime();
						circService.addReturn($scope.itemBc, transDate);
						$scope.updateReturnList();
						$scope.itemBc = "";
					}
				}
				//-----------------------------------------------------------------------------
				$scope.updateReturnList = function() {
					circService.loadReturnList(function(data) {
						$scope.returnList = Array.from(data);
						$scope.$apply();
					});

				}
				$scope.updateFn = function() {
					$scope.updateReturnList();
					$scope.$apply();
				}
				$scope.confirmDelReturn = function(retTrans) {
					$scope.trans2Del = retTrans;
					$("#circ-return-confirm-dlg").modal();

				}
				$scope.delReturn = function(retTrans) {
					circService.delReturn(retTrans.getItemBc(), retTrans.getTransDate());
					$scope.updateReturnList();
					$("#circ-return-confirm-dlg").modal("hide");
				}


			}]
		}
	}]);
	//-----------------------------------------------------------------------------
	oplDirective.directive('circRenew', ['oplUtilFn', function(oplUtilFn) {
		return {
			restrict: 'EA',
			templateUrl: "ng-template/circ-renew.html",
			scope: { updateFn: '=', initFn: '=' },
			controller: ['$scope', function($scope) {
				$scope.itemBc = "";
				$scope.initFn = function() {
					$scope.updateRenewalList();
					setTimeout(function() { $("#circ-Renew-itemBc").focus(); }, 300);
				}
				$scope.addRenew = function() {
					if ($scope.itemBc != "") {
						var transDate = oplUtilFn.getCurDatetime();
						circService.addRenew($scope.itemBc, transDate);
						$scope.updateRenewalList();
						$scope.itemBc = "";
					}
				}
				//-----------------------------------------------------------------------------
				$scope.updateRenewalList = function() {
					circService.loadRenewalList(function(data) {
						$scope.renewList = Array.from(data);
						$scope.$apply();
					});

				}
				$scope.updateFn = function() {
					$scope.updateRenewalList();
					$scope.$apply();
				}
				$scope.confirmDelRenewal = function(renewTrans) {
					$scope.trans2Del = renewTrans;
					$("#circ-renewal-confirm-dlg").modal();

				}
				$scope.delRenewal = function(renewTrans) {
					circService.delRenew(renewTrans.getItemBc(), renewTrans.getTransDate());
					$scope.updateRenewalList();
					$("#circ-renewal-confirm-dlg").modal("hide");
				}


			}]
		}
	}]);
	//----------------------------------------------------------------------------------------------------------------
	oplDirective.directive('circUploadTrans', function() {
		return {
			restrict: 'EA',
			templateUrl: "ng-template/circ-upload-trans.html",
			scope: { validateUser: '=', initFn: '=' },
			controller: ['$scope', function($scope) {
				$scope.percentCompleted = null;
				$scope.initFn = function() {
					$scope.ERROR = "";
					$scope.percentCompleted = 0;
					$scope.debug = "debug";
					circService.loadTransList(function(data) {
						$scope.transList = $scope.transObjList2Json(Array.from(data));
						$scope.$apply();
					});
					$scope.libUrl = circService.getLibUrl();
					if (!circService.testUrlConn($scope.libUrl + "/bin/svc/circSvc?op=auth")) {
						$scope.ERROR = "No connection to " + $scope.libUrl + ". Please check the URL and your network connection";

					}
				}
				$scope.transObj2Json=function(transObj){
				    var transJson={};
				    transJson.itemBc=transObj.getItemBc();;
				    transJson.userBc=transObj.getUserBc();
				    transJson.transDate=transObj.getTransDate();
				    transJson.transType=transObj.getTransTypeName();
					return transJson;
				}
				$scope.transObjList2Json=function(transObjList){
				    var transJsonList=[];
				    angular.forEach(transObjList,function(t){
				    	transJsonList.push($scope.transObj2Json(t));
				    });
					return transJsonList;
				}
				$scope.postNextTrans = function() {
				    var idx=$scope.postingTransIdx;
					if (idx>=0 && idx <$scope.transList.length) {
						var trans = $scope.transList[idx];
						var itemBc = trans.itemBc;
						var userBc = trans.userBc;
						var transDate = trans.transDate;
						var transType = trans.transType;
						trans.status="posting";
						circService.postTrans(userBc, itemBc, transDate, transType, function(rs) {
							$scope.totalComplete++;
							$scope.percentCompleted = Math.floor($scope.totalComplete * 100 / $scope.total)
							setTimeout(function() { $scope.$digest() }, 10);
							circService.delTrans(userBc, itemBc, transDate, transType);
							circService.logPostTransRs(rs.getTransType(), rs.getUserBc(), rs.getItemBc(), rs.getDatePost(), rs.getDateLoan(), rs.getDateDue(), rs.getStatus(), rs.getLoanId(), rs.getNotes());
                            trans.status="posted";
                            $scope.postingTransIdx++;
							$scope.postNextTrans();
						});

					}
				}
	
				$scope.postTrans = function() {

					circService.loadTransList(function(data) {
						$scope.transList = $scope.transObjList2Json(Array.from(data));
						$scope.total = $scope.transList.length;
						$scope.totalComplete = 0;
						$scope.percentCompleted = 0;
						$scope.postingTransIdx=0;
						$scope.postNextTrans();

					});
				}

				$scope.uploadTrans = function() {
					$scope.percentCompleted = 0;
					$scope.validateUser(function() {
						$scope.postTrans();
					});
				}


			}]
		}
	});

})(window.angular);

