
(function(angular) {
	var app = angular.module('OpalsOfflineCirc', ['oplDirective']);

	app.controller('OpalsOfflineCircCtrl', function($scope, $http) {



		$scope.username = "";
		$scope.password = "";
		$scope.libUrl = circService.getLibUrl();
		$scope.URL_MSG="";
		$scope.URL_ERROR=null;
		$scope.libName = circService.getLibName();
		$scope.initLoanTab = function() { };
		$scope.initCircUploadTab = function() { };
		$scope.initRenewalTab = function() { };
		$scope.initReturnTab = function() { };


		//-----------------------------------------------------------------------------
		$scope.saveLibUrl = function() {
			$scope.URL_ERROR = null;
			$scope.URL_MSG=null;
			var match = $scope.libUrl.match(/(http(s?):\/\/.[^/:]+)/i);
			if (match != null && match.length > 2 && typeof match[1] === 'string' && match[1].length > 0) {
				$scope.libUrl = match[1];				
			}
			if (circService.isValidURL($scope.libUrl)) {
				circService.saveLibUrl($scope.libUrl);
				$scope.libName = circService.getLibName();
				$scope.URL_MSG="Lib URL saved."
				if(circService.testUrlConn($scope.libUrl + "/bin/svc/circSvc?op=auth")) {
					$scope.URL_MSG="Lib URL saved."
				}
				else
					$scope.URL_MSG = "No connection to " + $scope.libUrl + ". Please check the URL and your network connection";
					$scope.URL_ERROR="NETWORK"
			}
			
			
			else {
				$scope.URL_MSG = "Invalid URL";
				$scope.URL_ERROR="INVALID";
			}
			$scope.$apply();

		}

		//-----------------------------------------------------------------------------
		$scope.auth = function(callbackFn) {
			if(!$scope.authenticating){	
				$scope.authenticating=true;
				var resp = circService.authenticate($scope.username, $scope.password);			
				if (resp.getErrorCode() == '0') {
					$scope.authenticated = true;
					$scope.ssid = resp.getSsid();
					$("#loginDlg").modal("hide");				
					if (callbackFn) {
						$scope.DEBUG +="callbackFn -- [" + resp.getErrorCode() +"]";
						callbackFn();
					}
				}
				else {
	               $scope.ERROR_LOGIN="Invalid username or password";
				}
				$scope.authenticating=false;
			}


		}
		
		//-----------------------------------------------------------------------------
		$scope.validateUser = function(cbFn) {
			$scope.DEBUG = "validateUser";
			if (!$scope.authenticated) {
				$scope.login(cbFn);
			}
			else {
				cbFn();
			}
		}

		//-----------------------------------------------------------------------------
		$scope.loginCallbackFn = null;
		$scope.login = function(callBackFn) {
			$("#loginDlg").modal();
			setTimeout(function(){$("#login-usrname").focus();},200);
			$scope.loginCallbackFn = callBackFn;

		}
		//-----------------------------------------------------------------------------
		$scope.uploadCompleteNum = "98";
		$scope.uploadCompletePer = "98%";
		$scope.percentCompleted = 0;
		$scope.debug = function(data) {
			$scope.output = data;
			$scope.$apply();
		}
		$scope.output = "";


		//-----------------------------------------------------------------------------
		$scope.getReport = function(transDate) {
			var url = circService.getLibUrl();

			if (!url || url == "" || !circService.isValidURL(url)) {
				$scope.ERROR = "invalid URL";
			}
			else if (!circService.testUrlConn(url + "/bin/svc/circSvc?op=auth")) {
				$scope.ERROR = "No internet connection to " + url;

			}
			if (!$scope.authenticated) {
				$scope.login();
				$scope.loginCallbackFn = function() { $scope.getReport(transDate) };
			}
			else {
				$scope.reportJson = JSON.parse(circService.getReport(transDate));

			}
		}



		$scope.updateLoanTab = function() {
			$("#circ-loan-userBc").focus();
		}

		//-----------------------------------------------------------------------------


	});


})(window.angular);

//----------------------------------------------------------------------------------------------------------------      



