    SSLEngine on
    SSLProxyEngine On
    SSLProtocol all
    
    Include conf.d/include/STAR_orc_scoolaid_net.inc
    
    ProxyRequests On
    #ProxyVia On
    
    SetEnv proxy-initial-not-pooled 1
    
    SetEnv force-proxy-request-1.0 1
    SetEnv proxy-nokeepalive 1
    RequestReadTimeout header=30
    LogLevel debug

    ProxyPass / https://web.p.ebscohost.com/
    ProxyPassReverse / https://web.p.ebscohost.com/
  
    
    ProxyPassReverse /ebsco_search/ http://search.ebscohost.com/
    #ProxyPassReverse /ebsco_search_ssl/ https://search.ebscohost.com/
    ProxyPassReverse /ebsco_eoncontent/ http://eoncontent.ebscohost.com/
    ProxyPassReverse /ebsco_content/ http://content.ebscohost.com/
    ProxyPassReverse /ebsco_pdc-edm/ https://pdc-edm.ebscohost.com
    ProxyPassReverse /ebsco_pdc-edm/ https://pdc-edm.ebscohost.com/
    #ProxyPassReverse /noodletools/ https://my.noodletools.com/
    NoProxy https://my.noodletools.com/
    
    RewriteEngine on
   
    RewriteCond %{SERVER_NAME}  ^(.+)\.(.+)\.(orc.scoolaid.net)$ [NC]
    RewriteRule    (.*)\ (.*)\ (.*)     $1\%2520$2\%2520$3
    
    Include conf.d/filter/orcFilter.inc

    ProxyPassReverseCookieDomain ebscohost.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain .ebscohost.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain web.p.ebscohost.com .orc.scoolaid.net
    ProxyPassReverseCookiePath / /
    
    RewriteRule   ^/ebsco_search/(.*)  http://search.ebscohost.${SYSCODE}.orc.scoolaid.net/$1 
    #RewriteRule   ^/ebsco_search_ssl/(.*)  http://search.ebscohost.${SYSCODE}.orc.scoolaid.net/$1 
    
    RewriteRule   ^/ebsco_eoncontent/(.*)  http://eoncontent.ebscohost.${SYSCODE}.orc.scoolaid.net/$1 [P]
    RewriteRule   ^/ebsco_content/(.*)  http://content.ebscohost.${SYSCODE}.orc.scoolaid.net/$1 [P]
    RewriteRule   ^/ebsco_pdc-edm/(.*)  https://pdc-edm-ebscohost.${SYSCODE}.orc.scoolaid.net/$1
    RewriteRule   ^/noodletools/(.*)  https://my-noodletools-${SYSCODE}.orc.scoolaid.net/$1
       
    Include conf.d/orc/vendor/inc/ebsco/web_orcDBId.inc


    ProxyHTMLDoctype "<!DOCTYPE html>"

    <Location /brc/delivery>
      SetOutputFilter    proxy-html
      SubstituteMaxLineLength 50m
      AddOutputFilterByType SUBSTITUTE text/plain text/html text/xml application/json application/javascript application/xml application/xhtml+xml application/x-research-info-systems plain/text
      Substitute "s|search.ebscohost.com|search-ebscohost-${SYSCODE}.orc.scoolaid.net|i"
    </Location>
    
    <Location /ehost/detail/detail>
      SetOutputFilter    proxy-html
      #AddDefaultCharset utf-8
      AddOutputFilterByType SUBSTITUTE text/plain text/html text/xml application/json application/javascript application/xml application/xhtml+xml application/x-research-info-systems plain/text
      Substitute "s|search.ebscohost.com|search-ebscohost-${SYSCODE}.orc.scoolaid.net|i"
    </Location>

    <Location /ehost/results>
      AddDefaultCharset utf-8
      #AddOutputFilterByType SUBSTITUTE text/x-js text/plain text/html application/json application/javascript application/xml application/xhtml+xml application/octet-stream
    </Location>

    <Location /ehost/Search/PerformSearch>
      AddDefaultCharset utf-8
      #AddOutputFilterByType SUBSTITUTE text/x-js text/plain text/html application/json application/javascript application/xml application/xhtml+xml application/octet-stream
    </Location>
    <Location /brc/delivery>
      #AddDefaultCharset utf-8
      AddOutputFilterByType SUBSTITUTE text/plain text/html application/json application/javascript application/xml application/xhtml+xml application/x-research-info-systems plain/text
      #Substitute "s|search.ebscohost.com|search-ebscohost-${SYSCODE}.orc.scoolaid.net|i"
    </Location>

    <Location /ehost/delivery>
      #SetOutputFilter    proxy-html
      #AddDefaultCharset utf-8
      #AddOutputFilterByType SUBSTITUTE text/plain text/html text/xml application/json application/javascript application/xml application/xhtml+xml application/x-research-info-systems plain/text
      AddOutputFilterByType SUBSTITUTE text/xml
      #Substitute "s|search.ebscohost.com|search-ebscohost-${SYSCODE}.orc.scoolaid.net|i"
    </Location>



    <Location /ehost/>
      #ProxyHTMLCharsetOut *
      #SetOutputFilter INFLATE;proxy-html;DEFLATE
      #SetOutputFilter    proxy-html
      SubstituteMaxLineLength 50m
      AddOutputFilterByType SUBSTITUTE text/plain text/html application/json application/javascript application/xml application/xhtml+xml application/x-research-info-systems plain/text
      #AddOutputFilterByType SUBSTITUTE text/x-js text/plain text/html application/json application/javascript application/xml application/xhtml+xml application/octet-stream
      Substitute "s|http://web.a.ebscohost.com|http://web.a.ebscohost.${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|https://web.a.ebscohost.com|https://web-a-ebscohost.${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|http://web.b.ebscohost.com|http://web.b.ebscohost.${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|https://web.b.ebscohost.com|https://web-b-ebscohost-${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|http://web.p.ebscohost.com|http://web.p.ebscohost.${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|https://web.p.ebscohost.com|https://web-p-ebscohost-${SYSCODE}.orc.scoolaid.net|i"
      #Substitute "s|search.ebscohost.com|search-ebscohost-${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|pdc-edm.ebscohost.com|pdc-edm-ebscohost-${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|galegroup.com|gale.${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|search.proquest.com|search.proquest.${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|https://video.ebscohost.com|https://video-ebscohost-${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|http://www.jstor.org|jstor.${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|https://www.jstor.org|https://jstor-${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|repere.sdm.qc.ca|repere.sdm.${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|search.proquest.com|search-proquest-${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|my.noodletools.com|my-noodletools-${SYSCODE}.orc.scoolaid.net|i"
      RequestHeader     unset   Accept-Encoding
    </Location>
    
    <Location />
        #SetOutputFilter    proxy-html
        #ProxyHTMLCharsetOut *
        #AddDefaultCharset utf-8
        #SetOutputFilter    INFLATE;proxy-html;DEFLATE
        #SetOutputFilter INFLATE
        #SubstituteMaxLineLength 10m
        AddOutputFilterByType SUBSTITUTE text/plain text/html application/json application/javascript application/xml application/xhtml application/octet-stream
        Substitute "s|https://web.a.ebscohost.com|https://web-a-ebscohost.${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|https://web.b.ebscohost.com|https://web-b-ebscohost-${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|https://web.p.ebscohost.com|https://web-p-ebscohost-${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|web.p.ebscohost.com|web-p-ebscohost-${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|search.ebscohost.com|search-ebscohost-${SYSCODE}.orc.scoolaid.net|i"
        #Substitute "s|https://search.ebscohost.com|https://search-ebscohost-${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|https://video.ebscohost.com|https://video-ebscohost-${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|galegroup.com|gale.${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|link.gale.com|link-gale.${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|search.proquest.com|search.proquest.${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|www.jstor.org|jstor-${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|repere.sdm.qc.ca|repere.sdm.${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|repere.sdm.qc.ca|repere.sdm.${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|search.proquest.com|search-proquest-${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|my.noodletools.com|my-noodletools-${SYSCODE}.orc.scoolaid.net|i"
	      Substitute "s|www.choicereviews.org|choicereviews.${SYSCODE}.orc.scoolaid.net|i"
        RequestHeader     unset   Accept-Encoding
    </Location>
    
    ProxyRequests Off

