    SSLEngine on
    SSLProxyEngine On
    SSLProtocol all
    
    Include conf.d/include/STAR_orc_scoolaid_net.inc
    
    ProxyRequests On
    #ProxyVia On
    
    SetEnv proxy-initial-not-pooled 1
    
    SetEnv force-proxy-request-1.0 1
    SetEnv proxy-nokeepalive 1
    RequestReadTimeout header=30
    LogLevel debug

    ProxyPass / https://video.ebscohost.com/
    ProxyPassReverse / https://video.ebscohost.com/
  
    
    ProxyPassReverse /ebsco_search/ http://search.ebscohost.com/
    ProxyPassReverse /ebsco_search_ssl/ https://search.ebscohost.com/
    ProxyPassReverse /ebsco_eoncontent/ http://eoncontent.ebscohost.com/
    ProxyPassReverse /ebsco_content/ http://content.ebscohost.com/
    
    RewriteEngine on
   
    RewriteCond %{SERVER_NAME}  ^(.+)\.(.+)\.(orc.scoolaid.net)$ [NC]
    RewriteRule    (.*)\ (.*)\ (.*)     $1\%2520$2\%2520$3
    
    #Include conf.d/filter/orcFilter.inc
    RewriteCond %{SERVER_NAME}  \.([^\.]+)\.(orc\.scoolaid\.net)$ [NC]
	  RewriteRule ^/(.*)$ - [CO=orcSysCode:%1:%2:1440:/,E=SYSCODE:%1]

    #RewriteCond %{SERVER_NAME}  ^(.+)\.(.+)\.(orc.scoolaid.net)$ [NC]
    #RewriteRule    (.*)\ (.*)\ (.*)     $1\%2520$2\%2520$3

    ProxyPassReverseCookieDomain ebscohost.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain .ebscohost.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain video.ebscohost.com .orc.scoolaid.net
    ProxyPassReverseCookiePath / /
    
    RewriteRule   ^/ebsco_search/(.*)  http://search.ebscohost.${SYSCODE}.orc.scoolaid.net/$1 
    RewriteRule   ^/ebsco_search_ssl/(.*)  http://search.ebscohost.${SYSCODE}.orc.scoolaid.net/$1 
    
    RewriteRule   ^/ebsco_eoncontent/(.*)  http://eoncontent.ebscohost.${SYSCODE}.orc.scoolaid.net/$1 [P]
    RewriteRule   ^/ebsco_content/(.*)  http://content.ebscohost.${SYSCODE}.orc.scoolaid.net/$1 [P]
       
    #Include conf.d/orc/vendor/inc/ebsco/web_orcDBId.inc


    ProxyHTMLDoctype "<!DOCTYPE html>" XML
    
    <Location /ehost/results>
      AddDefaultCharset utf-8
      #AddOutputFilterByType SUBSTITUTE text/x-js text/plain text/html application/json application/javascript application/xml application/xhtml+xml application/octet-stream
    </Location>

    <Location /ehost/Search/PerformSearch>
      AddDefaultCharset utf-8
      #AddOutputFilterByType SUBSTITUTE text/x-js text/plain text/html application/json application/javascript application/xml application/xhtml+xml application/octet-stream
    </Location>
    
    <Location /ehost/>
      ProxyHTMLCharsetOut *
      SetOutputFilter INFLATE;proxy-html;DEFLATE
      SubstituteMaxLineLength 10m
      AddOutputFilterByType SUBSTITUTE text/x-js text/plain text/html application/json application/javascript application/xml application/xhtml+xml application/octet-stream
      Substitute "s|http://web.a.ebscohost.com|http://web.a.ebscohost.${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|http://web.b.ebscohost.com|http://web.b.ebscohost.${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|http://search.ebscohost.com|http://search.ebscohost.${SYSCODE}.orc.scoolaid.net|i"
      RequestHeader     unset   Accept-Encoding
    </Location>
    
    <Location />
        SetOutputFilter    proxy-html
        #ProxyHTMLCharsetOut *
        #AddDefaultCharset utf-8
        #SetOutputFilter    INFLATE;proxy-html;DEFLATE
        #SetOutputFilter INFLATE
        #SubstituteMaxLineLength 10m
        AddOutputFilterByType SUBSTITUTE text/plain text/html application/json application/javascript application/xml application/xhtml application/octet-stream
        Substitute "s|web.a.ebscohost.com|web.a.ebscohost.${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|web.b.ebscohost.com|web.b.ebscohost.${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|http://web.a.ebscohost.com|http://web.a.ebscohost.${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|http://web.b.ebscohost.com|http://web.b.ebscohost.${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|https://web.a.ebscohost.com|http://web.a.ebscohost.${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|https://web.b.ebscohost.com|http://web.b.ebscohost.${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|http://search.ebscohost.com|http://search.ebscohost.${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|galegroup.com|gale.${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|search.proquest.com|search.proquest.${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|www.jstor.org|jstor-${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|repere.sdm.qc.ca|repere.sdm.${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|repere.sdm.qc.ca|repere.sdm.${SYSCODE}.orc.scoolaid.net|i"
	      Substitute "s|search.proquest.jac|search-proquest-${SYSCODE}|i"
	      Substitute "s|www.choicereviews.org|choicereviews.${SYSCODE}.orc.scoolaid.net|i"
        #Header set Access-Control-Allow-Origin "*"
        RequestHeader     unset   Accept-Encoding
    </Location>
    
    ProxyRequests Off

