    SSLEngine on
    SSLProxyEngine On
    SSLProtocol all
    
    Include conf.d/include/STAR_orc_scoolaid_net.inc
    
    SetEnv force-proxy-request-1.0 1
    SetEnv proxy-nokeepalive 1

    ProxyRequests On  
    ProxyAddHeaders On

    ProxyPass / https://search.ebscohost.com/
    ProxyPassReverse / https://search.ebscohost.com/
    #ProxyPassReverse /publications/ https://search.ebscohost.com/publications/


    ProxyPassReverse /ebsco_web/ http://web.ebscohost.com/
    ProxyPassReverse /ebsco_web-a/ http://web.a.ebscohost.com/
    ProxyPassReverse /web_a_ssl/ https://web.a.ebscohost.com/
    ProxyPassReverse /ebsco_web-b/ http://web.b.ebscohost.com/
    ProxyPassReverse /web_b_ssl/ https://web.b.ebscohost.com/
    ProxyPassReverse /ebsco_web-p/ http://web.p.ebscohost.com/
    ProxyPassReverse /web_p_ssl/ https://web.p.ebscohost.com/
    ProxyPassReverse /web_p_ssl/ https://web.s.ebscohost.com/
    ProxyPassReverse /flipster/ https://flipster.ebsco.com/

    ProxyPassReverse /ebsco_arrc/ http://arrc.ebscohost.com/
    ProxyPassReverse /ebsco_research/ https://research.ebsco.com/
    ProxyPassReverse /ebsco_research/ https://research.ebsco.com:443/
    ProxyPassReverse /logon_zone/ https://logon.ebsco.zone/api
    ProxyPassReverse /logon_zone/ https://logon.ebsco.zone/
    ProxyPassReverse /logon_zone/ https://logon.ebsco.zone:443/
    #ProxyPassReverse /ebsco_login/ https://login.ebsco.com/
    #ProxyPassReverse /ebsco_login/ https://login.ebsco.com/?
    ProxyPassReverse /publications/ https://publications.ebsco.com/
    
    ProxyPassReverse /ebsco_abc-clio/ http://databases.abc-clio.com/
    ProxyPassReverse /apimages/ http://www.apimages.com/
    ProxyPassReverse /ap_newsroom/ https://newsroom.ap.org
    ProxyPassReverse /ap_newsroom/ https://newsroom.ap.org/

    RewriteEngine on

    #Include conf.d/filter/orcFilter.inc

    ProxyPassReverseCookieDomain ebscohost.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain .ebscohost.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain search.ebscohost.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain .search.ebscohost.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain .ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain research.ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain .research.ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain logon.ebsco.zone .orc.scoolaid.net
    ProxyPassReverseCookieDomain .logon.ebsco.zone .orc.scoolaid.net
    ProxyPassReverseCookiePath / /
  
    Include conf.d/orc/vendor/inc/ebsco/search_orcDBId.inc

    #RewriteRule   ^/ebsco_web/(.*)  http://web.ebscohost.${SYSCODE}.orc.scoolaid.net/$1 
    #RewriteRule   ^/ebsco_web-a/(.*)  http://web.a.ebscohost.${SYSCODE}.orc.scoolaid.net/$1 
    RewriteRule   ^/web_a_ssl/(.*)  https://web-a-ebscohost-${SYSCODE}.orc.scoolaid.net/$1 
    #RewriteRule   ^/ebsco_web-b/(.*)  http://web.b.ebscohost.${SYSCODE}.orc.scoolaid.net/$1 
    RewriteRule   ^/web_b_ssl/(.*)  https://web-b-ebscohost-${SYSCODE}.orc.scoolaid.net/$1 
    RewriteRule   ^/ebsco_web-p/(.*)  http://web.p.ebscohost.${SYSCODE}.orc.scoolaid.net/$1 
    RewriteRule   ^/web_p_ssl/(.*)  https://web-p-ebscohost-${SYSCODE}.orc.scoolaid.net/$1 
    
    RewriteRule   ^/flipster/(.*)  https://flipster-ebsco-${SYSCODE}.orc.scoolaid.net/$1 
    
    #RewriteRule   ^/ebsco_arrc/(.*)  http://arrc.ebscohost.${SYSCODE}.orc.scoolaid.net/$1 [R]
    RewriteRule   ^/ebsco_research/(.*)  https://research-ebsco-${SYSCODE}.orc.scoolaid.net/$1 [NE,R]
    RewriteRule   ^/logon_zone/(.*)  https://logon-ebsco-zone-${SYSCODE}.orc.scoolaid.net/$1 [NE,R] 
    RewriteRule   ^/ebsco_login/(.*)  https://login-ebsco-${SYSCODE}.orc.scoolaid.net/$1 [NE,R]
    RewriteRule   ^/publications/(.*)  https://publications-ebsco-${SYSCODE}.orc.scoolaid.net/$1 [NE,P]
    #RewriteRule   ^/ebsco_research/(.*)  https://publications-ebsco-${SYSCODE}.orc.scoolaid.net/$1 [NE,R]
    
    RewriteRule   ^/ebsco_abc-clio/(.*)  http://databases.abc-clio.${SYSCODE}.orc.scoolaid.net/ 
    RewriteRule   ^/apimages/(.*)  http://apimages.${SYSCODE}.orc.scoolaid.net/ 
    RewriteRule   ^/ap_newsroom/(.*)  https://newsroom-ap-${syscode}.orc.scoolaid.net/$1 [NE] 


    <Location />
        SetOutputFilter    proxy-html
        AddOutputFilterByType SUBSTITUTE text/plain text/html application/json application/javascript application/xml application/xhtml
        Substitute "s|https://search.ebscohost.com|https://search-ebscohost-${SYSCODE}.orc.scoolaid.net|i"
        #RequestHeader     unset   Accept-Encoding
    </Location>

    ProxyRequests Off 
