    SetEnv force-proxy-request-1.0 1
    SetEnv proxy-nokeepalive 1

    ProxyPass / http://search.ebscohost.com/
    ProxyPassReverse / http://search.ebscohost.com
    ProxyPassReverse /ebsco_web/ http://web.ebscohost.com
    ProxyPassReverse /ebsco_web/ http://web.ebscohost.com/
    
    ProxyPassReverse /ebsco_web_a/ http://web.a.ebscohost.com
    ProxyPassReverse /ebsco_web_b/ http://web.b.ebscohost.com/
   
    ProxyPassReverse /ebsco_arrc/ http://arrc.ebscohost.com
    ProxyPassReverse /ebsco_arrc/ http://arrc.ebscohost.com/

    ProxyPassReverse /ebsco_abc-clio/ http://databases.abc-clio.com/

    #ProxyHTMLURLMap http://search.ebscohost.com /

    RewriteEngine on

    Include conf.d/filter/orcFilter.inc

    #RewriteCond %{SERVER_NAME}  \.([^\.]+)\.(orc\.scoolaid\.net)$ [NC]
	#RewriteRule ^/(.*)$ - [CO=orcSysCode:%1:%2:1440:/,E=SYSCODE:%1]

    ProxyPassInterpolateEnv on

    ProxyPassReverseCookieDomain .ebscohost.com .ebscohost.${SYSCODE}.orc.scoolaid.net  interpolate
    ProxyPassReverseCookiePath / /
    ProxyPassReverseCookieDomain search.ebscohost.com search.ebscohost.${SYSCODE}.orc.scoolaid.net  interpolate
    ProxyPassReverseCookiePath / /
    ProxyPassReverseCookieDomain .web.ebscohost.com .web.ebscohost.${SYSCODE}.orc.scoolaid.net  interpolate
    ProxyPassReverseCookiePath / /

    RewriteCond %{QUERY_STRING} site=apic
    Redirect ^/(.*) http://search.ebscohost.com/$1
    
    #  EBSCO -- EBSCO Animals
#       profile=web  - dbCode=ani - orcDbId=27

    #RewriteCond %{QUERY_STRING} profile=web
    #RewriteCond %{QUERY_STRING} defaultdb=ani
    #RewriteRule   ^/(.*) - [CO=orcDbId:27:.orc.scoolaid.net,CO=dbCode:ani:.orc.scoolaid.net,E=CURDBID:27]

#   EBSCO General Science Collection 
#       profile     =web
#       dbCode      =gsh
#       orcDbId    =28

    #RewriteCond %{QUERY_STRING} profile=web
    #RewriteCond %{QUERY_STRING} defaultdb=gsh
    #RewriteRule   ^/(.*) - [CO=orcDbId:28:.orc.scoolaid.net,CO=dbCode:gsh:.orc.scoolaid.net,E=CURDBID:28]

#  EBSCO -- EBSCOhost Web
#       profile     =ehostes
#       dbCode      = 
#       orcDbId    =29

    #RewriteCond %{QUERY_STRING} profile=ehost
    #RewriteRule   ^/(.*) - [CO=orcDbId:29:.orc.scoolaid.net,CO=dbCode:ehostes:.orc.scoolaid.net,E=CURDBID:29]
    

#  EBSCO -- ERIC (Educational Resources Information Center)
#       profile     = web
#       dbCode      = eric
#       orcDbId    = 30

    RewriteCond %{QUERY_STRING} profile=web
    RewriteCond %{QUERY_STRING} defaultdb=eric
    RewriteRule   ^/(.*) - [CO=orcDbId:30:.orc.scoolaid.net,CO=dbCode:eric:.orc.scoolaid.net,E=CURDBID:30]


#  EBSCO -- Kids Search
#       profile     =srck5
#       dbCode      =
#       orcDbId    =31

    #RewriteCond %{QUERY_STRING} profile=srck5
    #RewriteRule   ^/(.*) - [CO=orcDbId:31:.orc.scoolaid.net,CO=dbCode:srck5:.orc.scoolaid.net,E=CURDBID:31]

#   EBSCO MasterFile Select 
#       profile     =web
#       dbCode      =mfh
#       orcDbId    =32

    RewriteCond %{QUERY_STRING} profile=web
    RewriteCond %{QUERY_STRING} defaultdb=mfh
    RewriteRule   ^/(.*) - [CO=orcDbId:32:.orc.scoolaid.net,CO=dbCode:mfh:.orc.scoolaid.net,E=CURDBID:32]

#  EBSCO -- Primary Search
#       profile     = web
#       dbCode      = prh
#       orcDbId    = 33

    RewriteCond %{QUERY_STRING} profile=web
    RewriteCond %{QUERY_STRING} defaultdb=prh
    RewriteRule   ^/(.*) - [CO=orcDbId:33:.orc.scoolaid.net,CO=dbCode:prh:.orc.scoolaid.net,E=CURDBID:33]

#  EBSCO -- Science Reference Center
#       profile     = web
#       dbCode      = sch
#       orcDbId    = 34

    RewriteCond %{QUERY_STRING} profile=web
    RewriteCond %{QUERY_STRING} defaultdb=sch
    RewriteRule   ^/(.*) - [CO=orcDbId:34:.orc.scoolaid.net,CO=dbCode:sch:.orc.scoolaid.net,E=CURDBID:34]

#  EBSCO -- Searchasaurus
#       profile     = sas
#       orcDbId    = 35

    RewriteCond %{QUERY_STRING} profile=sas
    RewriteRule   ^/(.*) - [CO=orcDbId:35:.orc.scoolaid.net,CO=dbCode:sas:.orc.scoolaid.net,E=CURDBID:35]
  
#  EBSCO --  EBSCOhost Espanol
#       profile     = ehostes
#       dbCode      = tth
#       orcDbId    =36
   
    #RewriteCond %{QUERY_STRING} profile=ehostes
    #RewriteRule   ^/(.*) - [CO=orcDbId:36:.orc.scoolaid.net,CO=dbCode:ehostes_tth:.orc.scoolaid.net,E=CURDBID:36]
    ProxyHTMLDoctype "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\" >"  HTML

#  EBSCO -- Topic Search
#       profile     = web
#       dbCode      = tth
#       orcDbId    = 37

    RewriteCond %{QUERY_STRING} profile=web
    RewriteCond %{QUERY_STRING} defaultdb=tth
    RewriteRule   ^/(.*) - [CO=orcDbId:37:.orc.scoolaid.net,CO=dbCode:tth:.orc.scoolaid.net,E=CURDBID:37]

#  Wed, Nov 11, 2009 @ 09:10:19 EST 
#  Trial   
#  EBSCO -- ELL (English Language Learner Reference Center)
#       profile     = web
#       dbCode      = ?
#       orcDbId    = 69

    RewriteCond %{QUERY_STRING} profile=ell
    RewriteRule   ^/(.*) - [CO=orcDbId:69:.orc.scoolaid.net,CO=dbCode:ell:.orc.scoolaid.net,E=CURDBID:69]

# Wed, Sep 01, 2010 @ 15:55:33 EDT 
#     
#  novelist
#       profile     = web
#       dbCode      = ?
#       orcDbId    = 93

#    RewriteCond %{QUERY_STRING} profile=novelist
#    RewriteRule   ^/(.*) - [CO=orcDbId:93:.orc.scoolaid.net,CO=dbCode:novelist:.orc.scoolaid.net,E=CURDBID:93]

# Wed, Sep 01, 2010 @ 15:55:33 EDT 
#     
#  novelist K-8
#       profile     = web
#       dbCode      = nnh
#       orcDbId    = 94

#    RewriteCond %{QUERY_STRING} profile=novelistk8
#    RewriteRule   ^/(.*) - [CO=orcDbId:94:.orc.scoolaid.net,CO=dbCode:novelistk8:.orc.scoolaid.net,E=CURDBID:94]

#    RewriteCond %{QUERY_STRING} defaultdb=nnh
#    RewriteRule   ^/(.*) - [CO=orcDbId:94:.orc.scoolaid.net,CO=dbCode:nnh:.orc.scoolaid.net,E=CURDBID:94]

#Fri, Sep 09, 2011 @ 15:49:41 EDT
#Literary Reference Center
#       profile     = 
#       dbCode      = ?
#       orcDbId    = 125

    RewriteCond %{QUERY_STRING} defaultdb=lfh
    RewriteRule   ^/(.*) - [CO=orcDbId:125:.orc.scoolaid.net,CO=dbCode:lfh:.orc.scoolaid.net,E=CURDBID:125]

#Wed, Oct 05, 2011 @ 12:17:55 EDT

#Academic Search Complete
#       profile     = web
#       dbCode      = a9h
#       orcDbId    = 120
    RewriteCond %{QUERY_STRING} defaultdb=a9h
    RewriteRule   ^/(.*) - [CO=orcDbId:120:.orc.scoolaid.net,CO=dbCode:a9h:.orc.scoolaid.net,E=CURDBID:120]

#Thu, Oct 06, 2011 @ 16:15:57 EDT

#       profile     = web
#       dbCode      = c8h
#       orcDbId    = 119
    RewriteCond %{QUERY_STRING} defaultdb=c8h
    RewriteRule   ^/(.*) - [CO=orcDbId:119:.orc.scoolaid.net,CO=dbCode:c8h:.orc.scoolaid.net,E=CURDBID:119]

#History Reference Center
#       dbCode      = khh
#       orcDbId    = 130
    RewriteCond %{QUERY_STRING} defaultdb=khh
    RewriteRule   ^/(.*) - [CO=orcDbId:130:.orc.scoolaid.net,CO=dbCode:khh:.orc.scoolaid.net,E=CURDBID:130]

    RewriteCond %{QUERY_STRING} profile=hrc
    RewriteRule   ^/(.*) - [CO=orcDbId:130:.orc.scoolaid.net,CO=dbCode:hrc:.orc.scoolaid.net,E=CURDBID:130]

#Novelist K-8 Plus
#profile=novpk8
    RewriteCond %{QUERY_STRING} profile=novpk8
    RewriteRule   ^/(.*) - [CO=orcDbId:132:.orc.scoolaid.net,CO=dbCode:novpk8:.orc.scoolaid.net,E=CURDBID:132]

#MAS Ultra -- School Edition
#       profile     = web
#       dbCode      = ulh
#       orcDbId    = 133
    RewriteCond %{QUERY_STRING} defaultdb=ulh
    RewriteRule   ^/(.*) - [CO=orcDbId:133:.orc.scoolaid.net,CO=dbCode:ulh:.orc.scoolaid.net,E=CURDBID:133]

#MagillOnLiterature Plus
#       profile     = web
#       dbCode      = mjh
#       orcDbId    = 134
    RewriteCond %{QUERY_STRING} defaultdb=mjh
    RewriteRule   ^/(.*) - [CO=orcDbId:134:.orc.scoolaid.net,CO=dbCode:mjh:.orc.scoolaid.net,E=CURDBID:134]

#       profile     = web
#       dbCode      = tfh
#       orcDbId    = 208
    RewriteCond %{QUERY_STRING} defaultdb=tfh
    RewriteRule   ^/(.*) - [CO=orcDbId:208:.orc.scoolaid.net,CO=dbCode:tfh:.orc.scoolaid.net,E=CURDBID:208]

#MagillOnLiterature
#       profile     = web
#       dbCode      = mOh
#       orcDbId    = 212
    RewriteCond %{QUERY_STRING} defaultdb=m0h
    RewriteRule   ^/(.*) - [CO=orcDbId:212:.orc.scoolaid.net,CO=dbCode:m0h:.orc.scoolaid.net,E=CURDBID:212]

#PsycARTICLES
#       profile     = psy
#       dbCode      = pdh
#       orcDbId    = 216
    RewriteCond %{QUERY_STRING} defaultdb=pdh
    RewriteRule   ^/(.*) - [CO=orcDbId:216:.orc.scoolaid.net,CO=dbCode:pdh:.orc.scoolaid.net,E=CURDBID:216]

#MagillOnLiterature
#       profile     = web
#       dbCode      = mih
#       orcDbId    = 223
    RewriteCond %{QUERY_STRING} defaultdb=mih
    RewriteRule   ^/(.*) - [CO=orcDbId:223:.orc.scoolaid.net,CO=dbCode:mih:.orc.scoolaid.net,E=CURDBID:223]

#GreenFILE
#       profile     = ehost
#       dbCode      = 8gh
#       orcDbId    = 231
    RewriteCond %{QUERY_STRING} defaultdb=8gh
    RewriteRule   ^/(.*) - [CO=orcDbId:231:.orc.scoolaid.net,CO=dbCode:8gh:.orc.scoolaid.net,E=CURDBID:231]

#Library, Infomation Science & Technology Abstracts
#       profile     = ehost
#       dbCode      = lxh
#       orcDbId    = 232
    RewriteCond %{QUERY_STRING} defaultdb=lxh
    RewriteRule   ^/(.*) - [CO=orcDbId:232:.orc.scoolaid.net,CO=dbCode:lxh:.orc.scoolaid.net,E=CURDBID:232]


# OmniFILE Full Text Select (H.W. Wilson)
#       profile     = ehost
#       dbCode      = ofs
#       orcDbId    = 233
    RewriteCond %{QUERY_STRING} defaultdb=ofs
    RewriteRule   ^/(.*) - [CO=orcDbId:233:.orc.scoolaid.net,CO=dbCode:ofs:.orc.scoolaid.net,E=CURDBID:233]

#Wed, Mar 07, 2012 @ 12:00:25 EST
# Art Museum Image Gallery (H.W. Wilson)
    RewriteCond %{QUERY_STRING} defaultdb=ami
    RewriteRule   ^/(.*) - [CO=orcDbId:40:.orc.scoolaid.net,CO=dbCode:ami:.orc.scoolaid.net,E=CURDBID:40]

# Biography Reference Bank (H.W. Wilson)
    RewriteCond %{QUERY_STRING} defaultdb=brb
    RewriteRule   ^/(.*) - [CO=orcDbId:229:.orc.scoolaid.net,CO=dbCode:brb:.orc.scoolaid.net,E=CURDBID:229]

#Thu, Mar 08, 2012 @ 15:23:46 EST
#Children's Core Collection
    RewriteCond %{QUERY_STRING} defaultdb=ccx
    RewriteRule   ^/(.*) - [CO=orcDbId:192:.orc.scoolaid.net,CO=dbCode:ccx:.orc.scoolaid.net,E=CURDBID:192]

#Graphic Novels Core Collection
    RewriteCond %{QUERY_STRING} defaultdb=gnx
    RewriteRule   ^/(.*) - [CO=orcDbId:195:.orc.scoolaid.net,CO=dbCode:gnx:.orc.scoolaid.net,E=CURDBID:195]

#Middle & Junior High Core Collection
    RewriteCond %{QUERY_STRING} defaultdb=mjx
    RewriteRule   ^/(.*) - [CO=orcDbId:193:.orc.scoolaid.net,CO=dbCode:mjx:.orc.scoolaid.net,E=CURDBID:193]

#Senior High Core Collection
    RewriteCond %{QUERY_STRING} defaultdb=shx
    RewriteRule   ^/(.*) - [CO=orcDbId:194:.orc.scoolaid.net,CO=dbCode:shx:.orc.scoolaid.net,E=CURDBID:194]

#Ultra Online Package
    RewriteCond %{QUERY_STRING} profile=uop-host
    RewriteRule   ^/(.*) - [CO=orcDbId:236:.orc.scoolaid.net,CO=uop-host::.orc.scoolaid.net,E=CURDBID:236]

#Readers' Guide Full Text Mega (H.W. Wilson)
    RewriteCond %{QUERY_STRING} defaultdb=rgm
    RewriteRule   ^/(.*) - [CO=orcDbId:239:.orc.scoolaid.net,CO=dbCode:rgm:.orc.scoolaid.net,E=CURDBID:239]

#Wed, Apr 04, 2012 @ 13:58:32 EDT

#MasterFile Premier
    RewriteCond %{QUERY_STRING} defaultdb=f5h
    RewriteRule   ^/(.*) - [CO=orcDbId:266:.orc.scoolaid.net,CO=dbCode:f5h:.orc.scoolaid.net,E=CURDBID:266]

#Thu, Apr 12, 2012 @ 10:44:09 EDT
#Health Source : Consumer Edition.
    RewriteCond %{QUERY_STRING} defaultdb=hxh
    RewriteRule   ^/(.*) - [CO=orcDbId:270:.orc.scoolaid.net,CO=dbCode:hxh:.orc.scoolaid.net,E=CURDBID:270]

#Newspaper Source
    RewriteCond %{QUERY_STRING} defaultdb=nfh
    RewriteRule   ^/(.*) - [CO=orcDbId:271:.orc.scoolaid.net,CO=dbCode:nfh:.orc.scoolaid.net,E=CURDBID:271]
#Biography Reference Center
    RewriteCond %{QUERY_STRING} defaultdb=brc
    RewriteRule   ^/(.*) - [CO=orcDbId:274:.orc.scoolaid.net,CO=dbCode:brc:.orc.scoolaid.net,E=CURDBID:274]

#Thu, Jul 19, 2012 @ 13:50:30 EDT
#Current Bio Illustrated
    RewriteCond %{QUERY_STRING} defaultdb=cbi
    RewriteRule   ^/(.*) - [CO=orcDbId:278:.orc.scoolaid.net,CO=dbCode:cbi:.orc.scoolaid.net,E=CURDBID:278]

#Wed, Oct 03, 2012 @ 11:14:52 EDT
#Funk & Wallnalls New World Encyclopedia
    RewriteCond %{QUERY_STRING} defaultdb=funk
    RewriteRule   ^/(.*) - [CO=orcDbId:308:.orc.scoolaid.net,CO=dbCode:funk:.orc.scoolaid.net,E=CURDBID:308]

#Teacher Reference Center
    RewriteCond %{QUERY_STRING} defaultdb=trh
    RewriteRule   ^/(.*) - [CO=orcDbId:309:.orc.scoolaid.net,CO=dbCode:trh:.orc.scoolaid.net,E=CURDBID:309]

#Advanced Placement Source
    RewriteCond %{QUERY_STRING} defaultdb=aqh
    RewriteRule   ^/(.*) - [CO=orcDbId:310:.orc.scoolaid.net,CO=dbCode:aqh:.orc.scoolaid.net,E=CURDBID:310]

#Book Collection:Nonfiction
    RewriteCond %{QUERY_STRING} defaultdb=ndh
    RewriteRule   ^/(.*) - [CO=orcDbId:311:.orc.scoolaid.net,CO=dbCode:ndh:.orc.scoolaid.net,E=CURDBID:311]

#Book Collection:Nonfiction:High School Edition
    RewriteCond %{QUERY_STRING} defaultdb=n9h
    RewriteRule   ^/(.*) - [CO=orcDbId:416:.orc.scoolaid.net,CO=dbCode:n9h:.orc.scoolaid.net,E=CURDBID:416]

#Student Research Center
    RewriteCond %{QUERY_STRING} profile=src
    RewriteRule   ^/(.*) - [CO=orcDbId:312:.orc.scoolaid.net,CO=dbCode:src:.orc.scoolaid.net,E=CURDBID:312]

#Mon, Oct 29, 2012 @ 15:55:02 EDT
#Literary Reference Center Plus
RewriteCond %{QUERY_STRING} defaultdb=lkh
    RewriteRule   ^/(.*) - [CO=orcDbId:320:.orc.scoolaid.net,CO=dbCode:lkh:.orc.scoolaid.net,E=CURDBID:320]

#Fri, Nov 16, 2012 @ 15:31:00 EST
#Small Engine Repair Reference Center
    RewriteCond %{QUERY_STRING} profile=serrc
    RewriteCond %{QUERY_STRING} defaultdb=s9h
    RewriteRule   ^/(.*) - [CO=orcDbId:323:.orc.scoolaid.net,CO=dbCode:s9h:.orc.scoolaid.net,E=CURDBID:323]

#Mon, Nov 19, 2012 @ 14:32:58 EST
#Newspaper Source Plus
    RewriteCond %{QUERY_STRING} defaultdb=n5h
    RewriteRule   ^/(.*) - [CO=orcDbId:332:.orc.scoolaid.net,CO=dbCode:n5h:.orc.scoolaid.net,E=CURDBID:332]
#Wed, May 13, 2015 @ 15:28:30 EDT
#Humanities Source
    RewriteCond %{QUERY_STRING} defaultdb=hmn
    RewriteRule   ^/(.*) - [CO=orcDbId:444:.orc.scoolaid.net,CO=dbCode:hmn:.orc.scoolaid.net,E=CURDBID:444]
#Thu, Jul 23, 2015 @ 15:55:10 EDT
    RewriteCond %{QUERY_STRING} profile=chc
    RewriteRule   ^/(.*) - [CO=orcDbId:448:.orc.scoolaid.net,CO=dbCode:chc:.orc.scoolaid.net,E=CURDBID:448]
#Wed, Dec 16, 2015 @ 14:56:37 EST
    RewriteCond %{QUERY_STRING} profile=pfi
    RewriteRule   ^/(.*) - [CO=orcDbId:484:.orc.scoolaid.net,CO=dbCode:pfi:.orc.scoolaid.net,E=CURDBID:484]
###############################################################################

    RewriteCond %{SERVER_NAME}  ^(.+)\.(.+)\.(orc.scoolaid.net)$ [NC]
    RewriteRule   ^/ebsco_web/(.*)  http://web.ebscohost.%2.orc.scoolaid.net/$1 [P]

    RewriteCond %{SERVER_NAME}  ^(.+)\.(.+)\.(orc.scoolaid.net)$ [NC]
    RewriteRule   ^/ebsco_web_a/(.*)  http://web.a.ebscohost.%2.orc.scoolaid.net/$1 [R]

    RewriteCond %{SERVER_NAME}  ^(.+)\.(.+)\.(orc.scoolaid.net)$ [NC]
    RewriteRule   ^/ebsco_web_b/(.*)  http://web.b.ebscohost.%2.orc.scoolaid.net/$1 [R]

    RewriteCond %{SERVER_NAME}  ^(.+)\.(.+)\.(orc.scoolaid.net)$ [NC]
    RewriteRule   ^/ebsco_arrc/(.*)  http://arrc.ebscohost.%2.orc.scoolaid.net/$1 [R]

    RewriteCond %{SERVER_NAME}  ^(.+)\.(.+)\.(orc.scoolaid.net)$ [NC]
    RewriteRule   ^/ebsco_abc-clio/(.*)  http://databases.abc-clio.%2.orc.scoolaid.net/ [P]



 #   RewriteCond %{ENV:CURDBID} ^$
    RewriteCond %{HTTP_COOKIE} orcDbId=([0-9]+) 
    RewriteRule  .* - [E=CURDBID:%1]

    <Location />
        ProxyHTMLInterp On
        ProxyPassReverse /
        SetOutputFilter    proxy-html
        ProxyHTMLURLMap http://www.ebscohost.com http://search.ebscohost.${SYSCODE}.orc.scoolaid.net [V]
        ProxyHTMLURLMap http://www.ebsco.com http://search.ebscohost.${SYSCODE}.orc.scoolaid.net [V]
        ProxyHTMLURLMap http://search.ebscohost.com http://search.ebscohost.${SYSCODE}.orc.scoolaid.net [V]
        ProxyHTMLURLMap http://web.ebscohost.com http://web.ebscohost.${SYSCODE}.orc.scoolaid.net [V]
        ProxyHTMLURLMap http://web.ebscohost.com/ http:/web.ebscohost.${SYSCODE}.orc.scoolaid.net/ [V]
        RequestHeader     unset   Accept-Encoding
    </Location>
    ProxyRequests Off 
