    SetEnv force-proxy-request-1.0 1
    SetEnv proxy-nokeepalive 1

    ProxyPass / http://search.ebscohost.com/
    ProxyPassReverse / http://search.ebscohost.com/
    
    ProxyPassReverse /search_ssl/ https://search.ebscohost.com/
    ProxyPassReverse /ebsco_web/ http://web.ebscohost.com/
    ProxyPassReverse /ebsco_web-a/ http://web.a.ebscohost.com/
    ProxyPassReverse /web_a_ssl/ https://web.a.ebscohost.com/
    ProxyPassReverse /ebsco_web-b/ http://web.b.ebscohost.com/
    ProxyPassReverse /web_b_ssl/ https://web.b.ebscohost.com/
    ProxyPassReverse /ebsco_arrc/ http://arrc.ebscohost.com/
    ProxyPassReverse /ebsco_abc-clio/ http://databases.abc-clio.com/
    ProxyPassReverse /apimages/ http://www.apimages.com/
    ProxyPassReverse /ebsco_ds-a/ http://eds.a.ebscohost.com/
    ProxyPassReverse /ebsco_ds-b/ http://eds.b.ebscohost.com/
    ProxyPassReverse /ap_newsroom/ https://newsroom.ap.org
    ProxyPassReverse /ap_newsroom/ https://newsroom.ap.org/

    RewriteEngine on

    Include conf.d/filter/orcFilter.inc

    ProxyPassReverseCookieDomain ebscohost.com ebscohost.${SYSCODE}.orc.scoolaid.net
    ProxyPassReverseCookieDomain .ebscohost.com .ebscohost.${SYSCODE}.orc.scoolaid.net
    ProxyPassReverseCookieDomain search.ebscohost.com search.ebscohost.${SYSCODE}.orc.scoolaid.net
    ProxyPassReverseCookiePath / /

    #RewriteRule   ^/(.*) - [CO=orcDbId:657:.orc.scoolaid.net,E=CURDBID:657]
    Include conf.d/orc/vendor/inc/ebsco/search_orcDBId.inc

    RewriteRule   ^/search_ssl/(.*)  https://search-ebscohost-${SYSCODE}.orc.scoolaid.net/$1 
    RewriteRule   ^/ebsco_web/(.*)  http://web.ebscohost.${SYSCODE}.orc.scoolaid.net/$1 
    RewriteRule   ^/ebsco_web-a/(.*)  http://web.a.ebscohost.${SYSCODE}.orc.scoolaid.net/$1 
    RewriteRule   ^/web_a_ssl/(.*)  https://web-a-ebscohost-${SYSCODE}.orc.scoolaid.net/$1 
    RewriteRule   ^/ebsco_web-b/(.*)  http://web.b.ebscohost.${SYSCODE}.orc.scoolaid.net/$1 
    RewriteRule   ^/web_b_ssl/(.*)  https://web-b-ebscohost-${SYSCODE}.orc.scoolaid.net/$1 
    
    RewriteRule   ^/ebsco_arrc/(.*)  http://arrc.ebscohost.${SYSCODE}.orc.scoolaid.net/$1 [R]
    RewriteRule   ^/ebsco_abc-clio/(.*)  http://databases.abc-clio.%2.orc.scoolaid.net/ [P]
    RewriteRule   ^/apimages/(.*)  http://apimages.${SYSCODE}.orc.scoolaid.net/ 
    RewriteRule   ^/ebsco_ds-a/(.*)  http://eds.a.ebscohost.${SYSCODE}.orc.scoolaid.net/$1 
    RewriteRule   ^/ebsco_ds-b/(.*)  http://eds.b.ebscohost.${SYSCODE}.orc.scoolaid.net/$1 
    
    RewriteRule   ^/ap_newsroom/(.*)  https://newsroom-ap-${syscode}.orc.scoolaid.net/$1 [NE] 

    <Location />
        AddOutputFilterByType SUBSTITUTE text/plain text/html application/json application/javascript application/xml application/xhtml
        Substitute "s|window.location.replace|//window.location.replace|i"
        Substitute "s|https://newsroom.ap.org|https://newsroom-ap-${SYSCODE}.orc.scoolaid.net|i"
        RequestHeader     unset   Accept-Encoding
    </Location>

    ProxyRequests Off 
