    SSLEngine on
    SSLProxyEngine On
    SSLProtocol all
    
    Include conf.d/include/STAR_orc_scoolaid_net.inc
    
    SetEnv force-proxy-request-1.0 1
    SetEnv proxy-nokeepalive 1

    ProxyPass / https://research.ebsco.com/
    ProxyPassReverse / https://research.ebsco.com/
    
    ProxyPassReverse /logon_zone/ https://logon.ebsco.zone/
    ProxyPassReverse /logon_zone/ https://logon.ebsco.zone:443/
    ProxyPassReverse /publications/ https://publications.ebsco.com/
    ProxyPassReverse /ebsco_origin/ https://origin-research.ebsco.com/
   
    ProxyPassReverse /noodletools/ https://my.noodletools.com/
    ProxyPassReverse /openurl/ https://openurl.ebsco.com/
    RewriteEngine on
    

    Include conf.d/filter/orcFilter.inc

    ProxyPassReverseCookieDomain ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain .ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain research.ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain .research.ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookiePath / /
  
    Include conf.d/orc/vendor/inc/ebsco/search_orcDBId.inc

    RewriteRule   ^/logon_zone/(.*)  https://logon-ebsco-zone-${SYSCODE}.orc.scoolaid.net/$1 
    RewriteRule   ^/publications/(.*)  https://publications-ebsco-${SYSCODE}.orc.scoolaid.net/$1 [NE,P]
    RewriteRule   ^/ebsco_origin/(.*)  https://origin-research-ebsco-${SYSCODE}.orc.scoolaid.net/$1 [L] 
    
    RewriteRule   ^/noodletools/(.*)  https://my-noodletools-${SYSCODE}.orc.scoolaid.net/$1 
    RewriteRule   ^/openurl/(.*)  https://openurl-ebsco-${SYSCODE}.orc.scoolaid.net/$1 
    
    RewriteCond %{QUERY_STRING} (dbId)=(.*)
    RewriteRule   ^/(.*) - [CO=orcDbId:%2:.orc.scoolaid.net,CO=dbCode:%2:.orc.scoolaid.net,E=CURDBID:%2]
    
    Header set Access-Control-Allow-Origin "*.ebsco.com" env=cors
    Header set Access-Control-Allow-Origin "*.ebscohost.com" env=cors
    
    <Location />
        AddOutputFilterByType DEFLATE application/json 
        #SetOutputFilter INFLATE;DEFLATE
        #SubstituteMaxLineLength 50M
        #AddOutputFilterByType SUBSTITUTE text/plain text/html application/json application/javascript application/xml application/xhtml
        Substitute "s|search.ebscohost.com|search-ebsco-${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|research.ebsco.com|research-ebsco-${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|https://publications.ebsco.com|https://publications-ebsco-${SYSCODE}.orc.scoolaid.net|i"
        RequestHeader     unset   Accept-Encoding
    </Location>

    ProxyRequests Off 
