    SSLEngine on
    SSLProxyEngine On
    SSLProtocol all
    
    Include conf.d/include/STAR_orc_scoolaid_net.inc
    
    SetEnv force-proxy-request-1.0 1
    SetEnv proxy-nokeepalive 1
    
    ProxyPreserveHost Off
    #RequestHeader set Host "https://publications-ebsco-hcl50.orc.scoolaid.net"

    ProxyPass / https://publications.ebsco.com/
    ProxyPass / https://publications.ebsco.com:443/
    ProxyPass / https://publications.ebsco.com/callback
    ProxyPassReverse / https://publications.ebsco.com/
    ProxyPassReverse / https://publications.ebsco.com:443/
    ProxyPassReverse / https://publications.ebsco.com/callback
    
    ProxyPassReverse /logon_zone/ https://logon.ebsco.zone/api/
    ProxyPassReverse /logon_zone/ https://logon.ebsco.zone/
    ProxyPassReverse /logon_zone/ https://logon.ebsco.zone:443/
    ProxyPassReverse /ebsco_origin/ https://origin-research.ebsco.com/
    ProxyPassReverse /ebsco_search/ https://search.ebscohost.com
    ProxyPassReverse /ebsco_search/ https://search.ebscohost.com/
    ProxyPassReverse /ebsco_research/ https://research.ebsco.com/
   
    #ProxyPassReverse /noodletools/ https://my.noodletools.com/
    #ProxyPassReverse /jstor/ https://www.jstor.org/
    RewriteEngine on
    

    #Include conf.d/filter/orcFilter.inc

    #ProxyPassReverseCookieDomain ebsco.com .orc.scoolaid.net
    #ProxyPassReverseCookieDomain .ebsco.com .orc.scoolaid.net
    #ProxyPassReverseCookieDomain research.ebsco.com .orc.scoolaid.net
    #ProxyPassReverseCookieDomain .research.ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain logon.ebsco.zone .orc.scoolaid.net
    ProxyPassReverseCookieDomain .logon.ebsco.zone .orc.scoolaid.net
    ProxyPassReverseCookiePath / /
    ProxyPassReverseCookieDomain publications.ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain .publications.ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookiePath / /
  
    Include conf.d/orc/vendor/inc/ebsco/search_orcDBId.inc

    RewriteRule   ^/logon_zone/(.*)  https://logon-ebsco-zone-${SYSCODE}.orc.scoolaid.net/$1 [NE,P,R]
    RewriteRule   ^/ebsco_origin/(.*)  https://origin-research-ebsco-${SYSCODE}.orc.scoolaid.net/$1 [L] 
    RewriteRule   ^/ebsco_search/(.*)  https://search-ebscohost-${SYSCODE}.orc.scoolaid.net/$1 [NE,P] 
    RewriteRule   ^/ebsco_research/(.*)  https://research-ebsco-${SYSCODE}.orc.scoolaid.net/$1 [NE,P] 
    
    RewriteRule   ^/noodletools/(.*)  https://my-noodletools-${SYSCODE}.orc.scoolaid.net/$1 
    RewriteRule   ^/jstor/(.*)  https://jstor-${SYSCODE}.orc.scoolaid.net/$1 
    
    #RewriteCond %{QUERY_STRING} (profileid)=(pfui)
    RewriteCond %{QUERY_STRING} (redirect_uri)=''
   

    #Header set Access-Control-Allow-Origin "*.ebsco.com" env=cors
    #Header set Access-Control-Allow-Origin "https://publications-ebsco-hcl50.orc.scoolaid.net"
    #Header set Access-Control-Allow-Origin "*.ebscohost.com" env=cors
    
    <Location />
        SetOutputFilter    proxy-html
        #AddOutputFilterByType DEFLATE application/json 
        #SetOutputFilter INFLATE;DEFLATE
        #SubstituteMaxLineLength 50M
        AddOutputFilterByType SUBSTITUTE text/plain text/html application/json application/javascript application/xml application/xhtml
        #Substitute "s|https://search.ebscohost.com|https://search-ebscohost-${SYSCODE}.orc.scoolaid.net|i"
        #Substitute "s|publications.ebsco.com|publications-ebsco-${SYSCODE}.orc.scoolaid.net|i"
        #Substitute "s|https://research.ebsco.com|https://research-ebsco-${SYSCODE}.orc.scoolaid.net|i"
        #RequestHeader     unset   Accept-Encoding
    </Location>
    
    ProxyRequests Off 
