    SSLEngine on
    SSLProxyEngine On
    SSLProtocol all
    
    Include conf.d/include/STAR_orc_scoolaid_net.inc
    
    SetEnv force-proxy-request-1.0 1
    SetEnv proxy-nokeepalive 1

    ProxyPass / https://openurl.ebsco.com/
    ProxyPassReverse / https://openurl.ebsco.com/
    
    ProxyPassReverse /logon_zone/ https://logon.ebsco.zone/
    ProxyPassReverse /research/ https://research.ebsco.com/
    RewriteEngine on

    Include conf.d/filter/orcFilter.inc

    ProxyPassReverseCookieDomain ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain .ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain research.ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain .research.ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookiePath / /
  
    RewriteRule   ^/logon_zone/(.*)  https://logon-ebsco-zone-${SYSCODE}.orc.scoolaid.net/$1 
    RewriteRule   ^/research/(.*)  https://research-ebsco-${SYSCODE}.orc.scoolaid.net/$1 
    Include conf.d/orc/vendor/inc/ebsco/search_orcDBId.inc
    
    RewriteCond %{QUERY_STRING} (dbId)=(.*)
    RewriteRule   ^/(.*) - [CO=orcDbId:%2:.orc.scoolaid.net,CO=dbCode:%2:.orc.scoolaid.net,E=CURDBID:%2]
