    SSLEngine on
    SSLProxyEngine On
    SSLProtocol all
    
    Include conf.d/include/STAR_orc_scoolaid_net.inc
    
    SetEnv force-proxy-request-1.0 1
    SetEnv proxy-nokeepalive 1

    ProxyPass / https://logon.ebsco.zone/
    ProxyPassReverse / https://logon.ebsco.zone/
    
    NoProxy "origin-research.ebsco.com" 
    ProxyPassReverse /login/ https://login.ebsco.com/
    ProxyPassReverse /origin/ https://origin-research.ebsco.com/
    ProxyPassReverse /search/ https://search.ebscohost.com/
   
    RewriteEngine on

    #Include conf.d/filter/orcFilter.inc

    NoProxy "origin-research.ebsco.com" 
    RewriteRule   ^/login/(.*)  https://login-ebsco-${SYSCODE}.orc.scoolaid.net/$1 
    RewriteRule   ^/origin/(.*)  https://research-ebsco-${SYSCODE}.orc.scoolaid.net/$1 
    RewriteRule   ^/search/(.*)  https://search-ebscohost-${SYSCODE}.orc.scoolaid.net/$1 

    ProxyPassReverseCookieDomain ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain .ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain ebsco.zone .orc.scoolaid.net
    ProxyPassReverseCookieDomain .ebsco.zone .orc.scoolaid.net
    ProxyPassReverseCookieDomain logon.ebsco.zone .orc.scoolaid.net
    ProxyPassReverseCookiePath / /
  
    #Include conf.d/orc/vendor/inc/ebsco/search_orcDBId.inc

    <Location />
        AddOutputFilterByType SUBSTITUTE text/plain text/html application/json application/javascript application/xml application/xhtml
        #Substitute "s|window.location.replace|//window.location.replace|i"
        #Substitute "s|https://newsroom.ap.org|https://newsroom-ap-${SYSCODE}.orc.scoolaid.net|i"
        RequestHeader     unset   Accept-Encoding
    </Location>

    ProxyRequests Off 
