    SSLEngine on
    SSLProxyEngine On
    SSLProtocol all
    
    Include conf.d/include/STAR_orc_scoolaid_net.inc
    
    SetEnv force-proxy-request-1.0 1
    SetEnv proxy-nokeepalive 1

    ProxyRequests On  
    ProxyAddHeaders On

    ProxyPass / https://logon.ebsco.zone/
    ProxyPass / https://logon.ebsco.zone:443/
    ProxyPassReverse / https://logon.ebsco.zone/
    ProxyPassReverse / https://logon.ebsco.zone:443/
    NoProxy "https://login.ebsco.com"
    
    #ProxyPassReverse /publications/ https://publications.ebsco.com/
    
    #NoProxy "https://search.ebscohost.com/callback"
    #NoProxy "https://logon.ebsco.zone/api/dispatcher/oath/authorize"

    ProxyPassReverse /openurl/ https://openurl.ebsco.com/
    
    #ProxyPassReverse /ebsco_login/ https://login.ebsco.com/
    ProxyPassReverse /ebsco_search/ https://search.ebscohost.com
    ProxyPassReverse /ebsco_search/ https://search.ebscohost.com/
    ProxyPassReverse /ebsco_research/ https://research.ebsco.com/
    ProxyPassReverse /ebsco_research/ https://research.ebsco.com:443/
    ProxyPassReverse /ebsco_origin/ https://origin-research.ebsco.com/
   
    RewriteEngine on

    #Include conf.d/filter/orcFilter.inc

    #RewriteRule   ^/ebsco_login/(.*)  https://login-ebsco-${SYSCODE}.orc.scoolaid.net/$1 [NE,R]
    #RewriteRule   ^/ebsco_login/(.*)  https://login.ebsco.com/$1&test=khanh [NE,R]
    RewriteRule   ^/ebsco_search/(.*)  https://search-ebscohost-${SYSCODE}.orc.scoolaid.net/$1 [NE,R] 
    RewriteRule   ^/ebsco_research/(.*)  https://research-ebsco-${SYSCODE}.orc.scoolaid.net/$1 [L] 
    RewriteRule   ^/ebsco_origin/(.*)  https://origin-research-ebsco-${SYSCODE}.orc.scoolaid.net/$1 [L] 
    RewriteRule   ^/publications/(.*)  https://publications-ebsco-${SYSCODE}.orc.scoolaid.net/$1 [NE,P]
    RewriteRule   ^/openurl/(.*)  https://openurl-ebsco-${SYSCODE}.orc.scoolaid.net/$1 
    

    ProxyPassReverseCookieDomain ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain .ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain ebsco.zone .orc.scoolaid.net
    ProxyPassReverseCookieDomain .ebsco.zone .orc.scoolaid.net
    ProxyPassReverseCookieDomain logon.ebsco.zone .orc.scoolaid.net
    ProxyPassReverseCookieDomain .logon.ebsco.zone .orc.scoolaid.net
    #ProxyPassReverseCookieDomain publications.ebsco.com .orc.scoolaid.net
    #ProxyPassReverseCookieDomain .publications.ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookiePath / /
    #Header always set Content-Security-Policy-Report-Only "default-src 'self' login-ebsco-ou.orc.scoolaid.net"
  

    #Include conf.d/orc/vendor/inc/ebsco/search_orcDBId.inc
    <Location />
        #SetOutputFilter    proxy-html
        AddOutputFilterByType SUBSTITUTE text/plain text/html application/json application/javascript application/xml application/xhtml
        SetOutputFilter INFLATE;DEFLATE
        SubstituteMaxLineLength 50M
        Substitute "s|https://search.ebscohost.com|https://search-ebscohost-${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|publications.ebsco.com|publications-ebsco-${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|https://research.ebsco.com|https://research-ebsco-${SYSCODE}.orc.scoolaid.net|i"
        Header set Access-Control-Allow-Origin "*"
        #RequestHeader     unset   Accept-Encoding
    </Location>

    ProxyRequests Off 
