    SSLEngine on
    SSLProxyEngine On
    SSLProtocol all
    
    Include conf.d/include/STAR_orc_scoolaid_net.inc
    
    SetEnv force-proxy-request-1.0 1
    SetEnv proxy-nokeepalive 1

    ProxyPass / https://login.ebsco.com/
    ProxyPassReverse / https://login.ebsco.com/
    
   
    ProxyPassReverse /logon_zone/ https://logon.ebsco.zone/
    #ProxyPassReverse /logon_zone/ https://logon.ebsco.zone:443/
    ProxyPassReverse /ebsco_origin/ https://origin-research.ebsco.com/
    ProxyPassReverse /ebsco_search/ https://search.ebscohost.com/
    ProxyPassReverse /ebsco_search/ https://search.ebscohost.com
    ProxyPassReverse /ebsco_research/ https://research.ebsco.com/
    
    RewriteEngine on

    #Include conf.d/filter/orcFilter.inc

    ProxyPassReverseCookieDomain ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain .ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain login.ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain .login.ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain ebsco.zone .orc.scoolaid.net
    ProxyPassReverseCookieDomain .ebsco.zone .orc.scoolaid.net
    ProxyPassReverseCookieDomain logon.ebsco.zone .orc.scoolaid.net
    ProxyPassReverseCookiePath / /
  
    #Include conf.d/orc/vendor/inc/ebsco/search_orcDBId.inc

    RewriteRule   ^/logon_zone/(.*)  https://logon-ebsco-zone-${SYSCODE}.orc.scoolaid.net/$1 [NE,P,R]
    RewriteRule   ^/ebsco_origin/(.*)  https://origin-research-ebsco-${SYSCODE}.orc.scoolaid.net/$1 [L] 
    RewriteRule   ^/ebsco_search/(.*)  https://search-ebscohost-${SYSCODE}.orc.scoolaid.net/$1 [NE,P] 
    RewriteRule   ^/ebsco_research/(.*)  https://research-ebsco-${SYSCODE}.orc.scoolaid.net/$1 [L] 
    <Location />
        SetOutputFilter    proxy-html
        AddOutputFilterByType SUBSTITUTE text/plain text/html application/json application/javascript application/xml application/xhtml
        Substitute "s|https://search.ebscohost.com|https://search-ebscohost-${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|https://lgoin.ebsco.com|https://login-ebsco-${SYSCODE}.orc.scoolaid.net|i"
        Header set Access-Control-Allow-Origin "*"
        RequestHeader     unset   Accept-Encoding
    </Location>

    ProxyRequests Off 
