    SSLEngine on
    SSLProxyEngine On
    SSLProtocol all
    
    Include conf.d/include/STAR_orc_scoolaid_net.inc
    
    SetEnv force-proxy-request-1.0 1
    SetEnv proxy-nokeepalive 1

    ProxyPass / https://flipster.ebsco.com/
    ProxyPassReverse / https://flipster.ebsco.com/
    
    ProxyPassReverse /logon_zone/ https://logon.ebsco.zone/api/
    ProxyPassReverse /logon_zone/ https://logon.ebsco.zone
    ProxyPassReverse /logon_zone/ https://logon.ebsco.zone/
    ProxyPassReverse /logon_zone/ https://logon.ebsco.zone:443
    ProxyPassReverse /logon_zone/ https://logon.ebsco.zone:443/
    ProxyPassReverse /ebsco_search/ https://search.ebscohost.com?
    ProxyPassReverse /ebsco_search/ https://search.ebscohost.com/
   
    ProxyPassReverse /noodletools/ https://my.noodletools.com/
    RewriteEngine on
    

    #Include conf.d/filter/orcFilter.inc

    ProxyPassReverseCookieDomain ebsco.com .orc.scoolaid.net
    #ProxyPassReverseCookieDomain .ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain flipster.ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookieDomain .flipster.ebsco.com .orc.scoolaid.net
    ProxyPassReverseCookiePath / /
  
    Include conf.d/orc/vendor/inc/ebsco/search_orcDBId.inc

    RewriteRule   ^/logon_zone/(.*)  https://logon-ebsco-zone-${SYSCODE}.orc.scoolaid.net/$1 [R]
    RewriteRule   ^/logon_zone_api/(.*)  https://logon-ebsco-zone-${SYSCODE}.orc.scoolaid.net/api/$1 [R]
    RewriteRule   ^/ebsco_search/(.*)  https://search-ebscohost-${SYSCODE}.orc.scoolaid.net/$1 [NE,R] 
    
    #RewriteCond %{QUERY_STRING} (dbId)=(.*)
    #RewriteRule   ^/(.*) - [CO=orcDbId:%2:.orc.scoolaid.net,CO=dbCode:%2:.orc.scoolaid.net,E=CURDBID:%2]
    RewriteRule   ^/(.*) - [CO=orcDbId:435:.orc.scoolaid.net,CO=dbCode:eon:.orc.scoolaid.net,E=CURDBID:435]
    #Header set Access-Control-Allow-Origin "*.ebsco.com" env=cors
    #Header set Access-Control-Allow-Origin "*.ebscohost.com" env=cors
    
    <Location />
        SetOutputFilter    proxy-html
        AddOutputFilterByType SUBSTITUTE text/plain text/html application/json application/javascript application/xml application/xhtml
        Substitute "s|https://search.ebscohost.com|https://search-ebscohost-${SYSCODE}.orc.scoolaid.net|i"
        Header set Access-Control-Allow-Origin "*"
        RequestHeader     unset   Accept-Encoding
    </Location>
    <Location /c>
        #AddOutputFilterByType DEFLATE application/json 
        SetOutputFilter INFLATE;DEFLATE
        SubstituteMaxLineLength 50M
        #AddOutputFilterByType SUBSTITUTE text/plain text/html application/json application/javascript application/xml application/xhtml
        Substitute "s|https://search.ebscohost.com|https://search-ebscohost-${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|flipster.ebsco.com|flipster-ebsco-${SYSCODE}.orc.scoolaid.net|i"
        Header set Access-Control-Allow-Origin "*"
        RequestHeader     unset   Accept-Encoding
    </Location>

    ProxyRequests Off 
