    ProxyRequests On  
    #ProxyVia On
    
    SetEnv proxy-initial-not-pooled 1
    
    SetEnv force-proxy-request-1.0 1
    SetEnv proxy-nokeepalive 1
    RequestReadTimeout header=30
    #LogLevel debug

    ProxyPass / http://eds.a.ebscohost.com/
    ProxyPass / http://eds.a.ebscohost.com:80/
    ProxyPass / http://eds.a.ebscohost.com:8080/
    ProxyPassReverse / http://eds.a.ebscohost.com/
    ProxyPassReverse / http://eds.a.ebscohost.com:80/

    ProxyPassReverse /ebsco_search/ http://search.ebscohost.com/
    ProxyPassReverse /ebsco_search_ssl/ https://search.ebscohost.com/
    ProxyPassReverse /ebsco_eoncontent/ http://eoncontent.ebscohost.com/
    
    ProxyPassReverse /ebsco_cloud/ http://content.ebscohost.com/

    RewriteEngine on

    RewriteCond %{SERVER_NAME}  ^(.+)\.(.+)\.(orc.scoolaid.net)$ [NC]
    RewriteRule    (.*)\ (.*)\ (.*)     $1\%2520$2\%2520$3
   
    Include conf.d/filter/orcFilter.inc


    ProxyPassReverseCookieDomain ebscohost.com ebscohost.${SYSCODE}.orc.scoolaid.net
    ProxyPassReverseCookieDomain .ebscohost.com .ebscohost.${SYSCODE}.orc.scoolaid.net
    ProxyPassReverseCookieDomain eds.a.ebscohost.com eds.a.ebscohost.${SYSCODE}.orc.scoolaid.net
    ProxyPassReverseCookiePath / /
    
    RewriteRule   ^/ebsco_search/(.*)  http://search.ebscohost.${SYSCODE}.orc.scoolaid.net/$1 
    RewriteRule   ^/ebsco_search_ssl/(.*)  https://search-ebscohost-${SYSCODE}.orc.scoolaid.net/$1 
    RewriteRule   ^/ebsco_eoncontent/(.*)  http://eoncontent.ebscohost.${SYSCODE}.orc.scoolaid.net/$1 [P]
    RewriteRule   ^/ebsco_content/(.*)  http://content.ebscohost.${SYSCODE}.orc.scoolaid.net/$1 [P]
    
    RewriteRule   ^/(.*) - [CO=orcDbId:657:.orc.scoolaid.net,E=CURDBID:657]

    ProxyHTMLDoctype "<!DOCTYPE html>" XML

    <Location /ehost/>
      ProxyHTMLCharsetOut *
      SetOutputFilter INFLATE;proxy-html;DEFLATE
      SubstituteMaxLineLength 10m
      #SetOutputFilter    proxy-html
      #SetOutputFilter INFLATE
      #SubstituteMaxLineLength 10m
      AddOutputFilterByType SUBSTITUTE text/x-js text/plain text/html application/json application/javascript application/xml application/xhtml+xml application/octet-stream
      Substitute "s|http://eds.a.ebscohost.com|http://eds.a.ebscohost.${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|http://web.b.ebscohost.com|http://web.b.ebscohost.${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|http://search.ebscohost.com|http://search.ebscohost.${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|https://video.ebscohost.com|https://video-ebscohost-${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|galegroup.com|gale.${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|search.proquest.com|search.proquest.${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|http://www.jstor.org|jstor.${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|https://www.jstor.org|https://jstor-${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|repere.sdm.qc.ca|repere.sdm.${SYSCODE}.orc.scoolaid.net|i"
      Substitute "s|search.proquest.jac|search-proquest-${SYSCODE}|i"
      RequestHeader     unset   Accept-Encoding
    </Location>

    <Location />
        #SetOutputFilter    proxy-html
        #AddDefaultCharset utf-8
        SetOutputFilter    INFLATE;proxy-html;DEFLATE
        #SetOutputFilter INFLATE
        SubstituteMaxLineLength 10m
        AddOutputFilterByType SUBSTITUTE text/x-js text/plain text/html application/json application/javascript application/xml application/xhtml+xml application/octet-stream
        #Substitute "s|ebsco-content.com|ebsco-content.${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|http://eds.a.ebscohost.com|http://eds.a.ebscohost.${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|http://web.b.ebscohost.com|http://web.b.ebscohost.${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|http://search.ebscohost.com|http://search.ebscohost.${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|galegroup.com|gale.${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|search.proquest.com|search.proquest.${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|www.jstor.org|jstor-${SYSCODE}.orc.scoolaid.net|i"
        Substitute "s|repere.sdm.qc.ca|repere.sdm.${SYSCODE}.orc.scoolaid.net|i"
	      Substitute "s|search.proquest.jac|search-proquest-${SYSCODE}|i"
	      Substitute "s|www.choicereviews.org|choicereviews.${SYSCODE}.orc.scoolaid.net|i"
        RequestHeader     unset   Accept-Encoding
    </Location>
    
    ProxyRequests Off

